/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.logic;

import blusunrize.immersiveengineering.api.fluid.FluidUtils;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IMultiblockComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.client.utils.TextUtils;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.interfaces.MBMemorizeStructure;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.interfaces.MBOverlayText;
import blusunrize.immersiveengineering.common.blocks.multiblocks.shapes.SiloTankShapes;
import blusunrize.immersiveengineering.common.fluids.ArrayFluidHandler;
import blusunrize.immersiveengineering.common.util.LayeredComparatorOutput;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.Nullable;

public class SheetmetalTankLogic
implements IServerTickableComponent<State>,
MBOverlayText<State>,
MBMemorizeStructure<State> {
    private static final SiloTankShapes SHAPE_GETTER = new SiloTankShapes(4, false);
    public static final BlockPos IO_POS = new BlockPos(1, 0, 1);
    private static final BlockPos INPUT_POS = new BlockPos(1, 4, 1);

    @Override
    public void tickServer(IMultiblockContext<State> context) {
        State state = context.getState();
        state.comparatorHelper.update(context, state.tank.getFluidAmount());
        if (!state.rsState.isEnabled(context) || state.tank.isEmpty()) {
            return;
        }
        for (Supplier<IFluidHandler> outputRef : state.outputs) {
            int accepted;
            int outSize = Math.min(1000, state.tank.getFluidAmount());
            FluidStack out = state.tank.getFluid().copyWithAmount(outSize);
            IFluidHandler output = outputRef.get();
            if (output == null || (accepted = output.fill(out, IFluidHandler.FluidAction.SIMULATE)) <= 0) continue;
            int drained = output.fill(out.copyWithAmount(Math.min(out.getAmount(), accepted)), IFluidHandler.FluidAction.EXECUTE);
            state.tank.drain(drained, IFluidHandler.FluidAction.EXECUTE);
            context.markMasterDirty();
            context.requestMasterBESync();
            if (!state.tank.isEmpty()) continue;
            break;
        }
    }

    @Override
    public State createInitialState(IInitialMultiblockContext<State> capabilitySource) {
        return new State(capabilitySource);
    }

    @Override
    public void registerCapabilities(IMultiblockComponent.CapabilityRegistrar<State> register) {
        register.register(Capabilities.FluidHandler.BLOCK, (state, position) -> {
            if (IO_POS.equals((Object)position.posInMultiblock())) {
                return state.ioHandler;
            }
            if (INPUT_POS.equals((Object)position.posInMultiblock())) {
                return state.inputHandler;
            }
            return null;
        });
    }

    @Override
    @Nullable
    public List<Component> getOverlayText(State state, Player player, boolean hammer) {
        if (Utils.isFluidRelatedItemStack(player.getItemInHand(InteractionHand.MAIN_HAND))) {
            return List.of(TextUtils.formatFluidStack(state.tank.getFluid()));
        }
        return null;
    }

    @Override
    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType forType) {
        return SHAPE_GETTER;
    }

    @Override
    public ItemInteractionResult click(IMultiblockContext<State> ctx, BlockPos posInMultiblock, Player player, InteractionHand hand, BlockHitResult absoluteHit, boolean isClient) {
        if (FluidUtils.interactWithFluidHandler(player, hand, (IFluidHandler)ctx.getState().tank)) {
            ctx.markDirtyAndSync();
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Override
    public void setMemorizedBlockState(State state, BlockPos pos, BlockState blockState) {
        state.structureMemo.put(pos, blockState);
    }

    @Override
    public BlockState getMemorizedBlockState(State state, BlockPos pos) {
        return (BlockState)state.structureMemo.get(pos);
    }

    public static class State
    implements IMultiblockState {
        public final FluidTank tank = new FluidTank(512000);
        private final LayeredComparatorOutput<IMultiblockContext<?>> comparatorHelper;
        private final List<Supplier<@Nullable IFluidHandler>> outputs;
        private final IFluidHandler inputHandler;
        private final IFluidHandler ioHandler;
        public final RedstoneControl.RSState rsState = RedstoneControl.RSState.disabledByDefault();
        private final MBMemorizeStructure.StructureMemo structureMemo = new MBMemorizeStructure.StructureMemo();

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public State(IInitialMultiblockContext<State> capabilitySource) {
            this.comparatorHelper = LayeredComparatorOutput.makeForSiloLike(this.tank.getCapacity(), 4);
            // Could not load outer class - annotation placement on inner may be incorrect
            @Nullable ImmutableList.Builder outputBuilder = ImmutableList.builder();
            for (RelativeBlockFace face : RelativeBlockFace.values()) {
                if (face == RelativeBlockFace.DOWN) continue;
                BlockPos neighbor = face.offsetRelative(IO_POS, -1);
                outputBuilder.add(capabilitySource.getCapabilityAt(Capabilities.FluidHandler.BLOCK, neighbor, face));
            }
            this.outputs = outputBuilder.build();
            Runnable changedAndSync = () -> {
                capabilitySource.getSyncRunnable().run();
                capabilitySource.getMarkDirtyRunnable().run();
            };
            this.inputHandler = new ArrayFluidHandler((IFluidTank)this.tank, false, true, changedAndSync);
            this.ioHandler = new ArrayFluidHandler((IFluidTank)this.tank, true, true, changedAndSync);
        }

        @Override
        public void writeSaveNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            nbt.put("tank", (Tag)this.tank.writeToNBT(provider, new CompoundTag()));
            this.structureMemo.writeSaveNBT(nbt, provider);
        }

        @Override
        public void readSaveNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            this.tank.readFromNBT(provider, nbt.getCompound("tank"));
            this.structureMemo.readSaveNBT(nbt, provider);
        }

        @Override
        public void writeSyncNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            this.writeSaveNBT(nbt, provider);
        }

        @Override
        public void readSyncNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            this.readSaveNBT(nbt, provider);
        }
    }
}

