/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.logic;

import blusunrize.immersiveengineering.api.crafting.BlastFurnaceFuel;
import blusunrize.immersiveengineering.api.crafting.BlastFurnaceRecipe;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MBInventoryUtils;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IEMultiblocks;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.FurnaceHandler;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.NonMirrorableWithActiveBlock;
import blusunrize.immersiveengineering.common.util.CachedRecipe;
import blusunrize.immersiveengineering.common.util.inventory.SlotwiseItemHandler;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;

public class BlastFurnaceLogic
implements IMultiblockLogic<State>,
IServerTickableComponent<State> {
    public static final int NUM_SLOTS = 4;

    @Override
    public void tickServer(IMultiblockContext<State> context) {
        IMultiblockLevel level = context.getLevel();
        Boolean wasActive = (Boolean)level.getBlockState(IEMultiblocks.BLAST_FURNACE.getMasterFromOriginOffset()).getValue(NonMirrorableWithActiveBlock.ACTIVE);
        boolean active = context.getState().furnace.tickServer(context);
        if (active != wasActive) {
            NonMirrorableWithActiveBlock.setActive(level, IEMultiblocks.BLAST_FURNACE, active);
        }
    }

    @Override
    public State createInitialState(IInitialMultiblockContext<State> capabilitySource) {
        return new State(capabilitySource);
    }

    @Override
    public void dropExtraItems(State state, Consumer<ItemStack> drop) {
        MBInventoryUtils.dropItems(state.inventory, drop);
    }

    @Override
    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType forType) {
        return $ -> Shapes.block();
    }

    public static class State
    implements IMultiblockState,
    FurnaceHandler.IFurnaceEnvironment<BlastFurnaceRecipe> {
        private final SlotwiseItemHandler inventory;
        final FurnaceHandler<BlastFurnaceRecipe> furnace;
        private final Supplier<BlastFurnaceRecipe> cachedRecipe;

        public State(IInitialMultiblockContext<?> ctx) {
            Supplier<@Nullable Level> getLevel = ctx.levelSupplier();
            this.inventory = new SlotwiseItemHandler(List.of(new SlotwiseItemHandler.IOConstraint(true, i -> BlastFurnaceRecipe.findRecipe((Level)getLevel.get(), i, null) != null), new SlotwiseItemHandler.IOConstraint(true, i -> BlastFurnaceFuel.isValidBlastFuel((Level)getLevel.get(), i)), SlotwiseItemHandler.IOConstraint.OUTPUT, SlotwiseItemHandler.IOConstraint.OUTPUT), ctx.getMarkDirtyRunnable());
            this.furnace = new FurnaceHandler<BlastFurnaceRecipe>(1, List.of(new FurnaceHandler.InputSlot<BlastFurnaceRecipe>(r -> r.input, 0)), List.of(new FurnaceHandler.OutputSlot<BlastFurnaceRecipe>(r -> r.output, 2), new FurnaceHandler.OutputSlot<BlastFurnaceRecipe>(r -> r.slag, 3)), r -> r.time, ctx.getMarkDirtyRunnable());
            this.cachedRecipe = CachedRecipe.cached(BlastFurnaceRecipe::findRecipe, getLevel, () -> this.inventory.getStackInSlot(0));
        }

        @Override
        public void writeSaveNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            nbt.put("inventory", this.inventory.serializeNBT(provider));
            nbt.put("furnace", this.furnace.toNBT());
        }

        @Override
        public void readSaveNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            this.inventory.deserializeNBT(provider, nbt.getCompound("inventory"));
            this.furnace.readNBT(nbt.get("furnace"));
        }

        @Override
        public IItemHandlerModifiable getInventory() {
            return this.inventory;
        }

        @Override
        @Nullable
        public BlastFurnaceRecipe getRecipeForInput() {
            return this.cachedRecipe.get();
        }

        @Override
        public int getBurnTimeOf(Level level, ItemStack fuel) {
            return BlastFurnaceFuel.getBlastFuelTime(level, fuel);
        }

        public ContainerData getStateView() {
            return this.furnace.stateView;
        }
    }
}

