/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlock;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LanternBlock
extends IEBaseBlock {
    public static final Supplier<BlockBehaviour.Properties> PROPERTIES = () -> BlockBehaviour.Properties.of().mapColor(MapColor.METAL).sound(SoundType.METAL).strength(3.0f, 15.0f).lightLevel(b -> 14).noOcclusion();
    public static final Property<Direction> FACING = IEProperties.FACING_ALL;
    private static final Map<Direction, VoxelShape> SHAPES = ImmutableMap.builder().put((Object)Direction.DOWN, (Object)Shapes.box((double)0.25, (double)0.125, (double)0.25, (double)0.75, (double)1.0, (double)0.75)).put((Object)Direction.UP, (Object)Shapes.box((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.875, (double)0.75)).put((Object)Direction.NORTH, (Object)Shapes.box((double)0.25, (double)0.0625, (double)0.25, (double)0.75, (double)0.875, (double)1.0)).put((Object)Direction.EAST, (Object)Shapes.box((double)0.0, (double)0.0625, (double)0.25, (double)0.75, (double)0.875, (double)0.75)).put((Object)Direction.SOUTH, (Object)Shapes.box((double)0.25, (double)0.0625, (double)0.0, (double)0.75, (double)0.875, (double)0.75)).put((Object)Direction.WEST, (Object)Shapes.box((double)0.25, (double)0.0625, (double)0.25, (double)1.0, (double)0.875, (double)0.75)).build();

    public LanternBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, BlockStateProperties.WATERLOGGED});
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPES.get(state.getValue(FACING));
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)context.getClickedFace());
    }
}

