/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.client.utils.TextUtils;
import blusunrize.immersiveengineering.common.blocks.BlockCapabilityRegistration;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.ticking.IEServerTickableBE;
import blusunrize.immersiveengineering.common.config.IEClientConfig;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.TreeMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class FluidPlacerBlockEntity
extends IEBaseBlockEntity
implements IEServerTickableBE,
IEBlockInterfaces.IConfigurableSides,
IEBlockInterfaces.IBlockOverlayText,
IEBlockInterfaces.IScrewdriverInteraction {
    private final Map<Direction, IEEnums.IOSideConfig> sideConfig = new EnumMap<Direction, IEEnums.IOSideConfig>(Direction.class);
    public FluidTank tank;
    public boolean redstoneControlInverted;
    private int tickCount;
    private final HashSet<BlockPos> checkedPositions;
    private final TreeMap<Integer, Queue<BlockPos>> layeredPlacementQueue;
    private final Queue<BlockPos> tempFluids;
    private final IFluidHandler tankCap;

    public FluidPlacerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)IEBlockEntities.FLUID_PLACER.get(), pos, state);
        for (Direction d : DirectionUtils.VALUES) {
            this.sideConfig.put(d, IEEnums.IOSideConfig.OUTPUT);
        }
        this.sideConfig.put(Direction.UP, IEEnums.IOSideConfig.INPUT);
        this.tank = new FluidTank(4000);
        this.redstoneControlInverted = false;
        this.tickCount = 0;
        this.checkedPositions = new HashSet();
        this.layeredPlacementQueue = new TreeMap();
        this.tempFluids = new LinkedList<BlockPos>();
        this.tankCap = this.makeFluidInput(new IFluidTank[]{this.tank});
    }

    @Override
    public void tickServer() {
        if (this.isRSPowered() ^ this.redstoneControlInverted) {
            return;
        }
        if (this.tickCount % 16 == 0) {
            if (this.tickCount % 512 == 0) {
                this.prepareAreaCheck();
            }
            if (this.tank.getFluidAmount() >= 1000 && !this.layeredPlacementQueue.isEmpty()) {
                Queue<BlockPos> lowestLayer = this.layeredPlacementQueue.firstEntry().getValue();
                if (lowestLayer == null || lowestLayer.isEmpty()) {
                    this.layeredPlacementQueue.pollFirstEntry();
                } else {
                    BlockPos targetPos = lowestLayer.poll();
                    if (this.canFill(targetPos) && this.tank.getFluid().getFluid().getFluidType().canBePlacedInLevel((BlockAndTintGetter)this.level, targetPos, this.tank.getFluid()) && FluidPlacerBlockEntity.place(targetPos, this.tank, this.level)) {
                        this.addConnectedSpaces(targetPos);
                        this.handleTempFluids();
                    }
                }
            }
        }
        ++this.tickCount;
    }

    private static boolean place(BlockPos pos, FluidTank tank, Level world) {
        if (tank.getFluidAmount() < 1000) {
            return false;
        }
        FluidStack stack = tank.getFluid();
        Item bucket = stack.getFluid().getBucket();
        if (!(bucket instanceof BucketItem)) {
            return false;
        }
        BucketItem bucketitem = (BucketItem)bucket;
        if (bucketitem == Items.AIR) {
            return false;
        }
        ItemStack bucketStack = new ItemStack((ItemLike)bucketitem);
        if (bucketitem.emptyContents(null, world, pos, null)) {
            tank.drain(1000, IFluidHandler.FluidAction.EXECUTE);
            bucketitem.checkExtraContent(null, world, bucketStack, pos);
            return true;
        }
        return false;
    }

    private void prepareAreaCheck() {
        this.checkedPositions.clear();
        this.layeredPlacementQueue.clear();
        this.tempFluids.clear();
        this.addConnectedSpaces(this.getBlockPos());
        this.handleTempFluids();
    }

    private Queue<BlockPos> getQueueForYLevel(int yLevel) {
        return this.layeredPlacementQueue.computeIfAbsent(yLevel, k -> new LinkedList());
    }

    private void addConnectedSpaces(BlockPos pos) {
        for (Direction facing : Direction.values()) {
            if (facing == Direction.UP || pos == this.getBlockPos() && this.sideConfig.get(facing) != IEEnums.IOSideConfig.OUTPUT) continue;
            this.addToQueue(pos.relative(facing));
        }
    }

    private void addToQueue(BlockPos pos) {
        if (!this.getLevelNonnull().isOutsideBuildHeight(pos) && this.checkedPositions.add(pos) && pos.distSqr((Vec3i)this.getBlockPos()) < 4096.0) {
            if (this.fluidMatches(pos)) {
                this.tempFluids.add(pos);
            }
            if (this.canFill(pos)) {
                this.getQueueForYLevel(pos.getY()).add(pos);
            }
        }
    }

    private boolean fluidMatches(BlockPos targetPos) {
        if (!this.level.isAreaLoaded(targetPos, 1) || this.tank.getFluid().isEmpty()) {
            return false;
        }
        BlockState state = this.level.getBlockState(targetPos);
        return state.getFluidState().getType() == this.tank.getFluid().getFluid();
    }

    private boolean canFill(BlockPos targetPos) {
        Block block;
        boolean canFill;
        if (!this.level.isAreaLoaded(targetPos, 1)) {
            return false;
        }
        BlockState state = this.level.getBlockState(targetPos);
        if (this.isFullFluidBlock(targetPos, state)) {
            return false;
        }
        boolean bl = canFill = !state.isSolid();
        if (!canFill && (block = state.getBlock()) instanceof LiquidBlockContainer) {
            LiquidBlockContainer container = (LiquidBlockContainer)block;
            canFill = container.canPlaceLiquid(null, (BlockGetter)this.level, targetPos, state, this.tank.getFluid().getFluid());
        }
        return canFill;
    }

    private void handleTempFluids() {
        while (!this.tempFluids.isEmpty()) {
            this.addConnectedSpaces(this.tempFluids.poll());
        }
    }

    private boolean isFullFluidBlock(BlockPos pos, BlockState state) {
        return state.getFluidState().isSource();
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        CompoundTag sideConfigNBT = nbt.getCompound("sideConfig");
        for (Direction d : DirectionUtils.VALUES) {
            this.sideConfig.put(d, IEEnums.IOSideConfig.VALUES[sideConfigNBT.getInt(d.getSerializedName())]);
        }
        this.tank.readFromNBT(provider, nbt.getCompound("tank"));
        this.redstoneControlInverted = nbt.getBoolean("redstoneInverted");
        if (descPacket) {
            this.markContainingBlockForUpdate(null);
        }
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        CompoundTag sideConfigNBT = new CompoundTag();
        for (Direction d : DirectionUtils.VALUES) {
            sideConfigNBT.putInt(d.getSerializedName(), this.sideConfig.get(d).ordinal());
        }
        nbt.put("sideConfig", (Tag)sideConfigNBT);
        nbt.putBoolean("redstoneInverted", this.redstoneControlInverted);
        nbt.put("tank", (Tag)this.tank.writeToNBT(provider, new CompoundTag()));
    }

    @Override
    public IEEnums.IOSideConfig getSideConfig(Direction side) {
        return this.sideConfig.get(side);
    }

    @Override
    public boolean toggleSide(Direction side, Player p) {
        this.sideConfig.computeIfPresent(side, (s, conf) -> IEEnums.IOSideConfig.next(conf));
        this.prepareAreaCheck();
        this.setChanged();
        this.markContainingBlockForUpdate(null);
        this.level.blockEvent(this.getBlockPos(), this.getBlockState().getBlock(), 0, 0);
        return true;
    }

    @Override
    public ItemInteractionResult screwdriverUseSide(Direction side, Player player, InteractionHand hand, Vec3 hitVec) {
        if (!this.level.isClientSide) {
            this.redstoneControlInverted = !this.redstoneControlInverted;
            player.displayClientMessage((Component)Component.translatable((String)("chat.immersiveengineering.info.rsControl." + (this.redstoneControlInverted ? "invertedOn" : "invertedOff"))), true);
            this.setChanged();
            this.markContainingBlockForUpdate(null);
        }
        return ItemInteractionResult.SUCCESS;
    }

    public static void registerCapabilities(BlockCapabilityRegistration.BECapabilityRegistrar<FluidPlacerBlockEntity> registrar) {
        registrar.register(Capabilities.FluidHandler.BLOCK, (be, facing) -> facing == null || be.sideConfig.get(facing) == IEEnums.IOSideConfig.INPUT ? be.tankCap : null);
    }

    @Override
    public Component[] getOverlayText(Player player, HitResult rtr, boolean hammer) {
        if (hammer && ((Boolean)IEClientConfig.showTextOverlay.get()).booleanValue() && rtr instanceof BlockHitResult) {
            BlockHitResult brtr = (BlockHitResult)rtr;
            IEEnums.IOSideConfig here = this.sideConfig.get(brtr.getDirection());
            IEEnums.IOSideConfig opposite = this.sideConfig.get(brtr.getDirection().getOpposite());
            return TextUtils.sideConfigWithOpposite("desc.immersiveengineering.info.blockSide.connectFluid.", here, opposite);
        }
        return null;
    }

    @Override
    public boolean useNixieFont(Player player, HitResult mop) {
        return false;
    }
}

