/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.common.blocks.metal.ConnectorRedstoneBlockEntity;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.util.Utils;
import com.mojang.datafixers.util.Pair;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ConnectorProbeBlockEntity
extends ConnectorRedstoneBlockEntity {
    public DyeColor redstoneChannelSending = DyeColor.WHITE;
    public int outputThreshold = 0;
    private int lastOutput = 0;
    private static final Map<Direction.Axis, VoxelShape> SHAPES = (Map)Util.make(new EnumMap(Direction.Axis.class), map -> {
        float wMin = 0.28125f;
        float wMax = 0.71875f;
        map.put(Direction.Axis.X, Shapes.box((double)0.0, (double)0.28125, (double)0.28125, (double)1.0, (double)0.71875, (double)0.71875));
        map.put(Direction.Axis.Y, Shapes.box((double)0.28125, (double)0.0, (double)0.28125, (double)0.71875, (double)1.0, (double)0.71875));
        map.put(Direction.Axis.Z, Shapes.box((double)0.28125, (double)0.28125, (double)0.0, (double)0.71875, (double)0.71875, (double)1.0));
    });

    public ConnectorProbeBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType<? extends ConnectorRedstoneBlockEntity>)((BlockEntityType)IEBlockEntities.CONNECTOR_PROBE.get()), pos, state);
    }

    @Override
    public void tickServer() {
        super.tickServer();
        if (this.level.getGameTime() % 8L == (long)((this.getBlockPos().getX() ^ this.getBlockPos().getZ()) & 7)) {
            int out = this.getComparatorSignal();
            int n = out = out >= this.outputThreshold ? out : 0;
            if (out != this.lastOutput) {
                this.lastOutput = out;
                this.rsDirty = true;
            }
        }
    }

    @Override
    public boolean isRSInput() {
        return true;
    }

    @Override
    public boolean isRSOutput() {
        return true;
    }

    private int getComparatorSignal() {
        BlockPos pos = this.getBlockPos().relative(this.getFacing());
        BlockState state = this.level.getBlockState(pos);
        if (state.hasAnalogOutputSignal()) {
            return state.getAnalogOutputSignal(this.level, pos);
        }
        if (state.isRedstoneConductor((BlockGetter)this.level, pos)) {
            ItemFrame entityitemframe;
            state = this.level.getBlockState(pos = pos.relative(this.getFacing()));
            if (state.hasAnalogOutputSignal()) {
                return state.getAnalogOutputSignal(this.level, pos);
            }
            if (state.isAir() && (entityitemframe = this.findItemFrame(this.level, this.getFacing(), pos)) != null) {
                return entityitemframe.getAnalogOutput();
            }
        }
        return 0;
    }

    private ItemFrame findItemFrame(Level world, Direction facing, BlockPos pos) {
        List list = world.getEntitiesOfClass(ItemFrame.class, new AABB(pos), entity -> entity != null && entity.getDirection() == facing);
        return list.size() == 1 ? (ItemFrame)list.get(0) : null;
    }

    @Override
    public void updateInput(byte[] signals, ConnectionPoint cp) {
        signals[this.redstoneChannelSending.ordinal()] = (byte)this.lastOutput;
        this.rsDirty = false;
    }

    @Override
    public ItemInteractionResult screwdriverUseSide(Direction side, Player player, InteractionHand hand, Vec3 hitVec) {
        if (this.level.isClientSide) {
            ImmersiveEngineering.proxy.openTileScreen("redstoneprobe", this);
        }
        return ItemInteractionResult.SUCCESS;
    }

    @Override
    public void receiveMessageFromClient(CompoundTag message) {
        if (message.contains("redstoneChannel")) {
            this.redstoneChannel = DyeColor.byId((int)message.getInt("redstoneChannel"));
        }
        if (message.contains("redstoneChannelSending")) {
            this.redstoneChannelSending = DyeColor.byId((int)message.getInt("redstoneChannelSending"));
        }
        if (message.contains("outputThreshold")) {
            this.outputThreshold = message.getInt("outputThreshold");
        }
        this.updateAfterConfigure();
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        super.writeCustomNBT(nbt, descPacket, provider);
        nbt.putInt("redstoneChannelSending", this.redstoneChannelSending.getId());
        nbt.putInt("outputThreshold", this.outputThreshold);
    }

    @Override
    public void readCustomNBT(@Nonnull CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        super.readCustomNBT(nbt, descPacket, provider);
        this.redstoneChannelSending = DyeColor.byId((int)nbt.getInt("redstoneChannelSending"));
        this.outputThreshold = nbt.getInt("outputThreshold");
    }

    @Override
    public Vec3 getConnectionOffset(ConnectionPoint here, ConnectionPoint other, WireType type) {
        Direction side = this.getFacing().getOpposite();
        double conRadius = type.getRenderDiameter() / 2.0;
        return new Vec3(0.5 + (double)side.getStepX() * (0.375 - conRadius), 0.5 + (double)side.getStepY() * (0.375 - conRadius), 0.5 + (double)side.getStepZ() * (0.375 - conRadius));
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable CollisionContext ctx) {
        return SHAPES.get(this.getFacing().getAxis());
    }

    @Override
    public Pair<DyeColor, Byte>[] overrideVoltmeterRead() {
        return new Pair[]{Pair.of((Object)this.redstoneChannel, (Object)((byte)this.output)), Pair.of((Object)this.redstoneChannelSending, (Object)((byte)this.lastOutput))};
    }

    @Override
    public Component[] getOverlayText(Player player, HitResult mop, boolean hammer) {
        if (Utils.isScrewdriver(player.getMainHandItem())) {
            return new Component[]{ConnectorProbeBlockEntity.getChannelComponent("_receiving", this.redstoneChannel), ConnectorProbeBlockEntity.getChannelComponent("_sending", this.redstoneChannelSending)};
        }
        return null;
    }

    @Override
    public boolean useNixieFont(Player player, HitResult mop) {
        return false;
    }
}

