/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.generic;

import blusunrize.immersiveengineering.api.utils.shapes.CachedVoxelShapes;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlock;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.ArrayList;
import java.util.EnumMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CatwalkBlock
extends IEBaseBlock
implements IEBlockInterfaces.IColouredBlock {
    public static final EnumMap<Direction, BooleanProperty> RAILING_PROPERTIES = new EnumMap(Direction.class);
    protected static final EnumProperty<DyeColor> DYE_PROPERTY;
    protected final boolean isDyeable;
    private static final CachedVoxelShapes<RailingsKey> SHAPES;

    public CatwalkBlock(BlockBehaviour.Properties blockProps, boolean isDyeable) {
        super(blockProps);
        this.isDyeable = isDyeable;
        this.lightOpacity = 0;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{DYE_PROPERTY, BlockStateProperties.WATERLOGGED}).add((Property[])RAILING_PROPERTIES.values().toArray(BooleanProperty[]::new)).add(new Property[0]);
    }

    @Override
    protected BlockState getInitDefaultState() {
        BlockState ret = super.getInitDefaultState();
        for (BooleanProperty prop : RAILING_PROPERTIES.values()) {
            ret = (BlockState)ret.setValue((Property)prop, (Comparable)Boolean.valueOf(false));
        }
        if (this.isDyeable) {
            ret = (BlockState)ret.setValue(DYE_PROPERTY, (Comparable)DyeColor.WHITE);
        }
        return ret;
    }

    @Override
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (this.isDyeable && Utils.isDye(stack)) {
            DyeColor dye = Utils.getDye(stack);
            if (dye != null) {
                world.setBlock(pos, (BlockState)state.setValue(DYE_PROPERTY, (Comparable)dye), 3);
            }
            return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return super.useItemOn(stack, state, world, pos, player, hand, hit);
    }

    @Override
    public ItemInteractionResult hammerUseSide(Direction side, Player player, InteractionHand hand, Level w, BlockPos pos, BlockHitResult hit) {
        if (player.isShiftKeyDown()) {
            Vec3 hitVec = hit.getLocation().subtract(Vec3.atCenterOf((Vec3i)pos));
            Direction target = hitVec.x * hitVec.x > hitVec.z * hitVec.z ? (hitVec.x < 0.0 ? Direction.WEST : Direction.EAST) : (hitVec.z < 0.0 ? Direction.NORTH : Direction.SOUTH);
            BooleanProperty prop = RAILING_PROPERTIES.get(target);
            if (prop != null) {
                BlockState state;
                w.setBlock(pos, (BlockState)state.setValue((Property)prop, (Comparable)Boolean.valueOf((Boolean)(state = w.getBlockState(pos)).getValue((Property)prop) == false)), 3);
                return ItemInteractionResult.sidedSuccess((boolean)w.isClientSide);
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Override
    public boolean hasCustomBlockColours() {
        return this.isDyeable;
    }

    @Override
    public int getRenderColour(BlockState state, @Nullable BlockGetter worldIn, @Nullable BlockPos pos, int tintIndex) {
        if (this.isDyeable && tintIndex == 1) {
            return ((DyeColor)state.getValue(DYE_PROPERTY)).getTextColor();
        }
        return 0xFFFFFF;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPES.get(new RailingsKey(state, false));
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPES.get(new RailingsKey(state, true));
    }

    static {
        RAILING_PROPERTIES.put(Direction.NORTH, PipeBlock.NORTH);
        RAILING_PROPERTIES.put(Direction.EAST, PipeBlock.EAST);
        RAILING_PROPERTIES.put(Direction.SOUTH, PipeBlock.SOUTH);
        RAILING_PROPERTIES.put(Direction.WEST, PipeBlock.WEST);
        DYE_PROPERTY = EnumProperty.create((String)"dye", DyeColor.class);
        SHAPES = new CachedVoxelShapes<RailingsKey>(railingsKey -> {
            double height;
            ArrayList<AABB> list = new ArrayList<AABB>();
            list.add(new AABB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0));
            double d = height = railingsKey.collision ? 1.625 : 1.0;
            if (railingsKey.north) {
                list.add(new AABB(0.0, 0.125, 0.0, 1.0, height, 0.0625));
            }
            if (railingsKey.south) {
                list.add(new AABB(0.0, 0.125, 0.9375, 1.0, height, 1.0));
            }
            if (railingsKey.west) {
                list.add(new AABB(0.0, 0.125, 0.0, 0.0625, height, 1.0));
            }
            if (railingsKey.east) {
                list.add(new AABB(0.9375, 0.125, 0.0, 1.0, height, 1.0));
            }
            return list;
        });
    }

    private record RailingsKey(boolean north, boolean east, boolean south, boolean west, boolean collision) {
        public RailingsKey(BlockState blockState, boolean collision) {
            this((Boolean)blockState.getValue((Property)PipeBlock.NORTH), (Boolean)blockState.getValue((Property)PipeBlock.EAST), (Boolean)blockState.getValue((Property)PipeBlock.SOUTH), (Boolean)blockState.getValue((Property)PipeBlock.WEST), collision);
        }
    }
}

