/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.fx;

import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.api.utils.Color4;
import blusunrize.immersiveengineering.client.fx.FractalOptions;
import blusunrize.immersiveengineering.client.utils.IERenderTypes;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class FractalParticle
extends Particle {
    public static final Deque<FractalParticle> PARTICLE_FRACTAL_DEQUE = new ArrayDeque<FractalParticle>();
    public static final Color4[] COLOUR_RED = new Color4[]{new Color4(0.79f, 0.31f, 0.31f, 0.5f), new Color4(1.0f, 0.97f, 0.87f, 0.75f)};
    public static final Color4[] COLOUR_ORANGE = new Color4[]{new Color4(Lib.COLOUR_F_ImmersiveOrange[0], Lib.COLOUR_F_ImmersiveOrange[1], Lib.COLOUR_F_ImmersiveOrange[2], 0.5f), new Color4(1.0f, 0.97f, 0.87f, 0.75f)};
    public static final Color4[] COLOUR_LIGHTNING = new Color4[]{new Color4(0.3019608f, 0.2901961f, 0.59607846f, 0.75f), new Color4(1, 1, 1, 1)};
    private final Vector3f[] pointsList;
    private final Color4 colourOut;
    private final Color4 colourIn;
    private static final Vector3f[] POINT_NORMALS = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f)};

    public FractalParticle(ClientLevel world, double x, double y, double z, double speedX, double speedY, double speedZ, Vec3 direction, double scale, int maxAge, int points, Color4 colourOut, Color4 colourIn) {
        super(world, x, y, z, speedX, speedY, speedZ);
        this.lifetime = maxAge;
        this.xd *= (double)0.009f;
        this.yd *= (double)0.009f;
        this.zd *= (double)0.009f;
        this.colourOut = colourOut;
        this.colourIn = colourIn;
        this.pointsList = new Vector3f[points];
        direction = direction.scale(scale);
        Vec3 startPos = direction.scale(-0.5);
        Vec3 end = direction.scale(0.5);
        Vec3 dist = end.subtract(startPos);
        for (int i = 0; i < points; ++i) {
            Vec3 sub = startPos.add(dist.x / (double)points * (double)i, dist.y / (double)points * (double)i, dist.z / (double)points * (double)i);
            double fixPointDist = (i - points / 2) / (points / 2);
            double mod = scale * 1.0 - 0.45 * Math.abs(fixPointDist);
            double offX = (this.random.nextDouble() - 0.5) * mod;
            double offY = (this.random.nextDouble() - 0.5) * mod;
            double offZ = (this.random.nextDouble() - 0.5) * mod;
            Vec3 pointDouble = sub.add(offX, offY, offZ);
            this.pointsList[i] = new Vector3f((float)pointDouble.x, (float)pointDouble.y, (float)pointDouble.z);
        }
    }

    public void render(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        PARTICLE_FRACTAL_DEQUE.add(this);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.CUSTOM;
    }

    public List<Pair<RenderType, Consumer<VertexConsumer>>> render(float partialTicks, PoseStack matrixStack) {
        float mod = ((float)this.age + partialTicks) / (float)this.lifetime;
        int iStartMut = 0;
        int iEndMut = this.pointsList.length;
        if ((double)mod >= 0.76) {
            float rem = (mod - 0.7599f) % 0.25f * 48.0f / 2.0f;
            iStartMut = (int)((double)iStartMut + Math.ceil(rem));
            iEndMut = (int)((double)iEndMut - Math.floor(rem));
        }
        int iStart = iStartMut;
        int iEnd = iEndMut;
        mod = 0.3f + mod * mod;
        matrixStack.pushPose();
        matrixStack.translate(this.x, this.y, this.z);
        matrixStack.scale(mod, mod, mod);
        matrixStack.mulPose(new Quaternionf().rotateXYZ(0.0f, (float)Math.PI * mod, 0.0f));
        Matrix4f transform = matrixStack.last().pose();
        Matrix3f transformN = matrixStack.last().normal();
        matrixStack.popPose();
        LinePointProcessor putLinePoint = (buffer, i, color) -> {
            int correctIndex = FractalParticle.getCyclicIndexInRange(iStart, iEnd, i);
            Vector3f vecRender = this.pointsList[correctIndex];
            if (i != iStart) {
                Vector3f last = this.pointsList[FractalParticle.getCyclicIndexInRange(iStart, iEnd, i - 1)];
                FractalParticle.renderLinePoint(transformN, transform, vecRender, last, color, buffer, false);
            }
            if (i != iEnd) {
                Vector3f next = this.pointsList[FractalParticle.getCyclicIndexInRange(iStart, iEnd, i + 1)];
                FractalParticle.renderLinePoint(transformN, transform, next, vecRender, color, buffer, true);
            }
        };
        ArrayList<Pair<RenderType, Consumer<VertexConsumer>>> ret = new ArrayList<Pair<RenderType, Consumer<VertexConsumer>>>();
        ret.add(Pair.of((Object)IERenderTypes.getParticleLines(4.0f), buffer -> {
            for (int i = iStart; i <= iEnd; ++i) {
                putLinePoint.draw((VertexConsumer)buffer, i, this.colourOut);
            }
        }));
        ret.add(Pair.of((Object)IERenderTypes.getParticleLines(1.0f), buffer -> {
            for (int i = iStart; i <= iEnd; ++i) {
                putLinePoint.draw((VertexConsumer)buffer, i, this.colourIn);
            }
        }));
        ret.add(Pair.of((Object)IERenderTypes.POINTS, buffer -> {
            for (int i = iStart; i < iEnd; ++i) {
                this.drawPoint((VertexConsumer)buffer, transform, this.pointsList[i], 8.0f, this.colourOut);
            }
        }));
        ret.add(Pair.of((Object)IERenderTypes.POINTS, buffer -> {
            for (int i = iEnd - 1; i >= iStart; --i) {
                this.drawPoint((VertexConsumer)buffer, transform, this.pointsList[i], 2.0f, this.colourIn);
            }
        }));
        return ret;
    }

    private static int getCyclicIndexInRange(int being, int end, int i) {
        return being + Mth.positiveModulo((int)(i - being), (int)(end - being));
    }

    private static void renderLinePoint(Matrix3f transformN, Matrix4f transform, Vector3f start, Vector3f end, Color4 color, VertexConsumer buffer, boolean atStart) {
        Vector3f normal = new Vector3f(start.x() - end.x(), start.y() - end.y(), start.z() - end.z());
        normal.mul((Matrix3fc)transformN);
        normal.normalize();
        Vector3f here = atStart ? start : end;
        buffer.addVertex(transform, here.x(), here.y(), here.z()).setColor(color.r(), color.b(), color.g(), color.a()).setNormal(normal.x(), normal.y(), normal.z());
    }

    private void drawPoint(VertexConsumer builder, Matrix4f transform, Vector3f center, float size, Color4 color) {
        Vector4f vector4f = new Vector4f(center.x(), center.y(), center.z(), 1.0f);
        vector4f.mul((Matrix4fc)transform);
        vector4f.div(vector4f.w);
        for (Vector3f normal : POINT_NORMALS) {
            builder.addVertex(vector4f.x(), vector4f.y(), vector4f.z()).setColor(color.r(), color.b(), color.g(), color.a()).setNormal(normal.x() * size / 200.0f, normal.y() * size / 200.0f, 0.0f);
        }
    }

    private static interface LinePointProcessor {
        public void draw(VertexConsumer var1, int var2, Color4 var3);
    }

    public static class Factory
    implements ParticleProvider<FractalOptions> {
        @Nullable
        public Particle createParticle(FractalOptions typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new FractalParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, typeIn.direction(), typeIn.scale(), typeIn.maxAge(), typeIn.points(), typeIn.colourOut(), typeIn.colourIn());
        }
    }
}

