/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.wires;

import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.api.wires.utils.WireUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;

public class ConnectorBlockEntityHelper {
    public static void onChunkUnload(GlobalWireNetwork globalNet, IImmersiveConnectable iic) {
        globalNet.onConnectorUnload(iic);
    }

    public static void onChunkLoad(IImmersiveConnectable iic, Level world) {
        GlobalWireNetwork.getNetwork(world).onConnectorLoad(iic, world);
    }

    public static void remove(Level world, IImmersiveConnectable iic) {
        GlobalWireNetwork globalNet = GlobalWireNetwork.getNetwork(world);
        if (!world.isClientSide) {
            BlockPos pos = iic.getPosition();
            Consumer<Connection> dropHandler = world.getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS) ? c -> {
                if (!c.isInternal()) {
                    BlockPos end = c.getOtherEnd(c.getEndFor(pos)).position();
                    double dx = (double)pos.getX() + 0.5 + (double)Math.signum(end.getX() - pos.getX());
                    double dy = (double)pos.getY() + 0.5 + (double)Math.signum(end.getY() - pos.getY());
                    double dz = (double)pos.getZ() + 0.5 + (double)Math.signum(end.getZ() - pos.getZ());
                    world.addFreshEntity((Entity)new ItemEntity(world, dx, dy, dz, c.type.getWireCoil((Connection)c)));
                }
            } : c -> {};
            for (ConnectionPoint cp : iic.getConnectionPoints()) {
                globalNet.removeAllConnectionsAt(cp, dropHandler);
            }
        }
        if (world.isClientSide && WireUtils.hasAnyConnections(globalNet, iic)) {
            globalNet.onConnectorUnload(iic);
        } else {
            globalNet.removeConnector(iic);
        }
    }

    public static LocalWireNetwork getLocalNetWithCache(GlobalWireNetwork globalNet, BlockPos pos, int cpIndex, Int2ObjectMap<LocalWireNetwork> cachedLocalNets) {
        LocalWireNetwork ret = (LocalWireNetwork)cachedLocalNets.get(cpIndex);
        ConnectionPoint cp = new ConnectionPoint(pos, cpIndex);
        if (ret == null || !ret.isValid(cp)) {
            ret = globalNet.getLocalNet(cp);
            cachedLocalNets.put(cpIndex, (Object)ret);
        }
        return ret;
    }
}

