/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.utils.codec;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.crafting.Ingredient;

public class IECodecs {
    public static final Codec<NonNullList<Ingredient>> NONNULL_INGREDIENTS = Ingredient.LIST_CODEC.xmap(l -> {
        NonNullList result = NonNullList.create();
        result.addAll((Collection)l);
        return result;
    }, Function.identity());

    public static <E extends Enum<E>> Codec<E> enumCodec(E[] keys) {
        Map reverseLookup = Arrays.stream(keys).collect(Collectors.toMap(Enum::name, Function.identity()));
        return Codec.STRING.xmap(reverseLookup::get, Enum::name);
    }

    public static <K, T> Codec<Map<K, T>> listBasedMap(Codec<K> keyCodec, Codec<T> valueCodec) {
        Codec entryCodec = RecordCodecBuilder.create(inst -> inst.group((App)keyCodec.fieldOf("key").forGetter(Pair::getFirst), (App)valueCodec.fieldOf("value").forGetter(Pair::getSecond)).apply((Applicative)inst, Pair::of));
        return entryCodec.listOf().xmap(IECodecs::listToMap, IECodecs::mapToList);
    }

    public static <E extends Enum<E>, T> Codec<EnumMap<E, T>> listBasedEnumMap(E[] keys, Codec<T> valueCodec) {
        Codec keyCodec = IECodecs.enumCodec(keys);
        return IECodecs.listBasedMap(keyCodec, valueCodec).xmap(EnumMap::new, Function.identity());
    }

    public static <V> Codec<List<V>> directDispatchMap(Function<String, Codec<V>> valueCodec, Function<V, String> getKey) {
        return Codec.dispatchedMap((Codec)Codec.STRING, valueCodec::apply).xmap(m -> List.copyOf(m.values()), s -> {
            HashMap map = new HashMap();
            for (Object v : s) {
                map.put((String)getKey.apply(v), v);
            }
            return map;
        });
    }

    public static <C> Codec<Set<C>> setOf(Codec<C> codec) {
        return codec.listOf().xmap(Set::copyOf, List::copyOf);
    }

    static <K, T> Map<K, T> listToMap(List<Pair<K, T>> l) {
        return l.stream().collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
    }

    static <K, T> List<Pair<K, T>> mapToList(Map<K, T> m) {
        return m.entrySet().stream().map(e -> Pair.of(e.getKey(), e.getValue())).toList();
    }

    public static <T> T fromNbtOrThrow(Codec<T> codec, Tag data) {
        return (T)((Pair)codec.decode((DynamicOps)NbtOps.INSTANCE, (Object)data).getOrThrow()).getFirst();
    }

    public static <T> Tag toNbtOrThrow(Codec<T> codec, T object) {
        return (Tag)codec.encodeStart((DynamicOps)NbtOps.INSTANCE, object).getOrThrow();
    }

    public static <B, T> StreamCodec<B, T> lenientUnitStream(final T value) {
        return new StreamCodec<B, T>(){

            public T decode(B buffer) {
                return value;
            }

            public void encode(B buffer, T value2) {
            }
        };
    }
}

