/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IERecipeTypes;
import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.TagOutput;
import blusunrize.immersiveengineering.api.crafting.cache.CachedRecipeList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.registries.DeferredHolder;

public class BlastFurnaceRecipe
extends IESerializableRecipe {
    public static DeferredHolder<RecipeSerializer<?>, IERecipeSerializer<BlastFurnaceRecipe>> SERIALIZER;
    public static final CachedRecipeList<BlastFurnaceRecipe> RECIPES;
    public final IngredientWithSize input;
    public final TagOutput output;
    @Nonnull
    public final TagOutput slag;
    public final int time;

    public BlastFurnaceRecipe(TagOutput output, IngredientWithSize input, int time, @Nonnull TagOutput slag) {
        super(output, IERecipeTypes.BLAST_FURNACE);
        this.output = output;
        this.input = input;
        this.time = time;
        this.slag = slag;
    }

    protected IERecipeSerializer<BlastFurnaceRecipe> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    public ItemStack getResultItem(HolderLookup.Provider access) {
        return this.output.get();
    }

    public boolean matches(ItemStack input) {
        return this.input.test(input);
    }

    public static BlastFurnaceRecipe findRecipe(Level level, ItemStack input, @Nullable BlastFurnaceRecipe hint) {
        if (input.isEmpty()) {
            return null;
        }
        if (hint != null && hint.matches(input)) {
            return hint;
        }
        for (RecipeHolder<BlastFurnaceRecipe> recipe : RECIPES.getRecipes(level)) {
            if (!((BlastFurnaceRecipe)recipe.value()).matches(input)) continue;
            return (BlastFurnaceRecipe)recipe.value();
        }
        return null;
    }

    static {
        RECIPES = new CachedRecipeList<BlastFurnaceRecipe>(IERecipeTypes.BLAST_FURNACE);
    }
}

