/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.network.item;

import dev.technici4n.moderndynamics.attachment.attached.AttachedAttachment;
import dev.technici4n.moderndynamics.attachment.attached.ItemAttachedIo;
import dev.technici4n.moderndynamics.network.NetworkNode;
import dev.technici4n.moderndynamics.network.item.FailedInsertStrategy;
import dev.technici4n.moderndynamics.network.item.ItemCache;
import dev.technici4n.moderndynamics.network.item.ItemHost;
import dev.technici4n.moderndynamics.network.item.SimulatedInsertionTarget;
import dev.technici4n.moderndynamics.network.item.SimulatedInsertionTargets;
import dev.technici4n.moderndynamics.network.item.TravelingItem;
import dev.technici4n.moderndynamics.pipe.PipeBlockEntity;
import dev.technici4n.moderndynamics.util.ItemVariant;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class ItemPath {
    public final BlockPos startingPos;
    public final BlockPos targetPos;
    public final Direction[] path;
    @Nullable
    private ItemPath reversed;

    public ItemPath(BlockPos startingPos, BlockPos targetPos, Direction[] path) {
        this(startingPos, targetPos, path, null);
    }

    private ItemPath(BlockPos startingPos, BlockPos targetPos, Direction[] path, @Nullable ItemPath reversed) {
        this.startingPos = startingPos;
        this.targetPos = targetPos;
        this.path = path;
        this.reversed = reversed;
    }

    public NetworkNode<ItemHost, ItemCache> getStartingPoint(ServerLevel level) {
        return ItemHost.MANAGER.findNode(level, this.startingPos.relative(this.path[0]));
    }

    public SimulatedInsertionTarget getInsertionTarget(Level world) {
        return SimulatedInsertionTargets.getTarget(world, this.targetPos, this.getTargetBlockSide());
    }

    public Direction getLastDirection() {
        return this.path[this.path.length - 1];
    }

    public Direction getTargetBlockSide() {
        return this.getLastDirection().getOpposite();
    }

    public TravelingItem makeTravelingItem(ItemVariant variant, int amount, double speedMultiplier) {
        return new TravelingItem(variant, amount, this, FailedInsertStrategy.SEND_BACK_TO_SOURCE, speedMultiplier, 0.0);
    }

    @Nullable
    AttachedAttachment getEndAttachment(ServerLevel level) {
        NetworkNode<ItemHost, ItemCache> lastNode = ItemHost.MANAGER.findNode(level, this.targetPos.relative(this.getTargetBlockSide()));
        ItemHost host = lastNode.getHost();
        return host.getAttachment(this.getLastDirection());
    }

    Predicate<ItemVariant> getEndFilter(ServerLevel level) {
        PipeBlockEntity pipe;
        AttachedAttachment attachedAttachment;
        BlockPos endPipe = this.targetPos.relative(this.getTargetBlockSide());
        BlockEntity blockEntity = level.getBlockEntity(endPipe);
        if (blockEntity instanceof PipeBlockEntity && (attachedAttachment = (pipe = (PipeBlockEntity)blockEntity).getAttachment(this.getLastDirection())) instanceof ItemAttachedIo) {
            ItemAttachedIo io = (ItemAttachedIo)attachedAttachment;
            if (!io.isEnabledViaRedstone(pipe)) {
                return v -> false;
            }
            return io::matchesItemFilter;
        }
        return v -> true;
    }

    public ItemPath reversed() {
        if (this.reversed == null) {
            Direction[] reversedPath = new Direction[this.path.length];
            for (int i = 0; i < this.path.length; ++i) {
                reversedPath[this.path.length - i - 1] = this.path[i].getOpposite();
            }
            this.reversed = new ItemPath(this.targetPos, this.startingPos, reversedPath, this);
        }
        return this.reversed;
    }
}

