/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.gui.menu;

import dev.technici4n.moderndynamics.attachment.attached.AttachedIo;
import dev.technici4n.moderndynamics.attachment.upgrade.LoadedUpgrades;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class UpgradeSlot
extends Slot {
    private final AttachedIo io;
    private final int slot;

    public UpgradeSlot(AttachedIo io, int slot, int x, int y) {
        super((Container)new SimpleContainer(new ItemStack[0]), -1, x, y);
        this.io = io;
        this.slot = slot;
    }

    public ItemStack getItem() {
        return this.io.getUpgrade(this.slot);
    }

    public void set(ItemStack stack) {
        this.io.setUpgrade(this.slot, stack);
        this.setChanged();
    }

    public ItemStack remove(int amount) {
        return this.io.removeUpgrade(this.slot, amount);
    }

    public void setChanged() {
        this.io.onUpgradesChanged();
    }

    public boolean mayPlace(ItemStack stack) {
        return this.io.mayPlaceUpgrade(this.slot, stack.getItem());
    }

    public int getMaxStackSize() {
        return this.getMaxStackSize(this.getItem());
    }

    public int getMaxStackSize(ItemStack stack) {
        return LoadedUpgrades.getType(stack.getItem()).getSlotLimit();
    }
}

