/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.data;

import com.google.common.collect.ImmutableMap;
import com.google.common.hash.HashCode;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.technici4n.moderndynamics.init.MdItems;
import dev.technici4n.moderndynamics.util.MdId;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;

public class RecipesProvider
extends RecipeProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final PackOutput packOutput;

    public RecipesProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> registries) {
        super(packOutput, registries);
        this.packOutput = packOutput;
    }

    protected void buildRecipes(RecipeOutput exporter) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)MdItems.ITEM_PIPE, (int)8).pattern("igi").define(Character.valueOf('i'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('g'), (ItemLike)Items.GLASS).unlockedBy("has_ingot", RecipesProvider.has((ItemLike)Items.IRON_INGOT)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)MdItems.FLUID_PIPE, (int)8).pattern("igi").define(Character.valueOf('i'), (ItemLike)Items.COPPER_INGOT).define(Character.valueOf('g'), (ItemLike)Items.GLASS).unlockedBy("has_ingot", RecipesProvider.has((ItemLike)Items.COPPER_INGOT)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)MdItems.INHIBITOR, (int)4).pattern("mnm").define(Character.valueOf('m'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('n'), (ItemLike)Items.IRON_NUGGET).unlockedBy("has_item_pipe", RecipesProvider.has((ItemLike)MdItems.ITEM_PIPE)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)MdItems.WRENCH).pattern(" i ").pattern("lii").pattern("il ").define(Character.valueOf('i'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('l'), (ItemLike)Items.LAPIS_LAZULI).unlockedBy("has_iron", RecipesProvider.has((ItemLike)Items.IRON_INGOT)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)MdItems.ATTRACTOR, (int)1).pattern(" e ").pattern("mrm").pattern(" p ").define(Character.valueOf('e'), (ItemLike)Items.ENDER_PEARL).define(Character.valueOf('m'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('r'), (ItemLike)Items.REDSTONE).define(Character.valueOf('p'), (ItemLike)Items.PAPER).unlockedBy("has_ender_pearl", RecipesProvider.has((ItemLike)Items.ENDER_PEARL)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)MdItems.EXTRACTOR, (int)1).pattern(" h ").pattern("mrm").pattern(" p ").define(Character.valueOf('h'), (ItemLike)Items.HOPPER).define(Character.valueOf('m'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('r'), (ItemLike)Items.REDSTONE).define(Character.valueOf('p'), (ItemLike)Items.PAPER).unlockedBy("has_hopper", RecipesProvider.has((ItemLike)Items.HOPPER)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)MdItems.FILTER, (int)1).pattern(" l ").pattern("mrm").pattern(" p ").define(Character.valueOf('l'), (ItemLike)Items.LAPIS_LAZULI).define(Character.valueOf('m'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('r'), (ItemLike)Items.REDSTONE).define(Character.valueOf('p'), (ItemLike)Items.PAPER).unlockedBy("has_lapis", RecipesProvider.has((ItemLike)Items.LAPIS_LAZULI)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)MdItems.MACHINE_EXTENDER, (int)4).pattern("bbb").pattern("ibf").pattern("bbb").define(Character.valueOf('b'), (ItemLike)Items.IRON_BARS).define(Character.valueOf('i'), (ItemLike)MdItems.ITEM_PIPE).define(Character.valueOf('f'), (ItemLike)MdItems.FLUID_PIPE).unlockedBy("has_item_pipe", RecipesProvider.has((ItemLike)MdItems.ITEM_PIPE)).unlockedBy("has_fluid_pipe", RecipesProvider.has((ItemLike)MdItems.FLUID_PIPE)).save(exporter);
    }

    public CompletableFuture<?> run(CachedOutput output, HolderLookup.Provider registries) {
        this.generateMiCableRecipes(output);
        return super.run(output, registries);
    }

    private void generateMiCableRecipes(CachedOutput output) {
        this.generateMiCableRecipes("lv", "tin_cable", output);
        this.generateMiCableRecipes("mv", "electrum_cable", output);
        this.generateMiCableRecipes("hv", "aluminum_cable", output);
        this.generateMiCableRecipes("ev", "annealed_copper_cable", output);
        this.generateMiCableRecipes("superconductor", "superconductor_cable", output);
    }

    private void generateMiCableRecipes(String cableName, String miCable, CachedOutput output) {
        String mdCableItemId = MdId.of(cableName + "_cable").toString();
        String miCableItemId = "modern_industrialization:" + miCable;
        ModLoadedCondition condition = new ModLoadedCondition("modern_industrialization");
        this.writeRawRecipe(output, MdId.of("cable/%s_from_mi".formatted(cableName)), (Map<String, Object>)ImmutableMap.of((Object)"type", (Object)RecipesProvider.getRecipeTypeId(RecipeSerializer.SHAPELESS_RECIPE), (Object)"ingredients", List.of(ImmutableMap.of((Object)"item", (Object)miCableItemId)), (Object)"result", (Object)ImmutableMap.of((Object)"id", (Object)mdCableItemId, (Object)"count", (Object)4)), new ICondition[]{condition});
        this.writeRawRecipe(output, MdId.of("cable/%s_to_mi".formatted(cableName)), (Map<String, Object>)ImmutableMap.of((Object)"type", (Object)RecipesProvider.getRecipeTypeId(RecipeSerializer.SHAPED_RECIPE), (Object)"pattern", List.of("cc", "cc"), (Object)"key", (Object)ImmutableMap.of((Object)"c", (Object)ImmutableMap.of((Object)"item", (Object)mdCableItemId)), (Object)"result", (Object)ImmutableMap.of((Object)"id", (Object)miCableItemId)), new ICondition[]{condition});
    }

    private void writeRawRecipe(CachedOutput output, ResourceLocation id, Map<String, Object> recipe, ICondition ... conditions) {
        Path path = this.recipePathProvider.json(id);
        Path outputFile = this.packOutput.getOutputFolder(PackOutput.Target.DATA_PACK).resolve(path);
        JsonObject jsonObject = (JsonObject)GSON.toJsonTree(recipe);
        ICondition.writeConditions((DynamicOps)JsonOps.INSTANCE, (JsonObject)jsonObject, Arrays.asList(conditions));
        byte[] content = GSON.toJson((JsonElement)jsonObject).getBytes(StandardCharsets.UTF_8);
        try {
            output.writeIfNeeded(outputFile, content, HashCode.fromBytes((byte[])content));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static String getRecipeTypeId(RecipeSerializer<?> serializer) {
        ResourceLocation serializerId = BuiltInRegistries.RECIPE_SERIALIZER.getKey(serializer);
        Objects.requireNonNull(serializerId, "Serializer " + String.valueOf(serializer) + " is unregistered");
        return serializerId.toString();
    }
}

