/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.block.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.ItemStackConfig;
import dev.ftb.mods.ftbquests.api.FTBQuestsAPI;
import dev.ftb.mods.ftbquests.block.QuestBarrierBlock;
import dev.ftb.mods.ftbquests.block.entity.EditableBlockEntity;
import dev.ftb.mods.ftbquests.client.FTBQuestsClient;
import dev.ftb.mods.ftbquests.net.BlockConfigResponseMessage;
import dev.ftb.mods.ftbquests.registry.ModBlocks;
import dev.ftb.mods.ftbquests.registry.ModDataComponents;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public abstract class BaseBarrierBlockEntity
extends EditableBlockEntity {
    protected String objStr = "";
    protected BlockState camo = null;
    private boolean invisibleWhenOpen = false;
    private ItemStack skin = ItemStack.EMPTY;

    public BaseBarrierBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, BlockEntity blockEntity) {
        if (blockEntity instanceof BaseBarrierBlockEntity) {
            boolean completed;
            BaseBarrierBlockEntity barrier = (BaseBarrierBlockEntity)blockEntity;
            if (level.isClientSide && FTBQuestsClient.isClientDataLoaded() && level.getGameTime() % 5L == 0L && (completed = barrier.isOpen(FTBQuestsClient.getClientPlayer())) != (Boolean)blockState.getValue((Property)QuestBarrierBlock.OPEN)) {
                level.setBlock(blockPos, (BlockState)blockState.setValue((Property)QuestBarrierBlock.OPEN, (Comparable)Boolean.valueOf(completed)), 10);
                blockEntity.setChanged();
                barrier.forceAppearanceUpdate();
            }
        }
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        if (tag.contains("Object")) {
            this.objStr = tag.getString("Object");
            this.skin = ItemStack.EMPTY;
        } else {
            BarrierSavedData data = BarrierSavedData.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.getCompound("savedData")).result().orElse(BarrierSavedData.DEFAULT);
            this.applySavedData(data);
        }
    }

    public void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        BarrierSavedData.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)BarrierSavedData.fromBlockEntity(this)).ifSuccess(tag -> compoundTag.put("savedData", tag));
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput dataComponentInput) {
        super.applyImplicitComponents(dataComponentInput);
        this.applySavedData((BarrierSavedData)dataComponentInput.getOrDefault((DataComponentType)ModDataComponents.BARRIER_SAVED.get(), (Object)BarrierSavedData.DEFAULT));
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set((DataComponentType)ModDataComponents.BARRIER_SAVED.get(), (Object)BarrierSavedData.fromBlockEntity(this));
    }

    protected void applySavedData(BarrierSavedData data) {
        this.objStr = data.objStr;
        this.setSkin(data.skin);
        this.setInvisibleWhenOpen(data.invisibleWhenOpen);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    public void setChanged() {
        if (this.level instanceof ServerLevel) {
            this.level.blockEntityChanged(this.getBlockPos());
        }
    }

    public void updateFromString(String objStr) {
        this.objStr = objStr;
        this.setChanged();
    }

    public abstract boolean isOpen(Player var1);

    protected abstract void addConfigEntries(ConfigGroup var1);

    public ConfigGroup fillConfigGroup() {
        ConfigGroup group = new ConfigGroup("ftbquests.barrier", accepted -> {
            if (accepted) {
                NetworkManager.sendToServer((CustomPacketPayload)new BlockConfigResponseMessage(this.getBlockPos(), this.saveWithoutMetadata((HolderLookup.Provider)this.getLevel().registryAccess())));
            }
        });
        group.setNameKey(this.getBlockState().getBlock().getDescriptionId());
        this.addConfigEntries(group);
        if (Platform.isForgeLike()) {
            ConfigGroup appearance = group.getOrCreateSubgroup("appearance").setNameKey("ftbquests.quest.appearance");
            ((ItemStackConfig)appearance.add("skin", (ConfigValue)new ItemStackConfig(true, true), (Object)this.getSkin(), this::setSkin, (Object)ItemStack.EMPTY)).withFilter(stack -> stack.getItem() instanceof BlockItem).setNameKey("block.ftbquests.screen.skin");
            appearance.addBool("invis_when_open", this.isInvisibleWhenOpen(), this::setInvisibleWhenOpen, false).setNameKey("block.ftbquests.barrier.invis_when_open");
        }
        return group;
    }

    public ItemStack getSkin() {
        return this.skin;
    }

    public void setSkin(ItemStack skin) {
        this.skin = skin;
        this.forceAppearanceUpdate();
        this.setChanged();
    }

    public boolean isInvisibleWhenOpen() {
        return this.invisibleWhenOpen;
    }

    public void setInvisibleWhenOpen(boolean invisibleWhenOpen) {
        this.invisibleWhenOpen = invisibleWhenOpen;
        this.forceAppearanceUpdate();
        this.setChanged();
    }

    public void forceAppearanceUpdate() {
        this.camo = null;
    }

    public BlockState getClientAppearance() {
        if (this.camo == null) {
            if (this.isOpen(FTBQuestsClient.getClientPlayer())) {
                this.camo = this.invisibleWhenOpen ? Blocks.AIR.defaultBlockState() : (BlockState)((Block)ModBlocks.BARRIER.get()).defaultBlockState().setValue((Property)QuestBarrierBlock.OPEN, (Comparable)Boolean.valueOf(true));
            } else {
                BlockState blockState;
                Item item = this.skin.getItem();
                if (item instanceof BlockItem) {
                    BlockItem bi = (BlockItem)item;
                    blockState = bi.getBlock().defaultBlockState();
                } else {
                    blockState = (BlockState)((Block)ModBlocks.BARRIER.get()).defaultBlockState().setValue((Property)QuestBarrierBlock.OPEN, (Comparable)Boolean.valueOf(false));
                }
                this.camo = blockState;
            }
        }
        return this.camo;
    }

    @Override
    public boolean hasPermissionToEdit(Player player) {
        return FTBQuestsAPI.api().getQuestFile(false).getTeamData(player).map(team -> team.getCanEdit(player)).orElse(false);
    }

    public record BarrierSavedData(String objStr, ItemStack skin, boolean invisibleWhenOpen) {
        public static final BarrierSavedData DEFAULT = new BarrierSavedData("", ItemStack.EMPTY, false);
        public static final Codec<BarrierSavedData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.STRING.optionalFieldOf("object", (Object)"").forGetter(BarrierSavedData::objStr), (App)ItemStack.CODEC.optionalFieldOf("skin", (Object)ItemStack.EMPTY).forGetter(BarrierSavedData::skin), (App)Codec.BOOL.optionalFieldOf("invis_when_open", (Object)false).forGetter(BarrierSavedData::invisibleWhenOpen)).apply((Applicative)builder, BarrierSavedData::new));
        public static StreamCodec<RegistryFriendlyByteBuf, BarrierSavedData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, BarrierSavedData::objStr, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, BarrierSavedData::skin, (StreamCodec)ByteBufCodecs.BOOL, BarrierSavedData::invisibleWhenOpen, BarrierSavedData::new);

        public static BarrierSavedData fromBlockEntity(BaseBarrierBlockEntity b) {
            return new BarrierSavedData(b.objStr, b.skin, b.invisibleWhenOpen);
        }

        public void addTooltipInfo(BarrierSavedData data, List<Component> tooltip, String what) {
            tooltip.add((Component)Component.translatable((String)("item.ftbquests.barrier.object." + what), (Object[])new Object[]{data.objStr().isEmpty() ? "-" : data.objStr}).withStyle(ChatFormatting.GRAY));
            if (Platform.isForgeLike() && !data.skin().isEmpty()) {
                tooltip.add((Component)Component.translatable((String)"item.ftbquests.barrier.skin", (Object[])new Object[]{data.skin().getDisplayName()}).withStyle(ChatFormatting.GRAY));
            }
            tooltip.add((Component)Component.translatable((String)"item.ftbquests.barrier.invis_when_open", (Object[])new Object[]{data.invisibleWhenOpen()}).withStyle(ChatFormatting.GRAY));
        }
    }
}

