/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.index;

import guideme.internal.shaded.lucene.index.CompositeReaderContext;
import guideme.internal.shaded.lucene.index.IndexReaderContext;
import guideme.internal.shaded.lucene.index.LeafReader;
import java.util.Collections;
import java.util.List;

public final class LeafReaderContext
extends IndexReaderContext {
    public final int ord;
    public final int docBase;
    private final LeafReader reader;
    private final List<LeafReaderContext> leaves;

    LeafReaderContext(CompositeReaderContext parent, LeafReader reader, int ord, int docBase, int leafOrd, int leafDocBase) {
        super(parent, ord, docBase);
        this.ord = leafOrd;
        this.docBase = leafDocBase;
        this.reader = reader;
        this.leaves = this.isTopLevel ? Collections.singletonList(this) : null;
    }

    LeafReaderContext(LeafReader leafReader) {
        this(null, leafReader, 0, 0, 0, 0);
    }

    @Override
    public List<LeafReaderContext> leaves() {
        if (!this.isTopLevel) {
            throw new UnsupportedOperationException("This is not a top-level context.");
        }
        assert (this.leaves != null);
        return this.leaves;
    }

    @Override
    public List<IndexReaderContext> children() {
        return null;
    }

    @Override
    public LeafReader reader() {
        return this.reader;
    }

    public String toString() {
        return "LeafReaderContext(" + String.valueOf(this.reader) + " docBase=" + this.docBase + " ord=" + this.ord + ")";
    }
}

