/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.zerono.mods.extremereactors.config.Config;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.part.ReprocessorCollectorEntity;
import it.zerono.mods.zerocore.lib.client.render.buffer.TintingRenderTypeBufferWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;

public class ReprocessorCollectorRender
implements BlockEntityRenderer<ReprocessorCollectorEntity> {
    private static final ItemRenderer ITEM_RENDERER = Minecraft.getInstance().getItemRenderer();

    public ReprocessorCollectorRender(BlockEntityRendererProvider.Context context) {
    }

    public AABB getRenderBoundingBox(ReprocessorCollectorEntity collector) {
        return collector.getRenderBoundingBox();
    }

    public void render(ReprocessorCollectorEntity collector, float partialTicks, PoseStack stack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        ItemStack startItem = collector.getRecipeSourceItem();
        ItemStack endItem = collector.getRecipeProductItem();
        double progress = collector.getProgress();
        if (!collector.isRecipeRunning() || startItem.isEmpty() || endItem.isEmpty()) {
            return;
        }
        stack.pushPose();
        stack.translate(0.5, 6.0 - 5.5 * progress, 0.5);
        stack.mulPose(Axis.YP.rotationDegrees((float)(360L * collector.getPartWorldOrFail().getGameTime()) / 50.0f + partialTicks / 50.0f));
        stack.scale(1.5f, 1.5f, 1.5f);
        if (Config.CLIENT.disableReprocessorMorphingAnimation) {
            ITEM_RENDERER.renderStatic(startItem, ItemDisplayContext.GROUND, combinedLight, combinedOverlay, stack, buffer, collector.getCurrentWorld(), 0);
        } else {
            float startItemAlpha = 1.0f - (float)progress + 0.25f;
            float endItemAlpha = (float)progress - 0.1f;
            ITEM_RENDERER.renderStatic(startItem, ItemDisplayContext.GROUND, combinedLight, combinedOverlay, stack, (MultiBufferSource)new TintingRenderTypeBufferWrapper(buffer, startItemAlpha, 1.0f, 1.0f, 1.0f), collector.getCurrentWorld(), 0);
            ITEM_RENDERER.renderStatic(endItem, ItemDisplayContext.GROUND, combinedLight, combinedOverlay, stack, (MultiBufferSource)new TintingRenderTypeBufferWrapper(buffer, endItemAlpha, 1.0f, 1.0f, 1.0f), collector.getCurrentWorld(), 0);
        }
        stack.popPose();
    }
}

