/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino;

import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.InterfaceAdapter;
import dev.latvian.mods.rhino.Scriptable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class VMBridge {
    public static boolean tryToMakeAccessible(Object target, AccessibleObject accessible) {
        if (accessible.canAccess(target)) {
            return true;
        }
        try {
            accessible.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return accessible.canAccess(target);
    }

    public static Object getInterfaceProxyHelper(Context cx, Class<?>[] interfaces) {
        Constructor<?> c;
        ClassLoader loader = interfaces[0].getClassLoader();
        Class<?> cl = Proxy.getProxyClass(loader, interfaces);
        try {
            c = cl.getConstructor(InvocationHandler.class);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalStateException(ex);
        }
        return c;
    }

    public static Object newInterfaceProxy(Object proxyHelper, InterfaceAdapter adapter, Object target, Scriptable topScope, Context cx) {
        Constructor c = (Constructor)proxyHelper;
        try {
            return c.newInstance(new AdapterInvocationHandler(cx, adapter, target, topScope));
        }
        catch (InvocationTargetException ex) {
            throw Context.throwAsScriptRuntimeEx(ex, cx);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException(ex);
        }
        catch (InstantiationException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public record AdapterInvocationHandler(Context cx, InterfaceAdapter adapter, Object target, Scriptable topScope) implements InvocationHandler
    {
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getDeclaringClass() == Object.class) {
                String methodName;
                switch (methodName = method.getName()) {
                    case "equals": {
                        return proxy == args[0];
                    }
                    case "hashCode": {
                        return this.target.hashCode();
                    }
                    case "toString": {
                        return "Proxy[" + String.valueOf(this.target) + "]";
                    }
                }
            }
            if (method.isDefault()) {
                return InvocationHandler.invokeDefault(proxy, method, args);
            }
            return this.adapter.invoke(this.cx, this.target, this.topScope, proxy, method, args);
        }
    }
}

