/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.util;

import com.google.common.collect.Lists;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.ixdarklord.coolcatlib.api.util.SlotReference;
import net.ixdarklord.ultimine_addition.common.item.MiningSkillCardItem;
import net.ixdarklord.ultimine_addition.core.FTBUltimineIntegration;
import net.ixdarklord.ultimine_addition.core.ServicePlatform;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.SlotRange;
import net.minecraft.world.inventory.SlotRanges;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemUtils {
    public static ItemStack getItemInHand(Player player, boolean checkBoth) {
        ItemStack stack = ItemStack.EMPTY;
        if (player.getMainHandItem() != ItemStack.EMPTY) {
            stack = player.getMainHandItem();
        } else if (checkBoth) {
            stack = player.getOffhandItem();
        }
        if (stack.getItem() != Items.AIR) {
            return stack;
        }
        return ItemStack.EMPTY;
    }

    public static ItemStack findItemInHand(Player player, Item item) {
        ItemStack stack = player.getMainHandItem();
        if (stack.getItem() != item) {
            stack = player.getOffhandItem();
        }
        if (ServicePlatform.get().slotAPI().isModLoaded() && stack.getItem() != item) {
            stack = ServicePlatform.get().slotAPI().getSkillsRecordItem(player);
        }
        return stack.getItem() == item ? stack : ItemStack.EMPTY;
    }

    public static int getSlotIndex(@Nullable InteractionHand hand) {
        int index = -1;
        InteractionHand interactionHand = hand;
        int n = 0;
        switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"MAIN_HAND", "OFF_HAND"}, (InteractionHand)interactionHand, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                index = (Integer)Objects.requireNonNull(SlotRanges.nameToIds((String)"weapon.mainhand")).slots().getFirst();
                break;
            }
            case 1: {
                index = (Integer)Objects.requireNonNull(SlotRanges.nameToIds((String)"weapon.offhand")).slots().getFirst();
            }
            case -1: 
        }
        return index;
    }

    public static List<SlotReference.Player> getSlotReferences(Player player, Item item, boolean onlyInventory) {
        return ItemUtils.getSlotReferences(player, (ItemStack itemStack) -> itemStack.is(item), onlyInventory);
    }

    public static List<SlotReference.Player> getSlotReferences(final Player player, Predicate<ItemStack> predicate, boolean onlyInventory) {
        ItemStack stack;
        ArrayList result = Lists.newArrayList();
        Predicate<String> filter = s -> {
            if (onlyInventory) {
                return s.contains("hotbar") || s.contains("inventory") || s.equals("weapon.offhand") || s.contains("armor");
            }
            return !s.equals("weapon") && !s.equals("weapon.mainhand");
        };
        List<String> slotNames = SlotRanges.singleSlotNames().filter(filter).toList();
        for (String slotName : slotNames) {
            SlotRange slotRange = SlotRanges.nameToIds((String)slotName);
            if (slotRange == null) continue;
            Integer slot = (Integer)slotRange.slots().getFirst();
            boolean match = result.stream().anyMatch(ref -> ref.getIndex() == slot.intValue());
            if (match || !predicate.test(player.getSlot(slot.intValue()).get())) continue;
            result.add(new SlotReference.Player(player, slot.intValue()));
        }
        if (ServicePlatform.get().slotAPI().isModLoaded() && predicate.test(stack = ServicePlatform.get().slotAPI().getSkillsRecordItem(player))) {
            result.add(new SlotReference.Player(null, -1){

                @NotNull
                public ItemStack getItem() {
                    return ServicePlatform.get().slotAPI().getSkillsRecordItem(player);
                }

                public boolean setItem(ItemStack item) {
                    throw new UnsupportedOperationException("You can't set an item in the %s slot.".formatted(ServicePlatform.get().slotAPI().getAPIName()));
                }
            });
        }
        return result;
    }

    public static boolean checkTargetedBlock(Player player) {
        double distance = player.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE);
        HitResult hit = player.pick(player.isCreative() ? distance + 0.5 : distance, 1.0f, false);
        if (!(hit instanceof BlockHitResult)) {
            return false;
        }
        BlockHitResult hitResult = (BlockHitResult)hit;
        BlockState blockState = player.level().getBlockState(hitResult.getBlockPos());
        ItemStack tool = player.getItemInHand(player.getUsedItemHand());
        return ServicePlatform.get().players().isCorrectToolForBlock(tool, blockState);
    }

    public static boolean isItemInHandTool(Player player) {
        return ItemUtils.isToolItem(ItemUtils.getItemInHand(player, true));
    }

    public static boolean isToolItem(ItemStack stack) {
        return stack.getItem() instanceof DiggerItem;
    }

    public static boolean isItemInHandCustomCardValid(Player player) {
        return FTBUltimineIntegration.getCustomCardTypes(player).stream().map(MiningSkillCardItem.Type::utilizeRequiredTools).flatMap(Collection::stream).toList().contains(ItemUtils.getItemInHand(player, true).getItem());
    }

    public static boolean isItemInHandPickaxe(Player player) {
        ItemStack stack = ItemUtils.getItemInHand(player, true);
        return ItemUtils.isItemInHandPaxel(player) || stack.is(ItemTags.PICKAXES) || stack.getItem() instanceof PickaxeItem;
    }

    public static boolean isItemInHandAxe(Player player) {
        ItemStack stack = ItemUtils.getItemInHand(player, true);
        return ItemUtils.isItemInHandPaxel(player) || stack.is(ItemTags.AXES) || stack.getItem() instanceof AxeItem;
    }

    public static boolean isItemInHandShovel(Player player) {
        ItemStack stack = ItemUtils.getItemInHand(player, true);
        return ItemUtils.isItemInHandPaxel(player) || stack.is(ItemTags.SHOVELS) || stack.getItem() instanceof ShovelItem;
    }

    public static boolean isItemInHandHoe(Player player) {
        ItemStack stack = ItemUtils.getItemInHand(player, true);
        return ItemUtils.isItemInHandPaxel(player) || stack.is(ItemTags.HOES) || stack.getItem() instanceof HoeItem;
    }

    public static boolean isItemInHandPaxel(Player player) {
        ItemStack stack = ItemUtils.getItemInHand(player, true);
        return ServicePlatform.get().players().isToolPaxel(stack);
    }

    public record ItemSorter(ItemStack item, int slotId, int order) {
    }
}

