/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.network.payloads;

import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftbultimine.api.shape.Shape;
import io.netty.buffer.ByteBuf;
import net.ixdarklord.ultimine_addition.common.data.item.SelectedShapeData;
import net.ixdarklord.ultimine_addition.common.menu.ShapeSelectorMenu;
import net.ixdarklord.ultimine_addition.core.FTBUltimineAddition;
import net.ixdarklord.ultimine_addition.core.FTBUltimineIntegration;
import net.ixdarklord.ultimine_addition.core.Registration;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public record UpdateItemShapePayload(String shapeId) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<UpdateItemShapePayload> TYPE = new CustomPacketPayload.Type(FTBUltimineAddition.rl("update_item_shape"));
    public static final StreamCodec<ByteBuf, UpdateItemShapePayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, UpdateItemShapePayload::shapeId, UpdateItemShapePayload::new);

    public static void handle(UpdateItemShapePayload message, NetworkManager.PacketContext context) {
        context.queue(() -> {
            AbstractContainerMenu patt0$temp = context.getPlayer().containerMenu;
            if (!(patt0$temp instanceof ShapeSelectorMenu)) {
                return;
            }
            ShapeSelectorMenu menu = (ShapeSelectorMenu)patt0$temp;
            ItemStack stack = menu.getSlot(0).getItem();
            if (stack.isEmpty()) {
                return;
            }
            if (message.shapeId.isEmpty()) {
                stack.remove((DataComponentType)Registration.SELECTED_SHAPE_COMPONENT.get());
                return;
            }
            Shape shape = FTBUltimineIntegration.getShape(ResourceLocation.parse((String)message.shapeId));
            if (shape == null) {
                return;
            }
            stack.set((DataComponentType)Registration.SELECTED_SHAPE_COMPONENT.get(), (Object)new SelectedShapeData(shape));
        });
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

