/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.network.payloads;

import dev.architectury.networking.NetworkManager;
import dev.architectury.registry.menu.MenuRegistry;
import dev.architectury.utils.Env;
import dev.ftb.mods.ftblibrary.util.NetworkHelper;
import io.netty.buffer.ByteBuf;
import net.ixdarklord.ultimine_addition.common.data.item.SkillsRecordData;
import net.ixdarklord.ultimine_addition.common.item.SkillsRecordItem;
import net.ixdarklord.ultimine_addition.common.menu.SkillsRecordMenu;
import net.ixdarklord.ultimine_addition.core.FTBUltimineAddition;
import net.ixdarklord.ultimine_addition.core.ServicePlatform;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public final class SkillsRecordPayload {

    public record SyncData(Env env, int slotIndex, SkillsRecordData data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SyncData> S2C_TYPE = new CustomPacketPayload.Type(FTBUltimineAddition.rl("skills_record_sync_s2c"));
        public static final CustomPacketPayload.Type<SyncData> C2S_TYPE = new CustomPacketPayload.Type(FTBUltimineAddition.rl("skills_record_sync_c2s"));
        public static final StreamCodec<RegistryFriendlyByteBuf, SyncData> STREAM_CODEC = StreamCodec.composite((StreamCodec)NetworkHelper.enumStreamCodec(Env.class), SyncData::env, (StreamCodec)ByteBufCodecs.INT, SyncData::slotIndex, SkillsRecordData.STREAM_CODEC, SyncData::data, SyncData::new);

        public static void handle(SyncData message, NetworkManager.PacketContext context) {
            context.queue(() -> {
                ItemStack stack;
                Player player = context.getPlayer();
                ItemStack itemStack = stack = message.slotIndex == -1 ? ServicePlatform.get().slotAPI().getSkillsRecordItem(player) : player.getSlot(message.slotIndex).get();
                if (stack.isEmpty()) {
                    throw new IllegalArgumentException("The assigned slot index does not contain the skills record item!");
                }
                if (context.getEnvironment() == Env.SERVER) {
                    ((SkillsRecordData)message.data.setDataHolder(stack)).syncData((ServerPlayer)player).saveData(stack);
                    return;
                }
                ((SkillsRecordData)((SkillsRecordData)message.data.setDataHolder(stack)).clientUpdate()).saveData(stack);
            });
        }

        @NotNull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return switch (this.env) {
                default -> throw new MatchException(null, null);
                case Env.CLIENT -> S2C_TYPE;
                case Env.SERVER -> C2S_TYPE;
            };
        }
    }

    public static class Open
    implements CustomPacketPayload {
        public static final CustomPacketPayload.Type<Open> TYPE = new CustomPacketPayload.Type(FTBUltimineAddition.rl("open_skills_record"));
        public static final StreamCodec<FriendlyByteBuf, Open> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, Open>(){

            @NotNull
            public Open decode(FriendlyByteBuf object) {
                return new Open();
            }

            public void encode(FriendlyByteBuf object, Open object2) {
            }
        };

        public static void handle(Open ignored, NetworkManager.PacketContext context) {
            context.queue(() -> {
                Player patt0$temp = context.getPlayer();
                if (patt0$temp instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)patt0$temp;
                    ItemStack stack = ServicePlatform.get().slotAPI().getSkillsRecordItem((Player)player);
                    if (stack.getItem() instanceof SkillsRecordItem && stack.has(SkillsRecordData.DATA_COMPONENT)) {
                        MenuRegistry.openExtendedMenu((ServerPlayer)player, (MenuProvider)new SimpleMenuProvider((id, inv, p) -> new SkillsRecordMenu(id, inv, p, stack, null), SkillsRecordItem.TITLE), buf -> {
                            ItemStack.STREAM_CODEC.encode((Object)new RegistryFriendlyByteBuf((ByteBuf)buf, player.serverLevel().registryAccess()), (Object)stack);
                            buf.writeBoolean(false);
                        });
                    }
                }
            });
        }

        @NotNull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }
}

