/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.network.payloads;

import dev.architectury.networking.NetworkManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ixdarklord.ultimine_addition.config.ClientSideConfigPreserver;
import net.ixdarklord.ultimine_addition.config.ConfigHandler;
import net.ixdarklord.ultimine_addition.config.ConfigValueWrapper;
import net.ixdarklord.ultimine_addition.core.FTBUltimineAddition;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.NotNull;

public record ConfigSyncPayload(boolean forceChanges, boolean shouldPreserve, Map<List<String>, ConfigValueWrapper<?>> changes) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ConfigSyncPayload> TYPE = new CustomPacketPayload.Type(FTBUltimineAddition.rl("config_sync"));
    public static final StreamCodec<FriendlyByteBuf, ConfigSyncPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, ConfigSyncPayload::forceChanges, (StreamCodec)ByteBufCodecs.BOOL, ConfigSyncPayload::shouldPreserve, (StreamCodec)ByteBufCodecs.map(HashMap::new, (StreamCodec)ByteBufCodecs.STRING_UTF8.apply(ByteBufCodecs.list()), ConfigValueWrapper.CODEC), ConfigSyncPayload::changes, ConfigSyncPayload::new);

    public ConfigSyncPayload(boolean shouldPreserve, boolean forceChanges, ModConfigSpec.ConfigValue<?> ... configValues) {
        this(forceChanges, shouldPreserve, ConfigHandler.toMap(configValues));
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(ConfigSyncPayload message, NetworkManager.PacketContext context) {
        context.queue(() -> {
            HashMap originalValues = new HashMap();
            message.changes().forEach((path, wrapper) -> {
                ConfigHandler.SyncResult syncResult = ConfigHandler.applySyncedValues(path, wrapper, message.forceChanges(), true);
                if (message.shouldPreserve() && syncResult.updated()) {
                    ConfigValueWrapper<Object> oldWrapper = new ConfigValueWrapper<Object>(syncResult.oldValue().getClass(), syncResult.oldValue());
                    originalValues.put((List<String>)path, oldWrapper);
                }
            });
            if (!originalValues.isEmpty()) {
                ClientSideConfigPreserver.preserveOriginalValues(originalValues);
            }
        });
    }
}

