/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.mixin;

import java.util.List;
import net.ixdarklord.ultimine_addition.common.data.item.MiningSkillCardData;
import net.ixdarklord.ultimine_addition.common.item.MiningSkillCardItem;
import net.ixdarklord.ultimine_addition.core.FTBUltimineAddition;
import net.ixdarklord.ultimine_addition.network.PayloadHandler;
import net.ixdarklord.ultimine_addition.network.payloads.MiningSkillCardPayload;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BrewingStandBlockEntity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BrewingStandBlockEntity.class})
abstract class BrewingStandBlockEntityMixin {
    @Shadow
    @Final
    private static int INGREDIENT_SLOT;

    BrewingStandBlockEntityMixin() {
    }

    @Inject(method={"doBrew"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/core/NonNullList;set(ILjava/lang/Object;)Ljava/lang/Object;", ordinal=1)})
    private static void UA$Inject$updateBrewInv(Level level, BlockPos pos, NonNullList<ItemStack> items, CallbackInfo ci) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ItemStack stack = ((ItemStack)items.get(INGREDIENT_SLOT)).copy();
            Item item = stack.getItem();
            if (item instanceof MiningSkillCardItem) {
                MiningSkillCardItem item2 = (MiningSkillCardItem)item;
                MiningSkillCardData data = item2.getData(stack);
                int oldPoints = data.getPotionPoints();
                data.consumePotionPoint(1).saveData(stack);
                items.set(INGREDIENT_SLOT, (Object)stack);
                BlockEntity blockEntity = serverLevel.getBlockEntity(pos);
                if (!(blockEntity instanceof BrewingStandBlockEntity)) {
                    return;
                }
                BrewingStandBlockEntity brewingStandBlock = (BrewingStandBlockEntity)blockEntity;
                List players = serverLevel.getPlayers(arg_0 -> ((BrewingStandBlockEntity)brewingStandBlock).stillValid(arg_0));
                for (ServerPlayer player : players) {
                    FTBUltimineAddition.LOGGER.debug("{} synced potion points! [B:{} / A:{}]", (Object)player.getDisplayName().getString(), (Object)oldPoints, (Object)data.getPotionPoints());
                    PayloadHandler.sendToPlayer(new MiningSkillCardPayload.SyncBrewing(stack.copy()), player);
                }
            }
        }
    }

    @Redirect(method={"doBrew"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;shrink(I)V"))
    private static void UA$Redirect$consumePotionPoint(ItemStack stack, int i) {
        if (!(stack.getItem() instanceof MiningSkillCardItem)) {
            stack.shrink(i);
        }
    }
}

