/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.integration.jei;

import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.ixdarklord.ultimine_addition.api.CustomMSCApi;
import net.ixdarklord.ultimine_addition.common.data.item.MiningSkillCardData;
import net.ixdarklord.ultimine_addition.common.item.MiningSkillCardItem;
import net.ixdarklord.ultimine_addition.common.item.ModItems;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MiningSkillsCardInterpreter
implements ISubtypeInterpreter<ItemStack> {
    public static void init(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter((Item)ModItems.MINING_SKILL_CARD_PICKAXE, (ISubtypeInterpreter)new MiningSkillsCardInterpreter());
        registration.registerSubtypeInterpreter((Item)ModItems.MINING_SKILL_CARD_AXE, (ISubtypeInterpreter)new MiningSkillsCardInterpreter());
        registration.registerSubtypeInterpreter((Item)ModItems.MINING_SKILL_CARD_SHOVEL, (ISubtypeInterpreter)new MiningSkillsCardInterpreter());
        registration.registerSubtypeInterpreter((Item)ModItems.MINING_SKILL_CARD_HOE, (ISubtypeInterpreter)new MiningSkillsCardInterpreter());
        for (MiningSkillCardItem.Type type : CustomMSCApi.CUSTOM_TYPES) {
            ResourceLocation location = ResourceLocation.parse((String)("ultimine_addition:mining_skill_card_" + type.getId()));
            Item item = (Item)BuiltInRegistries.ITEM.get(location);
            if (item == Items.AIR) continue;
            registration.registerSubtypeInterpreter(item, (ISubtypeInterpreter)new MiningSkillsCardInterpreter());
        }
    }

    @Nullable
    public Object getSubtypeData(ItemStack stack, UidContext uidContext) {
        MiningSkillCardData data = (MiningSkillCardData)stack.get(MiningSkillCardData.DATA_COMPONENT);
        return data != null ? data.getTier() : null;
    }

    @NotNull
    public String getLegacyStringSubtypeInfo(ItemStack stack, UidContext uidContext) {
        if (!stack.has(MiningSkillCardData.DATA_COMPONENT)) {
            return "";
        }
        StringBuilder builder = new StringBuilder(stack.getItem().getDescriptionId());
        MiningSkillCardData data = MiningSkillCardData.loadData(stack);
        switch (data.getTier()) {
            case Unlearned: {
                builder.append(".unlearned");
                break;
            }
            case Novice: {
                builder.append(".novice");
                break;
            }
            case Apprentice: {
                builder.append(".apprentice");
                break;
            }
            case Adept: {
                builder.append(".adept");
                break;
            }
            case Mastered: {
                builder.append(".mastered");
            }
        }
        return builder.toString();
    }
}

