/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.integration.jei;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import net.ixdarklord.ultimine_addition.common.data.item.MiningSkillCardData;
import net.ixdarklord.ultimine_addition.common.item.MiningSkillCardItem;
import net.ixdarklord.ultimine_addition.common.recipe.MCRecipe;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MCRecipeTransferHandler
implements IRecipeTransferHandler<CraftingMenu, RecipeHolder<CraftingRecipe>> {
    private final IRecipeTransferHandlerHelper handlerHelper;
    private final IRecipeTransferHandler<CraftingMenu, RecipeHolder<CraftingRecipe>> handler;

    public MCRecipeTransferHandler(IRecipeTransferHandlerHelper handlerHelper) {
        this.handlerHelper = handlerHelper;
        IRecipeTransferInfo basicRecipeTransferInfo = handlerHelper.createBasicRecipeTransferInfo(CraftingMenu.class, MenuType.CRAFTING, RecipeTypes.CRAFTING, 1, 9, 10, 36);
        this.handler = handlerHelper.createUnregisteredRecipeTransferHandler(basicRecipeTransferInfo);
    }

    @NotNull
    public Class<? extends CraftingMenu> getContainerClass() {
        return this.handler.getContainerClass();
    }

    @NotNull
    public Optional<MenuType<CraftingMenu>> getMenuType() {
        return this.handler.getMenuType();
    }

    @NotNull
    public RecipeType<RecipeHolder<CraftingRecipe>> getRecipeType() {
        return RecipeTypes.CRAFTING;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(@NotNull CraftingMenu container, @NotNull RecipeHolder<CraftingRecipe> recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull Player player, boolean maxTransfer, boolean doTransfer) {
        if (!this.handlerHelper.recipeTransferHasServerSupport()) {
            MutableComponent tooltipMessage = Component.translatable((String)"jei.tooltip.error.recipe.transfer.no.server");
            return this.handlerHelper.createUserErrorWithTooltip((Component)tooltipMessage);
        }
        List<IRecipeSlotView> missingItems = this.getMissingItems(container, recipeSlotsView.getSlotViews(RecipeIngredientRole.INPUT));
        if (recipe.value() instanceof MCRecipe && !missingItems.isEmpty()) {
            MutableComponent tooltipMessage = Component.translatable((String)"jei.tooltip.error.recipe.transfer.missing");
            if (!this.missingTieredUpMiningCard(container, missingItems).isEmpty()) {
                tooltipMessage.append(" ").append((Component)Component.translatable((String)"jei.ultimine_addition.tooltip.missing_card"));
            }
            return this.handlerHelper.createUserErrorForMissingSlots((Component)tooltipMessage, missingItems);
        }
        return this.handler.transferRecipe((AbstractContainerMenu)container, recipe, recipeSlotsView, player, maxTransfer, doTransfer);
    }

    private List<IRecipeSlotView> getMissingItems(@NotNull CraftingMenu container, List<IRecipeSlotView> slotViews) {
        return slotViews.stream().filter(slotView -> !slotView.isEmpty()).filter(slotView -> slotView.getItemStacks().filter(stack -> {
            Item patt0$temp = stack.getItem();
            if (patt0$temp instanceof MiningSkillCardItem) {
                MiningSkillCardItem item = (MiningSkillCardItem)patt0$temp;
                MiningSkillCardData data = item.getData((ItemStack)stack);
                List<ItemStack> inv = container.getItems().stream().filter(stack1 -> stack1.is(stack.getItem()) && item.getData((ItemStack)stack1).getTier().equals((Object)data.getTier())).toList();
                return !inv.isEmpty();
            }
            List<ItemStack> inv = container.getItems().stream().filter(stack1 -> stack1.is(stack.getItem())).toList();
            return !inv.isEmpty();
        }).toList().isEmpty()).collect(Collectors.toList());
    }

    private List<IRecipeSlotView> missingTieredUpMiningCard(@NotNull CraftingMenu container, List<IRecipeSlotView> slotViews) {
        return slotViews.stream().filter(slotView -> !slotView.isEmpty()).filter(slotView -> {
            ArrayList list = new ArrayList(slotView.getItemStacks().toList());
            list.removeIf(stack -> {
                MiningSkillCardData data = MiningSkillCardData.loadData(stack);
                List<ItemStack> inv = container.getItems().stream().filter(stack1 -> stack1.is(stack.getItem()) && !MiningSkillCardData.loadData(stack1).getTier().equals((Object)data.getTier())).toList();
                return inv.isEmpty();
            });
            return !list.isEmpty();
        }).collect(Collectors.toList());
    }
}

