/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.integration.jei;

import java.util.Arrays;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.handlers.IGlobalGuiHandler;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.ixdarklord.ultimine_addition.common.data.item.MiningSkillCardData;
import net.ixdarklord.ultimine_addition.common.item.MiningSkillCardItem;
import net.ixdarklord.ultimine_addition.common.item.ModItems;
import net.ixdarklord.ultimine_addition.config.ConfigHandler;
import net.ixdarklord.ultimine_addition.core.FTBUltimineAddition;
import net.ixdarklord.ultimine_addition.integration.jei.ConfigIngredientInfoRecipe;
import net.ixdarklord.ultimine_addition.integration.jei.ItemStorageDataRecipeCategory;
import net.ixdarklord.ultimine_addition.integration.jei.MCRecipeTransferHandler;
import net.ixdarklord.ultimine_addition.integration.jei.MiningSkillsCardInterpreter;
import net.ixdarklord.ultimine_addition.integration.jei.PenInterpreter;
import net.ixdarklord.ultimine_addition.integration.jei.SkillsRecordScreenHandler;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class JEIIntegration
implements IModPlugin {
    @NotNull
    public ResourceLocation getPluginUid() {
        return FTBUltimineAddition.rl("jei_integration");
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        MiningSkillsCardInterpreter.init(registration);
        registration.registerSubtypeInterpreter((Item)ModItems.PEN, (ISubtypeInterpreter)new PenInterpreter());
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGlobalGuiHandler((IGlobalGuiHandler)new SkillsRecordScreenHandler());
    }

    public void registerCategories(@NotNull IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new ItemStorageDataRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(@NotNull IRecipeRegistration registration) {
        registration.addRecipes(RecipeTypes.CRAFTING, ItemStorageDataRecipeCategory.getAdjustedCraftingRecipe());
        registration.addRecipes(ItemStorageDataRecipeCategory.RECIPE_TYPE, ItemStorageDataRecipeCategory.getItemStorageDataRecipes());
        List<MiningSkillCardItem> skillCardItems = List.of(ModItems.MINING_SKILL_CARD_PICKAXE, ModItems.MINING_SKILL_CARD_AXE, ModItems.MINING_SKILL_CARD_SHOVEL, ModItems.MINING_SKILL_CARD_HOE);
        List allCards = skillCardItems.stream().flatMap(item -> Arrays.stream(MiningSkillCardItem.Tier.values()).filter(tier -> tier != MiningSkillCardItem.Tier.Mastered).map(tier -> MiningSkillCardData.createForCreativeTab(item, tier))).toList();
        List<ItemStack> masteredCards = skillCardItems.stream().map(item -> MiningSkillCardData.createForCreativeTab(item, MiningSkillCardItem.Tier.Mastered)).toList();
        registration.addItemStackInfo(allCards, new Component[]{Component.translatable((String)"jei.ultimine_addition.info.cards.grade_up")});
        registration.addItemStackInfo(masteredCards, new Component[]{Component.translatable((String)"jei.ultimine_addition.info.cards.mastered")});
        ConfigIngredientInfoRecipe.addConfigInfo(registration, ModItems.MINING_SKILL_CARD_EMPTY.getDefaultInstance(), "jei.ultimine_addition.info.cards.obtain", ConfigHandler.COMMON.VILLAGER_CARD_TRADE_LEVEL);
    }

    public void registerRecipeCatalysts(@NotNull IRecipeCatalystRegistration registration) {
        ItemStorageDataRecipeCategory.getCatalysts().forEach(stack -> registration.addRecipeCatalyst(stack, new RecipeType[]{ItemStorageDataRecipeCategory.RECIPE_TYPE}));
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new MCRecipeTransferHandler(registration.getTransferHelper()), RecipeTypes.CRAFTING);
    }
}

