/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.integration.jei;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.ixdarklord.coolcatlib.api.util.ComponentHelper;
import net.ixdarklord.coolcatlib.api.util.MouseHelper;
import net.ixdarklord.ultimine_addition.common.data.item.ItemStorageData;
import net.ixdarklord.ultimine_addition.common.item.StorageDataAbstractItem;
import net.ixdarklord.ultimine_addition.common.recipe.ItemStorageDataRecipe;
import net.ixdarklord.ultimine_addition.common.recipe.ingredient.DataIngredient;
import net.ixdarklord.ultimine_addition.core.FTBUltimineAddition;
import net.ixdarklord.ultimine_addition.core.Registration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemStorageDataRecipeCategory
implements IRecipeCategory<ItemStorageDataRecipe> {
    public static final ResourceLocation TEXTURES = FTBUltimineAddition.getGuiTexture("jei/item_storage_data_recipe", "png");
    public static final RecipeType<ItemStorageDataRecipe> RECIPE_TYPE = RecipeType.create((String)"ultimine_addition", (String)"item_storage_data", ItemStorageDataRecipe.class);
    private final IDrawable background;
    private final ITickTimer timer;
    private Component title;

    public ItemStorageDataRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURES, 0, 0, 128, 41);
        this.timer = helper.createTickTimer(60, 380, false);
        this.title = Component.literal((String)"Not Assigned!");
    }

    @NotNull
    public static List<ItemStack> getCatalysts() {
        RecipeManager rm = Objects.requireNonNull(Minecraft.getInstance().level).getRecipeManager();
        ArrayList<ItemStorageDataRecipe> recipes = new ArrayList<ItemStorageDataRecipe>(rm.getAllRecipesFor(net.minecraft.world.item.crafting.RecipeType.CRAFTING).stream().filter(recipe -> recipe.value() instanceof ItemStorageDataRecipe).map(recipe -> (ItemStorageDataRecipe)recipe.value()).toList());
        return recipes.stream().map(ItemStorageDataRecipe::getResultItem).toList();
    }

    public static List<ItemStorageDataRecipe> getItemStorageDataRecipes() {
        RecipeManager rm = Objects.requireNonNull(Minecraft.getInstance().level).getRecipeManager();
        List<ItemStorageDataRecipe> recipes = rm.getAllRecipesFor(net.minecraft.world.item.crafting.RecipeType.CRAFTING).stream().filter(recipe -> recipe.value() instanceof ItemStorageDataRecipe).map(recipe -> (ItemStorageDataRecipe)recipe.value()).toList();
        ArrayList<ItemStorageDataRecipe> result = new ArrayList<ItemStorageDataRecipe>();
        recipes.forEach(recipe -> recipe.getDataIngredients().forEach(i -> {
            NonNullList items = NonNullList.create();
            items.add((Object)DataIngredient.of(i.getAmount(), i.getItems()));
            result.add(new ItemStorageDataRecipe(recipe.getGroup(), recipe.getCategory(), recipe.getResultItem(), recipe.getStorageName(), (NonNullList<DataIngredient>)items));
            Item patt0$temp = recipe.getResultItem().getItem();
            if (patt0$temp instanceof StorageDataAbstractItem) {
                StorageDataAbstractItem item = (StorageDataAbstractItem)patt0$temp;
                ItemStack penStack = recipe.getResultItem().copy();
                ItemStorageData data = item.getData(penStack);
                data.saveData(penStack);
                result.add(new ItemStorageDataRecipe(recipe.getGroup(), recipe.getCategory(), penStack, recipe.getStorageName(), (NonNullList<DataIngredient>)items));
            }
        }));
        return result;
    }

    public static List<RecipeHolder<CraftingRecipe>> getAdjustedCraftingRecipe() {
        ClientLevel level = Minecraft.getInstance().level;
        assert (level != null);
        RecipeManager rm = level.getRecipeManager();
        return rm.getAllRecipesFor(net.minecraft.world.item.crafting.RecipeType.CRAFTING).stream().filter(holder -> ((CraftingRecipe)holder.value()).getResultItem((HolderLookup.Provider)level.registryAccess()).getItem() instanceof StorageDataAbstractItem).peek(holder -> {
            ItemStack itemStack = ((CraftingRecipe)holder.value()).getResultItem((HolderLookup.Provider)level.registryAccess());
            Item patt0$temp = itemStack.getItem();
            if (patt0$temp instanceof StorageDataAbstractItem) {
                StorageDataAbstractItem item = (StorageDataAbstractItem)patt0$temp;
                item.getData(itemStack).saveData(itemStack);
            }
        }).toList();
    }

    @NotNull
    public RecipeType<ItemStorageDataRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    @NotNull
    public Component getTitle() {
        return this.title;
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull ItemStorageDataRecipe recipe, @NotNull IFocusGroup focuses) {
        if (this.title.equals((Object)Component.literal((String)"Not Assigned!"))) {
            this.title = Component.translatable((String)String.format("jei.ultimine_addition.category.item_storage.%s", Objects.requireNonNull(Registration.ITEMS.getRegistrar().getId((Object)recipe.getResultItem().getItem())).getPath()));
        }
        List items = DataIngredient.toNormal(recipe.getDataIngredients()).stream().map(Ingredient::getItems).flatMap(Arrays::stream).toList();
        builder.addSlot(RecipeIngredientRole.INPUT, 9, 5).addItemStack(recipe.getResultItem());
        builder.addSlot(RecipeIngredientRole.INPUT, 103, 5).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, items);
    }

    public void getTooltip(ITooltipBuilder tooltip, ItemStorageDataRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        int value = ((CustomData)((IRecipeSlotView)recipeSlotsView.getSlotViews().get(1)).getDisplayedItemStack().orElse(ItemStack.EMPTY).getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getInt("amount");
        MutableComponent component = Component.translatable((String)String.format("jei.ultimine_addition.recipe.item_storage.%s", recipe.getStorageName()), (Object[])new Object[]{value});
        if (component.getString().length() >= 27 && MouseHelper.isMouseOver((double)mouseX, (double)mouseY, (int)3, (int)28, (int)121, (int)12)) {
            tooltip.add((FormattedText)component);
        }
    }

    @NotNull
    public IDrawable getIcon() {
        return new AnimatedCrafting(null, 5, 5, 5, 5);
    }

    public void draw(@NotNull ItemStorageDataRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        new AnimatedCrafting(this.timer).draw(guiGraphics, 51, 0);
        guiGraphics.pose().pushPose();
        Font font = Minecraft.getInstance().font;
        int value = ((CustomData)((IRecipeSlotView)recipeSlotsView.getSlotViews().get(1)).getDisplayedItemStack().orElse(ItemStack.EMPTY).getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getInt("amount");
        Component component = ComponentHelper.limitComponent((Component)Component.translatable((String)String.format("jei.ultimine_addition.recipe.item_storage.%s", recipe.getStorageName()), (Object[])new Object[]{value}), (int)27);
        guiGraphics.drawString(font, component, 5, 30, Color.WHITE.getRGB());
        guiGraphics.pose().popPose();
    }

    private record AnimatedCrafting(@Nullable ITickTimer timer, int maskTop, int maskBottom, int maskLeft, int maskRight) implements IDrawableStatic
    {
        public AnimatedCrafting(@Nullable ITickTimer timer) {
            this(timer, 0, 0, 0, 0);
        }

        public void draw(GuiGraphics guiGraphics, int x, int y) {
            this.draw(guiGraphics, x, y, this.maskTop, this.maskBottom, this.maskLeft, this.maskRight);
        }

        public void draw(GuiGraphics guiGraphics, int x, int y, int maskTop, int maskBottom, int maskLeft, int maskRight) {
            PoseStack poseStack = guiGraphics.pose();
            if (maskLeft == 0 && maskRight == 0 && maskTop == 0 && maskBottom == 0) {
                maskLeft = this.maskLeft;
                maskRight = this.maskRight;
                maskTop = this.maskTop;
                maskBottom = this.maskBottom;
            }
            int maskedWidth = this.getWidth() - maskLeft - maskRight;
            int maskedHeight = this.getHeight() - maskTop - maskBottom;
            if (maskedWidth <= 0 || maskedHeight <= 0) {
                return;
            }
            float baseSize = 16.0f;
            float scaleX = (float)maskedWidth * baseSize / (float)this.getWidth();
            float scaleY = (float)maskedHeight * baseSize / (float)this.getHeight();
            float scale = Math.min(scaleX, scaleY);
            int adjustedX = x + maskLeft;
            int adjustedY = y + maskTop;
            poseStack.pushPose();
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float dynamicYOffset = (float)maskedHeight * 20.0f / (float)this.getHeight();
            if (this.timer != null) {
                poseStack.translate((double)adjustedX, (double)((float)adjustedY + dynamicYOffset) + Math.cos((float)this.timer.getValue() / 20.0f), 100.0);
            } else {
                poseStack.translate((float)adjustedX, (float)adjustedY + dynamicYOffset, 100.0f);
            }
            poseStack.scale(scale, -scale, scale);
            poseStack.mulPose(Axis.XP.rotationDegrees(30.0f));
            poseStack.mulPose(Axis.YP.rotationDegrees(45.0f));
            MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
            BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
            dispatcher.renderSingleBlock(Blocks.CRAFTING_TABLE.defaultBlockState(), poseStack, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.NO_OVERLAY);
            bufferSource.endBatch();
            poseStack.popPose();
            poseStack.pushPose();
            if (this.timer != null) {
                poseStack.translate((double)adjustedX, (double)adjustedY + Math.sin((float)this.timer.getValue() / 20.0f), 120.0);
            } else {
                poseStack.translate((float)adjustedX, (float)adjustedY, 120.0f);
            }
            float plusScaleX = (float)maskedWidth / (float)this.getWidth() - 1.0f;
            float plusScaleY = (float)maskedHeight / (float)this.getHeight() - 1.0f;
            float plusScale = Math.min(plusScaleX, plusScaleY);
            poseStack.scale(1.0f + plusScale, 1.0f + plusScale, 1.0f);
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            guiGraphics.blit(TEXTURES, 14, 14, 0.0f, 42.0f, 12, 12, 256, 256);
            poseStack.popPose();
        }

        public int getWidth() {
            return 26;
        }

        public int getHeight() {
            return 26;
        }
    }
}

