/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.datagen.particle;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import net.ixdarklord.ultimine_addition.core.FTBUltimineAddition;
import net.ixdarklord.ultimine_addition.core.Registration;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public abstract class ParticleProvider
implements DataProvider {
    private final PackOutput.PathProvider pathProvider;
    private final Map<String, List<ResourceLocation>> data = new TreeMap<String, List<ResourceLocation>>();

    protected abstract void addParticles();

    public ParticleProvider(PackOutput output) {
        this.pathProvider = output.createPathProvider(PackOutput.Target.RESOURCE_PACK, "particles");
    }

    @NotNull
    public CompletableFuture<?> run(@NotNull CachedOutput cache) {
        this.clear();
        this.addParticles();
        if (this.data.isEmpty()) {
            throw new IllegalStateException("The structure data is empty!");
        }
        CompletableFuture[] futures = new CompletableFuture[this.data.size()];
        int i = 0;
        for (Map.Entry<String, List<ResourceLocation>> particle : this.data.entrySet()) {
            JsonObject JSONProperties = new JsonObject();
            JsonArray array = new JsonArray();
            for (ResourceLocation entry : particle.getValue()) {
                array.add(entry.toString());
            }
            JSONProperties.add("textures", (JsonElement)array);
            futures[i++] = DataProvider.saveStable((CachedOutput)cache, (JsonElement)JSONProperties, (Path)this.pathProvider.file(FTBUltimineAddition.rl(particle.getKey()), "json"));
        }
        return CompletableFuture.allOf(futures);
    }

    public void add(SimpleParticleType particle, ResourceLocation ... texture) {
        String particleName = Objects.requireNonNull(Registration.PARTICLE_TYPES.getRegistrar().getId((Object)particle)).getPath();
        if (this.data.containsKey(particleName)) {
            throw new IllegalStateException("Duplicate particle " + particleName);
        }
        this.data.put(particleName, Arrays.stream(texture).toList());
    }

    private void clear() {
        this.data.clear();
    }

    @NotNull
    public final String getName() {
        return "Particles";
    }
}

