/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.datagen.challenge;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import net.ixdarklord.ultimine_addition.common.data.challenge.ChallengesData;
import net.ixdarklord.ultimine_addition.common.item.MiningSkillCardItem;
import net.ixdarklord.ultimine_addition.datagen.challenge.builder.ChallengesBuilder;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public abstract class ChallengeProvider
implements DataProvider {
    private final PackOutput output;
    private final Map<ResourceLocation, ChallengesData> data = new TreeMap<ResourceLocation, ChallengesData>();

    protected abstract void buildChallenges(Consumer<ChallengesBuilder.Result> var1);

    public ChallengeProvider(PackOutput output) {
        this.output = output;
    }

    @NotNull
    public CompletableFuture<?> run(@NotNull CachedOutput cache) {
        this.clear();
        this.buildChallenges(result -> {
            if (this.data.containsKey(result.id())) {
                throw new IllegalStateException("Duplicate challenge " + result.id().toString());
            }
            this.data.put(result.id(), result.data());
        });
        if (this.data.isEmpty()) {
            throw new IllegalStateException("The challenges data is empty!");
        }
        CompletableFuture[] futures = new CompletableFuture[this.data.size()];
        int i = 0;
        for (Map.Entry<ResourceLocation, ChallengesData> data : this.data.entrySet()) {
            AtomicReference<JsonObject> JSONProperties = new AtomicReference<JsonObject>(new JsonObject());
            ChallengesData.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)data.getValue()).result().ifPresent(json -> JSONProperties.set(json.getAsJsonObject()));
            futures[i++] = DataProvider.saveStable((CachedOutput)cache, (JsonElement)((JsonElement)JSONProperties.get()), (Path)this.pathProvider(data.getValue()).json(data.getKey()));
        }
        return CompletableFuture.allOf(futures);
    }

    private PackOutput.PathProvider pathProvider(ChallengesData value) {
        String path = "";
        if (value.getForCardType().equals(MiningSkillCardItem.Type.PICKAXE)) {
            path = "/pickaxe";
        } else if (value.getForCardType().equals(MiningSkillCardItem.Type.AXE)) {
            path = "/axe";
        } else if (value.getForCardType().equals(MiningSkillCardItem.Type.SHOVEL)) {
            path = "/shovel";
        } else if (value.getForCardType().equals(MiningSkillCardItem.Type.HOE)) {
            path = "/hoe";
        }
        return this.output.createPathProvider(PackOutput.Target.DATA_PACK, "challenges" + path);
    }

    private void clear() {
        this.data.clear();
    }

    @NotNull
    public final String getName() {
        return "Ultimine Addition Challenges";
    }
}

