/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.datagen.advancement;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.ixdarklord.ultimine_addition.common.advancement.AdvancementTriggers;
import net.ixdarklord.ultimine_addition.common.advancement.UltimineObtainTrigger;
import net.ixdarklord.ultimine_addition.common.data.item.MinerCertificateData;
import net.ixdarklord.ultimine_addition.common.item.ModItems;
import net.ixdarklord.ultimine_addition.core.FTBUltimineAddition;
import net.ixdarklord.ultimine_addition.datagen.advancement.AdvancementProvider;
import net.minecraft.Util;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.KilledTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class AdvancementGenerator
extends AdvancementProvider {
    public AdvancementGenerator(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries, List.of(new Contents()));
    }

    public static class Contents
    implements AdvancementProvider.AdvancementGenerator {
        @Override
        public void generate(HolderLookup.Provider registries, Consumer<AdvancementHolder> consumer) {
            AdvancementHolder root = Advancement.Builder.advancement().display((ItemLike)ModItems.MINER_CERTIFICATE, (Component)Component.translatable((String)String.format("itemGroup.%s.tab", "ultimine_addition")), (Component)Component.translatable((String)String.format("advancement.%s.root.desc", "ultimine_addition")), FTBUltimineAddition.getGuiTexture("advancement/adv_background", "png"), AdvancementType.TASK, false, false, false).addCriterion("has_early_items", InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(new ItemLike[]{Items.DIRT, Items.STONE}).of(ItemTags.LOGS).build()})).addCriterion("killed_by_something", KilledTrigger.TriggerInstance.entityKilledPlayer()).addCriterion("killed_something", KilledTrigger.TriggerInstance.playerKilledEntity()).requirements(AdvancementRequirements.Strategy.OR).save(consumer, FTBUltimineAddition.rl("root").toString());
            AdvancementHolder amethyst = Advancement.Builder.advancement().parent(root).display((ItemLike)Items.AMETHYST_SHARD, (Component)Component.translatable((String)String.format("advancement.%s.amethyst_gathering", "ultimine_addition")), (Component)Component.translatable((String)String.format("advancement.%s.obtain", "ultimine_addition"), (Object[])new Object[]{Items.AMETHYST_SHARD.getDefaultInstance().getHoverName()}), null, AdvancementType.TASK, true, true, false).addCriterion("has_amethyst", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.AMETHYST_SHARD})).requirements(AdvancementRequirements.Strategy.OR).save(consumer, FTBUltimineAddition.rl("gathering_amethyst").toString());
            AdvancementHolder cardBlueprint = Advancement.Builder.advancement().parent(amethyst).display((ItemLike)ModItems.CARD_BLUEPRINT, (Component)Component.translatable((String)String.format("advancement.%s.craft.card_blueprint", "ultimine_addition")), (Component)Component.translatable((String)String.format("advancement.%s.craft", "ultimine_addition"), (Object[])new Object[]{ModItems.CARD_BLUEPRINT.getDefaultInstance().getHoverName()}), null, AdvancementType.TASK, true, true, false).addCriterion("amethyst_adv", AdvancementTriggers.advancementTrigger(amethyst)).addCriterion("has_card_blueprint", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ModItems.CARD_BLUEPRINT})).requirements(AdvancementRequirements.Strategy.AND).save(consumer, FTBUltimineAddition.rl("card_blueprint").toString());
            AdvancementHolder shapeSelector = Advancement.Builder.advancement().parent(cardBlueprint).display((ItemLike)ModItems.SHAPE_SELECTOR, (Component)Component.translatable((String)String.format("advancement.%s.craft.shape_selector", "ultimine_addition")), (Component)Component.translatable((String)String.format("advancement.%s.craft", "ultimine_addition"), (Object[])new Object[]{ModItems.SHAPE_SELECTOR.getDefaultInstance().getHoverName()}), null, AdvancementType.TASK, true, true, false).addCriterion("has_card_blueprint", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ModItems.CARD_BLUEPRINT})).addCriterion("has_shape_selector", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ModItems.SHAPE_SELECTOR})).requirements(AdvancementRequirements.Strategy.AND).save(consumer, FTBUltimineAddition.rl("shape_selector").toString());
            AdvancementHolder slime = Advancement.Builder.advancement().parent(root).display((ItemLike)Items.SLIME_BALL, (Component)Component.translatable((String)String.format("advancement.%s.obtain.slime_balls", "ultimine_addition")), (Component)Component.translatable((String)String.format("advancement.%s.obtain", "ultimine_addition"), (Object[])new Object[]{Items.SLIME_BALL.getDefaultInstance().getHoverName()}), null, AdvancementType.TASK, true, true, false).addCriterion("has_slime_balls", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.SLIME_BALL})).requirements(AdvancementRequirements.Strategy.OR).save(consumer, FTBUltimineAddition.rl("slime_balls").toString());
            AdvancementHolder pen = Advancement.Builder.advancement().parent(slime).display((ItemLike)ModItems.PEN, (Component)Component.translatable((String)String.format("advancement.%s.craft.pen", "ultimine_addition")), (Component)Component.translatable((String)String.format("advancement.%s.craft", "ultimine_addition"), (Object[])new Object[]{ModItems.PEN.getDefaultInstance().getHoverName()}), null, AdvancementType.TASK, true, true, false).addCriterion("slime_adv", AdvancementTriggers.advancementTrigger(slime)).addCriterion("has_pen", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ModItems.PEN})).requirements(AdvancementRequirements.Strategy.AND).save(consumer, FTBUltimineAddition.rl("pen").toString());
            AdvancementHolder emptyCard = Advancement.Builder.advancement().parent(root).display((ItemLike)ModItems.MINING_SKILL_CARD_EMPTY, (Component)Component.translatable((String)String.format("advancement.%s.obtain.card.empty", "ultimine_addition")), (Component)Component.translatable((String)String.format("advancement.%s.obtain", "ultimine_addition"), (Object[])new Object[]{ModItems.MINING_SKILL_CARD_EMPTY.getDefaultInstance().getHoverName()}), null, AdvancementType.TASK, true, true, false).addCriterion("trade_for_empty_card", AdvancementTriggers.tradedWithVillager(ItemPredicate.Builder.item().of(new ItemLike[]{ModItems.MINING_SKILL_CARD_EMPTY}).build())).addCriterion("has_empty_card", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ModItems.MINING_SKILL_CARD_EMPTY})).requirements(AdvancementRequirements.Strategy.OR).save(consumer, FTBUltimineAddition.rl("empty_card").toString());
            AdvancementHolder skillsRecord = Advancement.Builder.advancement().parent(emptyCard).display((ItemLike)ModItems.SKILLS_RECORD, (Component)Component.translatable((String)String.format("advancement.%s.craft.skills_record", "ultimine_addition")), (Component)Component.translatable((String)String.format("advancement.%s.craft", "ultimine_addition"), (Object[])new Object[]{ModItems.SKILLS_RECORD.getDefaultInstance().getHoverName()}), null, AdvancementType.GOAL, true, true, false).addCriterion("has_skills_record", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ModItems.SKILLS_RECORD})).requirements(AdvancementRequirements.Strategy.OR).save(consumer, FTBUltimineAddition.rl("skills_record").toString());
            AdvancementHolder pickaxeCard = Advancement.Builder.advancement().parent(emptyCard).display((ItemLike)ModItems.MINING_SKILL_CARD_PICKAXE, (Component)Component.translatable((String)String.format("advancement.%s.craft.card.pickaxe", "ultimine_addition")), (Component)Component.translatable((String)String.format("advancement.%s.craft", "ultimine_addition"), (Object[])new Object[]{ModItems.MINING_SKILL_CARD_PICKAXE.getDefaultInstance().getHoverName()}), null, AdvancementType.TASK, true, true, false).addCriterion("has_pickaxe_card", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ModItems.MINING_SKILL_CARD_PICKAXE})).requirements(AdvancementRequirements.Strategy.OR).save(consumer, FTBUltimineAddition.rl("pickaxe_card").toString());
            AdvancementHolder axeCard = Advancement.Builder.advancement().parent(emptyCard).display((ItemLike)ModItems.MINING_SKILL_CARD_AXE, (Component)Component.translatable((String)String.format("advancement.%s.craft.card.axe", "ultimine_addition")), (Component)Component.translatable((String)String.format("advancement.%s.craft", "ultimine_addition"), (Object[])new Object[]{ModItems.MINING_SKILL_CARD_AXE.getDefaultInstance().getHoverName()}), null, AdvancementType.TASK, true, true, false).addCriterion("has_axe_card", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ModItems.MINING_SKILL_CARD_AXE})).requirements(AdvancementRequirements.Strategy.OR).save(consumer, FTBUltimineAddition.rl("axe_card").toString());
            AdvancementHolder shovelCard = Advancement.Builder.advancement().parent(emptyCard).display((ItemLike)ModItems.MINING_SKILL_CARD_SHOVEL, (Component)Component.translatable((String)String.format("advancement.%s.craft.card.shovel", "ultimine_addition")), (Component)Component.translatable((String)String.format("advancement.%s.craft", "ultimine_addition"), (Object[])new Object[]{ModItems.MINING_SKILL_CARD_SHOVEL.getDefaultInstance().getHoverName()}), null, AdvancementType.TASK, true, true, false).addCriterion("has_shovel_card", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ModItems.MINING_SKILL_CARD_SHOVEL})).requirements(AdvancementRequirements.Strategy.OR).save(consumer, FTBUltimineAddition.rl("shovel_card").toString());
            AdvancementHolder hoeCard = Advancement.Builder.advancement().parent(emptyCard).display((ItemLike)ModItems.MINING_SKILL_CARD_HOE, (Component)Component.translatable((String)String.format("advancement.%s.craft.card.hoe", "ultimine_addition")), (Component)Component.translatable((String)String.format("advancement.%s.craft", "ultimine_addition"), (Object[])new Object[]{ModItems.MINING_SKILL_CARD_HOE.getDefaultInstance().getHoverName()}), null, AdvancementType.TASK, true, true, false).addCriterion("has_hoe_card", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ModItems.MINING_SKILL_CARD_HOE})).requirements(AdvancementRequirements.Strategy.OR).save(consumer, FTBUltimineAddition.rl("hoe_card").toString());
            AdvancementHolder ultiminePower = Advancement.Builder.advancement().parent(skillsRecord).display((ItemStack)Util.make(() -> {
                ItemStack stack = ModItems.MINER_CERTIFICATE.getDefaultInstance();
                MinerCertificateData.loadData(stack).setAccomplished(true).saveData(stack);
                return stack;
            }), (Component)Component.translatable((String)String.format("advancement.%s.ultimine_ability", "ultimine_addition")), (Component)Component.translatable((String)String.format("advancement.%s.ultimine_ability.desc", "ultimine_addition"), (Object[])new Object[]{ModItems.MINER_CERTIFICATE.getDefaultInstance().getHoverName()}), null, AdvancementType.CHALLENGE, true, true, false).addCriterion("has_ultimine_ability", UltimineObtainTrigger.Instance.obtain()).requirements(AdvancementRequirements.Strategy.OR).save(consumer, FTBUltimineAddition.rl("ultimine_ability").toString());
        }
    }
}

