/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.core.neoforge;

import java.util.List;
import net.ixdarklord.ultimine_addition.common.data.player.PlayerAbilityData;
import net.ixdarklord.ultimine_addition.common.tag.PlatformTags;
import net.ixdarklord.ultimine_addition.core.ServicePlatform;
import net.ixdarklord.ultimine_addition.core.neoforge.NeoForgeSetup;
import net.ixdarklord.ultimine_addition.network.PayloadHandler;
import net.ixdarklord.ultimine_addition.network.payloads.PlayerAbilityPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;

public class ServicePlatformPlayersImpl
implements ServicePlatform.Players {
    @Override
    public boolean isPlayerUltimineCapable(Player player) {
        return player.hasData(NeoForgeSetup.PLAYER_ABILITY_DATA) && ((PlayerAbilityData)player.getData(NeoForgeSetup.PLAYER_ABILITY_DATA)).getAbility();
    }

    @Override
    public void setPlayerUltimineCapability(Player player, boolean state) {
        PlayerAbilityData data = PlayerAbilityData.create();
        player.setData(NeoForgeSetup.PLAYER_ABILITY_DATA, (Object)data.setAbility(state));
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PayloadHandler.sendToPlayer(new PlayerAbilityPayload(data.getAbility()), serverPlayer);
        }
    }

    @Override
    public boolean isCorrectToolForBlock(ItemStack stack, BlockState state) {
        return stack.isCorrectToolForDrops(state);
    }

    @Override
    public boolean isToolPaxel(ItemStack stack) {
        if (stack.is(PlatformTags.get().PAXELS()) || stack.is(PlatformTags.get().TOOLS_PAXELS())) {
            return true;
        }
        ItemAbility PAXEL_DIG = ItemAbility.get((String)"paxel_dig");
        if (stack.canPerformAction(PAXEL_DIG)) {
            return true;
        }
        List<ItemAbility> ACTIONS = List.of(ItemAbilities.PICKAXE_DIG, ItemAbilities.AXE_DIG, ItemAbilities.SHOVEL_DIG, ItemAbilities.HOE_DIG);
        for (ItemAbility action : ACTIONS) {
            if (stack.canPerformAction(action)) continue;
            return false;
        }
        return true;
    }
}

