/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.core;

import dev.ftb.mods.ftbultimine.api.restriction.RestrictionHandler;
import dev.ftb.mods.ftbultimine.api.shape.Shape;
import dev.ftb.mods.ftbultimine.client.FTBUltimineClient;
import dev.ftb.mods.ftbultimine.config.FTBUltimineServerConfig;
import dev.ftb.mods.ftbultimine.integration.IntegrationHandler;
import dev.ftb.mods.ftbultimine.integration.ranks.FTBRanksIntegration;
import dev.ftb.mods.ftbultimine.shape.ShapeRegistry;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.ixdarklord.ultimine_addition.common.data.item.SelectedShapeData;
import net.ixdarklord.ultimine_addition.common.effect.MineGoJuiceEffect;
import net.ixdarklord.ultimine_addition.common.item.MiningSkillCardItem;
import net.ixdarklord.ultimine_addition.config.ConfigHandler;
import net.ixdarklord.ultimine_addition.config.PlaystyleMode;
import net.ixdarklord.ultimine_addition.core.Registration;
import net.ixdarklord.ultimine_addition.core.ServicePlatform;
import net.ixdarklord.ultimine_addition.core.ShapeRegistryAccessor;
import net.ixdarklord.ultimine_addition.util.ItemUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class FTBUltimineIntegration
implements RestrictionHandler {
    public static FTBUltimineIntegration INSTANCE = new FTBUltimineIntegration();
    private static boolean isButtonPressed;

    public boolean canUltimine(Player player) {
        boolean result = ServicePlatform.get().players().isPlayerUltimineCapable(player);
        if (result) {
            return true;
        }
        if (ConfigHandler.COMMON.PLAYSTYLE_MODE.get() == PlaystyleMode.LEGACY) {
            return result;
        }
        if (FTBUltimineIntegration.isPlayerHasCustomCardValidEffect(player) && ItemUtils.isItemInHandCustomCardValid(player)) {
            result = true;
        }
        if (!ItemUtils.checkTargetedBlock(player)) {
            return false;
        }
        if (player.hasEffect((Holder)BuiltInRegistries.MOB_EFFECT.getHolder(Registration.MINE_GO_JUICE_PICKAXE.getId()).orElseThrow()) && ItemUtils.isItemInHandPickaxe(player)) {
            result = true;
        }
        if (player.hasEffect((Holder)BuiltInRegistries.MOB_EFFECT.getHolder(Registration.MINE_GO_JUICE_AXE.getId()).orElseThrow()) && ItemUtils.isItemInHandAxe(player)) {
            result = true;
        }
        if (player.hasEffect((Holder)BuiltInRegistries.MOB_EFFECT.getHolder(Registration.MINE_GO_JUICE_SHOVEL.getId()).orElseThrow()) && ItemUtils.isItemInHandShovel(player)) {
            result = true;
        }
        if (player.hasEffect((Holder)BuiltInRegistries.MOB_EFFECT.getHolder(Registration.MINE_GO_JUICE_HOE.getId()).orElseThrow()) && ItemUtils.isItemInHandHoe(player)) {
            result = true;
        }
        return result;
    }

    public static void keyEvent(Player player) {
        if (FTBUltimineClient.keyBindUltimine.isDown()) {
            if (!isButtonPressed) {
                MutableComponent MSG = Component.translatable((String)"info.ultimine_addition.incapable");
                MutableComponent requiredTool = null;
                if (!ServicePlatform.get().players().isPlayerUltimineCapable(player)) {
                    if (ItemUtils.isItemInHandCustomCardValid(player)) {
                        if (!FTBUltimineIntegration.isPlayerHasCustomCardValidEffect(player)) {
                            String[] toolNames = (String[])FTBUltimineIntegration.getCustomCardTypes(player).stream().map(MiningSkillCardItem.Type::getId).toArray(String[]::new);
                            String toolPrefix = toolNames.length > 1 ? "many_tools" : toolNames[0];
                            MutableComponent toolsList = Component.empty();
                            for (int i = 0; i < toolNames.length; ++i) {
                                toolsList.append("[").append((Component)Component.translatable((String)"info.ultimine_addition.required_skill.%s".formatted(toolNames[i]))).append("]");
                                if (i == toolNames.length - 1) continue;
                                toolsList.append(", ");
                            }
                            HoverEvent event = new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)toolsList);
                            Style style = toolNames.length > 1 ? Style.EMPTY.withUnderlined(Boolean.valueOf(true)).withHoverEvent(event) : Style.EMPTY;
                            requiredTool = Component.translatable((String)"info.ultimine_addition.required_skill.%s".formatted(toolPrefix)).withStyle(style);
                        }
                    } else if (ItemUtils.isItemInHandPickaxe(player)) {
                        if (!player.hasEffect((Holder)BuiltInRegistries.MOB_EFFECT.getHolder(Registration.MINE_GO_JUICE_PICKAXE.getId()).orElseThrow())) {
                            requiredTool = Component.translatable((String)"info.ultimine_addition.required_skill.pickaxe");
                        }
                    } else if (ItemUtils.isItemInHandAxe(player)) {
                        if (!player.hasEffect((Holder)BuiltInRegistries.MOB_EFFECT.getHolder(Registration.MINE_GO_JUICE_AXE.getId()).orElseThrow())) {
                            requiredTool = Component.translatable((String)"info.ultimine_addition.required_skill.axe");
                        }
                    } else if (ItemUtils.isItemInHandShovel(player)) {
                        if (!player.hasEffect((Holder)BuiltInRegistries.MOB_EFFECT.getHolder(Registration.MINE_GO_JUICE_SHOVEL.getId()).orElseThrow())) {
                            requiredTool = Component.translatable((String)"info.ultimine_addition.required_skill.shovel");
                        }
                    } else if (ItemUtils.isItemInHandHoe(player)) {
                        if (!player.hasEffect((Holder)BuiltInRegistries.MOB_EFFECT.getHolder(Registration.MINE_GO_JUICE_HOE.getId()).orElseThrow())) {
                            requiredTool = Component.translatable((String)"info.ultimine_addition.required_skill.hoe");
                        }
                    } else if (!ItemUtils.isItemInHandTool(player)) {
                        requiredTool = Component.translatable((String)"info.ultimine_addition.required_skill.all");
                    }
                    if (ConfigHandler.COMMON.PLAYSTYLE_MODE.get() != PlaystyleMode.LEGACY) {
                        if (requiredTool != null) {
                            player.displayClientMessage((Component)MSG.withStyle(ChatFormatting.RED), false);
                            player.displayClientMessage((Component)Component.literal((String)"\u2716 ").append((Component)Component.translatable((String)"info.ultimine_addition.required_skill", (Object[])new Object[]{requiredTool})).withStyle(ChatFormatting.GRAY), false);
                        }
                    } else {
                        player.displayClientMessage((Component)MSG.withStyle(ChatFormatting.RED), false);
                    }
                }
                isButtonPressed = true;
            }
        } else {
            isButtonPressed = false;
        }
    }

    public static List<MiningSkillCardItem.Type> getCustomCardTypes(Player player) {
        ItemStack stack = ItemUtils.getItemInHand(player, true);
        return MiningSkillCardItem.Type.TYPES.stream().filter(MiningSkillCardItem.Type::isCustomType).filter(type -> type.utilizeRequiredTools().contains(stack.getItem())).toList();
    }

    private static boolean isPlayerHasCustomCardValidEffect(Player player) {
        List<MiningSkillCardItem.Type> types = FTBUltimineIntegration.getCustomCardTypes(player);
        for (MiningSkillCardItem.Type type : types) {
            Optional mobEffect = BuiltInRegistries.MOB_EFFECT.getHolder(MineGoJuiceEffect.getId(type));
            if (mobEffect.isEmpty() || !player.hasEffect((Holder)mobEffect.get())) continue;
            return true;
        }
        return false;
    }

    public static int getMaxBlocks(ServerPlayer player) {
        if (!((Boolean)ConfigHandler.SERVER.CARD_TIER_BASED_MAX_BLOCKS.get()).booleanValue()) {
            return IntegrationHandler.ranksMod ? FTBRanksIntegration.getMaxBlocks((ServerPlayer)player) : (Integer)FTBUltimineServerConfig.MAX_BLOCKS.get();
        }
        ArrayList<MobEffectInstance> instances = new ArrayList<MobEffectInstance>(player.getActiveEffects().stream().filter(mobEffectInstance -> mobEffectInstance.getEffect().value() instanceof MineGoJuiceEffect).toList());
        if (!ServicePlatform.get().players().isPlayerUltimineCapable((Player)player) && !instances.isEmpty()) {
            instances.sort(Comparator.comparingInt(MobEffectInstance::getAmplifier).reversed());
            if (ItemUtils.isItemInHandCustomCardValid((Player)player)) {
                instances.removeIf(instance -> {
                    ItemStack stack = ItemUtils.getItemInHand((Player)player, true);
                    Item patt0$temp = stack.getItem();
                    if (patt0$temp instanceof MiningSkillCardItem) {
                        MiningSkillCardItem cardItem = (MiningSkillCardItem)patt0$temp;
                        return ((MineGoJuiceEffect)instance.getEffect()).getType() != cardItem.getType();
                    }
                    return false;
                });
            } else if (ItemUtils.isItemInHandPickaxe((Player)player)) {
                instances.removeIf(instance -> ((MineGoJuiceEffect)((Object)((Object)instance.getEffect().value()))).getType() != MiningSkillCardItem.Type.PICKAXE);
            } else if (ItemUtils.isItemInHandAxe((Player)player)) {
                instances.removeIf(instance -> ((MineGoJuiceEffect)((Object)((Object)instance.getEffect().value()))).getType() != MiningSkillCardItem.Type.AXE);
            } else if (ItemUtils.isItemInHandShovel((Player)player)) {
                instances.removeIf(instance -> ((MineGoJuiceEffect)((Object)((Object)instance.getEffect().value()))).getType() != MiningSkillCardItem.Type.SHOVEL);
            } else if (ItemUtils.isItemInHandHoe((Player)player)) {
                instances.removeIf(instance -> ((MineGoJuiceEffect)((Object)((Object)instance.getEffect().value()))).getType() != MiningSkillCardItem.Type.HOE);
            }
            if (!instances.isEmpty()) {
                try {
                    return ConfigHandler.SERVER.CARD_TIER_MAX_BLOCKS.getValue(MiningSkillCardItem.Tier.fromInt(((MobEffectInstance)instances.getFirst()).getAmplifier() + 1));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        return IntegrationHandler.ranksMod ? FTBRanksIntegration.getMaxBlocks((ServerPlayer)player) : (Integer)FTBUltimineServerConfig.MAX_BLOCKS.get();
    }

    public static List<Shape> getShapesList() {
        ShapeRegistry instance = ShapeRegistry.INSTANCE;
        return ((ShapeRegistryAccessor)instance).getShapesList();
    }

    public static Shape getDefaultShape() {
        ShapeRegistry instance = ShapeRegistry.INSTANCE;
        return ((ShapeRegistryAccessor)instance).getDefaultShape();
    }

    public static List<Shape> getEnabledShapes() {
        return FTBUltimineIntegration.getShapesList().stream().filter(shape -> !((List)ConfigHandler.SERVER.BLACKLISTED_SHAPES.get()).contains(shape.getName().toString())).toList();
    }

    public static Shape getShape(ResourceLocation shapeId) {
        for (Shape shape : FTBUltimineIntegration.getShapesList()) {
            if (!shape.getName().equals((Object)shapeId)) continue;
            return shape;
        }
        return null;
    }

    public static Shape getEnabledShapes(int idx) {
        if (idx < 0) {
            idx += FTBUltimineIntegration.getEnabledShapes().size();
        } else if (idx >= FTBUltimineIntegration.getEnabledShapes().size()) {
            idx -= FTBUltimineIntegration.getEnabledShapes().size();
        }
        return idx >= 0 && idx < FTBUltimineIntegration.getEnabledShapes().size() ? FTBUltimineIntegration.getEnabledShapes().get(idx) : FTBUltimineIntegration.getDefaultShape();
    }

    public static boolean hasToolWithShape(Player player) {
        ItemStack stack = player.getMainHandItem();
        return stack.has((DataComponentType)Registration.SELECTED_SHAPE_COMPONENT.get());
    }

    public static Shape getToolShape(Player player) {
        ItemStack stack = player.getMainHandItem();
        return Objects.requireNonNull((SelectedShapeData)stack.get((DataComponentType)Registration.SELECTED_SHAPE_COMPONENT.get())).shape();
    }
}

