/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.config;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.ixdarklord.coolcatlib.api.util.ValueConverter;
import net.ixdarklord.ultimine_addition.core.FTBUltimineAddition;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ListConfigValue<T> {
    protected ModConfigSpec.ConfigValue<String> configValue;
    protected final int expectedSize;
    protected final Predicate<T> elementValidator;
    protected final ValueConverter<T> valueConverter;

    public ListConfigValue(int expectedSize, Predicate<T> elementValidator, ValueConverter<T> valueConverter) {
        this.expectedSize = expectedSize;
        this.elementValidator = elementValidator;
        this.valueConverter = valueConverter;
    }

    protected void define(ModConfigSpec.Builder builder, String key, List<T> defaultValue, String ... comment) {
        if (defaultValue.size() != this.expectedSize) {
            throw new IllegalArgumentException("Default value list must have exactly " + this.expectedSize + " elements.");
        }
        for (T value : defaultValue) {
            if (this.elementValidator.test(value)) continue;
            throw new IllegalArgumentException("Default value " + String.valueOf(value) + " does not meet validation criteria.");
        }
        String defaultValueString = this.listToString(defaultValue);
        this.configValue = builder.comment(comment).define(key, (Object)defaultValueString, obj -> {
            if (!(obj instanceof String)) {
                return false;
            }
            List<T> parsedList = this.parseStringToList((String)obj);
            if (parsedList.size() != this.expectedSize) {
                return false;
            }
            for (T value : parsedList) {
                if (this.elementValidator.test(value)) continue;
                return false;
            }
            return true;
        });
    }

    private String listToString(List<T> list) {
        StringBuilder sb = new StringBuilder();
        for (T value : list) {
            if (!sb.isEmpty()) {
                sb.append(", ");
            }
            sb.append(this.valueConverter.toString(value));
        }
        return sb.toString();
    }

    private List<T> parseStringToList(String input) {
        String[] parts;
        ArrayList<Object> list = new ArrayList<Object>();
        for (String part : parts = input.split(",")) {
            list.add(this.valueConverter.parse(part.trim()));
        }
        return Collections.unmodifiableList(list);
    }

    public ModConfigSpec.ConfigValue<String> getConfigValue() {
        if (this.configValue == null) {
            throw new IllegalStateException("ConfigValue has not been defined yet.");
        }
        return this.configValue;
    }

    public void set(List<T> values) {
        this.getConfigValue().set((Object)this.listToString(values));
    }

    protected List<T> getValue() {
        return this.parseStringToList((String)this.getConfigValue().get());
    }

    protected List<T> getDefaultValue() {
        return this.parseStringToList((String)this.getConfigValue().getDefault());
    }

    public boolean validate() {
        List<T> list = this.getValue();
        if (list.size() != this.expectedSize) {
            return false;
        }
        for (T value : list) {
            if (this.elementValidator.test(value)) continue;
            return false;
        }
        return true;
    }

    public static final class EnumValue<E extends Enum<E>>
    extends ListConfigValue<Integer> {
        private final Class<E> enumClass;
        private final int minValue;
        private final int maxValue;

        public EnumValue(int expectedSize, Class<E> enumClass, int min, int max) {
            super(expectedSize, value -> value >= min && value <= max, ValueConverter.INTEGER);
            this.enumClass = enumClass;
            this.minValue = min;
            this.maxValue = max;
        }

        public void defineEnums(ModConfigSpec.Builder builder, String key, Map<E, Integer> defaultValue, String ... comment) {
            if (defaultValue.size() != this.expectedSize) {
                throw new IllegalArgumentException("Default value map must have exactly " + this.expectedSize + " elements.");
            }
            String defaultValueString = this.mapToString(defaultValue, (ValueConverter<Integer>)this.valueConverter);
            this.configValue = builder.comment(comment).define(key, (Object)defaultValueString, obj -> {
                if (!(obj instanceof String)) {
                    return false;
                }
                Map<E, Integer> parsedMap = this.parseStringToMap((String)obj, (ValueConverter<Integer>)this.valueConverter);
                if (parsedMap.size() != this.expectedSize) {
                    return false;
                }
                for (Integer value : parsedMap.values()) {
                    if (this.elementValidator.test(value)) continue;
                    return false;
                }
                return true;
            });
        }

        private String mapToString(Map<E, Integer> map, ValueConverter<Integer> valueConverter) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<E, Integer> entry : map.entrySet()) {
                if (!sb.isEmpty()) {
                    sb.append(", ");
                }
                sb.append(((Enum)entry.getKey()).name()).append("=").append(valueConverter.toString((Object)entry.getValue()));
            }
            return sb.toString();
        }

        private Map<E, Integer> parseStringToMap(String input, ValueConverter<Integer> valueConverter) {
            String[] parts;
            HashMap<E, Integer> map = new HashMap<E, Integer>();
            for (String part : parts = input.split(",")) {
                String[] keyValue = part.trim().split("=");
                if (keyValue.length != 2) continue;
                E enumKey = Enum.valueOf(this.enumClass, keyValue[0].trim());
                int value = (Integer)valueConverter.parse(keyValue[1].trim());
                if (!this.elementValidator.test(value)) {
                    FTBUltimineAddition.LOGGER.error("Value {} is not within the range [{}, {}]", (Object)value, (Object)this.minValue, (Object)this.maxValue);
                }
                map.put(enumKey, value);
            }
            return map;
        }

        public Map<E, Integer> getMapValue() {
            return this.parseStringToMap((String)this.configValue.get(), (ValueConverter<Integer>)this.valueConverter);
        }

        public Map<E, Integer> getDefaultMapValue() {
            return this.parseStringToMap((String)this.configValue.getDefault(), (ValueConverter<Integer>)this.valueConverter);
        }

        public Integer getValue(E enumKey) {
            Map<E, Integer> map = this.getMapValue();
            return map.get(enumKey);
        }

        public Integer getDefaultValue(E enumKey) {
            Map<E, Integer> map = this.getDefaultMapValue();
            return map.get(enumKey);
        }
    }

    public static final class RangeValue
    extends ListConfigValue<Integer> {
        public RangeValue(int minValue, int maxValue) {
            super(2, value -> value >= minValue && value <= maxValue, ValueConverter.INTEGER);
        }

        public void define(ModConfigSpec.Builder builder, String key, int minRange, int maxRange, String ... comment) {
            super.define(builder, key, ImmutableList.of((Object)minRange, (Object)maxRange), comment);
        }

        public int getMin() {
            return (Integer)this.getValue().getFirst();
        }

        public int getMax() {
            return (Integer)this.getValue().getLast();
        }
    }
}

