/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.config;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.ixdarklord.ultimine_addition.config.PlaystyleMode;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import org.jetbrains.annotations.NotNull;

public record ConfigValueWrapper<T>(Class<T> type, T value) {
    private static final Map<Class<?>, StreamCodec<? super FriendlyByteBuf, ?>> TYPE_CODECS = new HashMap();
    private static final Map<String, Supplier<Class<?>>> TYPE_FACTORIES = new HashMap();
    public static final StreamCodec<FriendlyByteBuf, ConfigValueWrapper<?>> CODEC;

    public static <T> void registerType(Class<T> typeClass, StreamCodec<? super FriendlyByteBuf, T> codec) {
        TYPE_CODECS.put(typeClass, codec);
        TYPE_FACTORIES.put(typeClass.getName(), () -> typeClass);
    }

    public <V> V getValueAs(Class<V> targetType) {
        if (targetType.isAssignableFrom(this.type)) {
            return (V)this.value;
        }
        throw new ClassCastException("Cannot cast " + this.type.getSimpleName() + " to " + targetType.getSimpleName());
    }

    static {
        ConfigValueWrapper.registerType(Boolean.class, ByteBufCodecs.BOOL);
        ConfigValueWrapper.registerType(Integer.class, ByteBufCodecs.INT);
        ConfigValueWrapper.registerType(Double.class, ByteBufCodecs.DOUBLE);
        ConfigValueWrapper.registerType(String.class, ByteBufCodecs.STRING_UTF8);
        ConfigValueWrapper.registerType(PlaystyleMode.class, PlaystyleMode.STREAM_CODEC);
        CODEC = new StreamCodec<FriendlyByteBuf, ConfigValueWrapper<?>>(){

            public void encode(FriendlyByteBuf buffer, ConfigValueWrapper<?> wrapper) {
                buffer.writeUtf(wrapper.type().getName());
                this.getCodec(wrapper.type()).encode((Object)buffer, wrapper.value());
            }

            @NotNull
            public ConfigValueWrapper<?> decode(FriendlyByteBuf buffer) {
                String className = buffer.readUtf();
                Class<?> typeClass = this.resolveClass(className);
                StreamCodec codec = this.getCodec(typeClass);
                Object value = codec.decode((Object)buffer);
                return this.createWrapper(typeClass, value);
            }

            private Class<?> resolveClass(String className) {
                Supplier<Class<?>> factory = TYPE_FACTORIES.get(className);
                if (factory == null) {
                    throw new IllegalArgumentException("Unregistered type: " + className);
                }
                return factory.get();
            }

            private <V> StreamCodec<FriendlyByteBuf, V> getCodec(Class<?> typeClass) {
                StreamCodec<? super FriendlyByteBuf, ?> codec = TYPE_CODECS.get(typeClass);
                if (codec == null) {
                    throw new IllegalArgumentException("No codec for type: " + typeClass.getSimpleName());
                }
                return codec;
            }

            private <V> ConfigValueWrapper<V> createWrapper(Class<?> typeClass, Object value) {
                return new ConfigValueWrapper<Object>(typeClass, value);
            }
        };
    }
}

