/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.config;

import java.util.Locale;
import net.minecraft.util.StringRepresentable;
import net.neoforged.fml.config.IConfigSpec;
import org.jetbrains.annotations.NotNull;

public record ConfigInfo(String modId, Type type, IConfigSpec spec, String fileName) {
    public ConfigInfo(String modId, String configType, IConfigSpec spec, String fileName) {
        this(modId, Type.typeFromString(configType), spec, fileName);
    }

    public static enum Type implements StringRepresentable
    {
        COMMON,
        CLIENT,
        SERVER,
        STARTUP;


        public static Type typeFromString(String name) {
            for (Type type : Type.values()) {
                if (!type.name().equalsIgnoreCase(name)) continue;
                return type;
            }
            throw new IllegalArgumentException("Invalid type: " + name);
        }

        public String extension() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        @NotNull
        public String getSerializedName() {
            return this.extension();
        }
    }
}

