/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.common.recipe.ingredient;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.ixdarklord.ultimine_addition.common.data.item.MiningSkillCardData;
import net.ixdarklord.ultimine_addition.common.item.MiningSkillCardItem;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MCIngredient
implements Predicate<ItemStack> {
    public static final MCIngredient EMPTY = new MCIngredient(Stream.empty());
    public static final Codec<MCIngredient> CODEC;
    public static final Codec<MCIngredient> CODEC_NONEMPTY;
    public static final StreamCodec<RegistryFriendlyByteBuf, MCIngredient> CONTENTS_STREAM_CODEC;
    private final Value[] values;
    @Nullable
    private ItemStack[] itemStacks;
    private Optional<MiningSkillCardItem.Tier> tier;
    @Nullable
    private IntList stackingIds;

    private MCIngredient(Stream<? extends Value> stream) {
        this.values = (Value[])stream.toArray(Value[]::new);
    }

    private MCIngredient(Value[] values) {
        this.values = values;
    }

    public ItemStack[] getItems() {
        this.dissolve();
        return this.itemStacks;
    }

    public Optional<MiningSkillCardItem.Tier> getTier() {
        this.dissolve();
        return this.tier;
    }

    private void dissolve() {
        if (this.itemStacks == null) {
            this.itemStacks = (ItemStack[])Arrays.stream(this.values).flatMap(value -> value.getItems().stream()).distinct().toArray(ItemStack[]::new);
        }
        this.tier = Arrays.stream(this.values).map(Value::getTier).toList().getFirst();
    }

    @Override
    public boolean test(@Nullable ItemStack stack) {
        ItemStack[] stacks;
        if (stack == null) {
            return false;
        }
        this.dissolve();
        if (this.itemStacks.length == 0) {
            return stack.isEmpty();
        }
        for (ItemStack itemStack : stacks = this.itemStacks) {
            if (!itemStack.is(stack.getItem())) continue;
            if (this.tier.isPresent()) {
                MiningSkillCardData cardData = MiningSkillCardData.loadData(stack);
                return this.tier.get().equals((Object)cardData.getTier());
            }
            return true;
        }
        return false;
    }

    public IntList getStackingIds() {
        if (this.stackingIds == null) {
            ItemStack[] itemStacks = this.getItems();
            this.stackingIds = new IntArrayList(itemStacks.length);
            for (ItemStack itemStack : itemStacks) {
                this.stackingIds.add(StackedContents.getStackingIndex((ItemStack)itemStack));
            }
            this.stackingIds.sort(IntComparators.NATURAL_COMPARATOR);
        }
        return this.stackingIds;
    }

    public boolean isEmpty() {
        return this.values.length == 0;
    }

    public boolean equals(Object object) {
        if (object instanceof MCIngredient) {
            MCIngredient ingredient = (MCIngredient)object;
            return Arrays.equals(this.values, ingredient.values);
        }
        return false;
    }

    private static MCIngredient fromValues(Stream<? extends Value> stream) {
        MCIngredient mcIngredient = new MCIngredient(stream);
        return mcIngredient.values.length == 0 ? EMPTY : mcIngredient;
    }

    public static MCIngredient of() {
        return EMPTY;
    }

    public static MCIngredient of(MiningSkillCardItem.Tier tier, ItemLike ... items) {
        return MCIngredient.of(tier, Arrays.stream(items).map(ItemStack::new));
    }

    public static MCIngredient of(MiningSkillCardItem.Tier tier, ItemStack ... stacks) {
        return MCIngredient.of(tier, Arrays.stream(stacks));
    }

    public static MCIngredient of(MiningSkillCardItem.Tier tier, Stream<ItemStack> stacks) {
        return MCIngredient.fromValues(stacks.filter(itemStack -> !itemStack.isEmpty()).map(stack -> new ItemValue((ItemStack)stack, Optional.ofNullable(tier))));
    }

    public static MCIngredient of(MiningSkillCardItem.Tier tier, TagKey<Item> tag) {
        return MCIngredient.fromValues(Stream.of(new TagValue(tag, Optional.ofNullable(tier))));
    }

    public static NonNullList<Ingredient> toNormal(NonNullList<MCIngredient> inputs) {
        NonNullList result = NonNullList.create();
        result.addAll(inputs.stream().filter(ingredient -> !Arrays.stream(ingredient.values).filter(value -> value instanceof ItemValue).toList().isEmpty()).map(ingredient -> {
            ItemStack[] items = (ItemStack[])Arrays.stream(ingredient.getItems()).toArray(ItemStack[]::new);
            return Ingredient.of((ItemStack[])items);
        }).toList());
        result.addAll(inputs.stream().filter(ingredient -> !Arrays.stream(ingredient.values).filter(value -> value instanceof TagValue).toList().isEmpty()).map(ingredient -> {
            Optional<TagKey> optional = Arrays.stream(ingredient.values).filter(value -> value instanceof TagValue).map(value -> ((TagValue)value).tag).findFirst();
            return optional.map(Ingredient::of).orElse(Ingredient.EMPTY);
        }).toList());
        return result;
    }

    private static Codec<MCIngredient> codec(boolean allowEmpty) {
        Codec codec = Codec.list(Value.CODEC).comapFlatMap(list -> !allowEmpty && list.isEmpty() ? DataResult.error(() -> "Item array cannot be empty, at least one item must be defined") : DataResult.success((Object)list.toArray(new Value[0])), List::of);
        return Codec.either((Codec)codec, Value.CODEC).flatComapMap(either -> (MCIngredient)either.map(MCIngredient::new, value -> new MCIngredient(new Value[]{value})), ingredient -> {
            if (ingredient.values.length == 1) {
                return DataResult.success((Object)Either.right((Object)ingredient.values[0]));
            }
            return ingredient.values.length == 0 && !allowEmpty ? DataResult.error(() -> "Item array cannot be empty, at least one item must be defined") : DataResult.success((Object)Either.left((Object)ingredient.values));
        });
    }

    static {
        CONTENTS_STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, MCIngredient>(){

            @NotNull
            public MCIngredient decode(RegistryFriendlyByteBuf buf) {
                return MCIngredient.of((MiningSkillCardItem.Tier)((Optional)ByteBufCodecs.optional(MiningSkillCardItem.Tier.STREAM_CODEC).decode((Object)buf)).orElse(null), ((List)ItemStack.LIST_STREAM_CODEC.decode((Object)buf)).stream());
            }

            public void encode(RegistryFriendlyByteBuf buf, MCIngredient ingredient) {
                ByteBufCodecs.optional(MiningSkillCardItem.Tier.STREAM_CODEC).encode((Object)buf, ingredient.getTier());
                ItemStack.LIST_STREAM_CODEC.encode((Object)buf, Arrays.stream(ingredient.getItems()).toList());
            }
        };
        CODEC = MCIngredient.codec(true);
        CODEC_NONEMPTY = MCIngredient.codec(false);
    }

    private static interface Value {
        public static final Codec<Value> CODEC = Codec.xor(ItemValue.CODEC, TagValue.CODEC).xmap(either -> (Value)either.map(itemValue -> itemValue, tagValue -> tagValue), value -> {
            if (value instanceof ItemValue) {
                ItemValue itemValue = (ItemValue)value;
                return Either.left((Object)itemValue);
            }
            if (value instanceof TagValue) {
                TagValue tagValue = (TagValue)value;
                return Either.right((Object)tagValue);
            }
            throw new UnsupportedOperationException("This is neither an item value nor a tag value.");
        });

        public Collection<ItemStack> getItems();

        public Optional<MiningSkillCardItem.Tier> getTier();
    }

    private record TagValue(TagKey<Item> tag, Optional<MiningSkillCardItem.Tier> tier) implements Value
    {
        static final Codec<TagValue> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)TagKey.codec((ResourceKey)Registries.ITEM).fieldOf("tag").forGetter(TagValue::tag), (App)MiningSkillCardItem.Tier.CODEC.optionalFieldOf("card_tier").forGetter(TagValue::getTier)).apply((Applicative)instance, TagValue::new));

        @Override
        public boolean equals(Object object) {
            if (object instanceof TagValue) {
                TagValue tagValue = (TagValue)object;
                return tagValue.tag.location().equals((Object)this.tag.location());
            }
            return false;
        }

        @Override
        public Collection<ItemStack> getItems() {
            ArrayList list = Lists.newArrayList();
            for (Holder item : BuiltInRegistries.ITEM.getTagOrEmpty(this.tag)) {
                Item item2;
                ItemStack stack = new ItemStack(item);
                if (this.tier.isPresent() && (item2 = stack.getItem()) instanceof MiningSkillCardItem) {
                    MiningSkillCardItem cardItem = (MiningSkillCardItem)item2;
                    cardItem.getData(stack).setTier(this.tier.get()).saveData(stack);
                }
                list.add(stack);
            }
            return list;
        }

        @Override
        public Optional<MiningSkillCardItem.Tier> getTier() {
            return this.tier;
        }
    }

    private record ItemValue(ItemStack stack, Optional<MiningSkillCardItem.Tier> tier) implements Value
    {
        static final Codec<ItemValue> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.SIMPLE_ITEM_CODEC.fieldOf("item").forGetter(ItemValue::stack), (App)MiningSkillCardItem.Tier.CODEC.optionalFieldOf("card_tier").forGetter(ItemValue::getTier)).apply((Applicative)instance, ItemValue::new));

        @Override
        public Collection<ItemStack> getItems() {
            Item item;
            if (this.tier.isPresent() && (item = this.stack.getItem()) instanceof MiningSkillCardItem) {
                MiningSkillCardItem cardItem = (MiningSkillCardItem)item;
                cardItem.getData(this.stack).setTier(this.tier.get()).saveData(this.stack);
            }
            return Collections.singleton(this.stack);
        }

        @Override
        public Optional<MiningSkillCardItem.Tier> getTier() {
            return this.tier;
        }
    }
}

