/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.common.recipe.ingredient;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DataIngredient
implements Predicate<ItemStack> {
    public static final DataIngredient EMPTY = new DataIngredient(Stream.empty());
    public static final Codec<DataIngredient> CODEC;
    public static final Codec<DataIngredient> CODEC_NONEMPTY;
    public static final StreamCodec<RegistryFriendlyByteBuf, DataIngredient> CONTENTS_STREAM_CODEC;
    private final Value[] values;
    @Nullable
    private ItemStack[] itemStacks;
    private int amount;
    @Nullable
    private IntList stackingIds;

    private DataIngredient(Stream<? extends Value> stream) {
        this.values = (Value[])stream.toArray(Value[]::new);
    }

    private DataIngredient(Value[] values) {
        this.values = values;
    }

    public ItemStack[] getItems() {
        this.dissolve();
        return this.itemStacks;
    }

    public int getAmount() {
        this.dissolve();
        return this.amount;
    }

    private void dissolve() {
        if (this.itemStacks == null) {
            this.itemStacks = (ItemStack[])Arrays.stream(this.values).flatMap(value -> value.getItems().stream()).distinct().toArray(ItemStack[]::new);
        }
        this.amount = Arrays.stream(this.values).map(Value::getAmount).toList().getFirst();
    }

    @Override
    public boolean test(@Nullable ItemStack stack) {
        ItemStack[] stacks;
        if (stack == null) {
            return false;
        }
        this.dissolve();
        if (this.itemStacks.length == 0) {
            return stack.isEmpty();
        }
        for (ItemStack itemStack : stacks = this.itemStacks) {
            if (!itemStack.is(stack.getItem())) continue;
            return true;
        }
        return false;
    }

    public IntList getStackingIds() {
        if (this.stackingIds == null) {
            ItemStack[] var1;
            this.dissolve();
            this.stackingIds = new IntArrayList(this.itemStacks.length);
            for (ItemStack itemStack : var1 = this.itemStacks) {
                this.stackingIds.add(StackedContents.getStackingIndex((ItemStack)itemStack));
            }
            this.stackingIds.sort(IntComparators.NATURAL_COMPARATOR);
        }
        return this.stackingIds;
    }

    public boolean isEmpty() {
        return !(this.values.length != 0 || this.itemStacks != null && this.itemStacks.length != 0 || this.stackingIds != null && !this.stackingIds.isEmpty());
    }

    private static DataIngredient fromValues(Stream<? extends Value> stream) {
        DataIngredient DataIngredient2 = new DataIngredient(stream);
        return DataIngredient2.values.length == 0 ? EMPTY : DataIngredient2;
    }

    public static DataIngredient of() {
        return EMPTY;
    }

    public static DataIngredient of(int amount, ItemLike ... items) {
        return DataIngredient.of(amount, Arrays.stream(items).map(ItemStack::new));
    }

    public static DataIngredient of(int amount, ItemStack ... stacks) {
        return DataIngredient.of(amount, Arrays.stream(stacks));
    }

    public static DataIngredient of(int amount, Stream<ItemStack> stacks) {
        return DataIngredient.fromValues(stacks.filter(itemStack -> !itemStack.isEmpty()).map(stack -> new ItemValue((ItemStack)stack, amount)));
    }

    public static DataIngredient of(TagKey<Item> tag, int amount) {
        return DataIngredient.fromValues(Stream.of(new TagValue(tag, amount)));
    }

    public static NonNullList<Ingredient> toNormal(NonNullList<DataIngredient> inputs) {
        NonNullList result = NonNullList.create();
        result.addAll(inputs.stream().map(ingredient -> {
            ItemStack[] items = (ItemStack[])Arrays.stream(ingredient.getItems()).peek(stack -> CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, compoundTag -> compoundTag.putInt("amount", ingredient.getAmount()))).toArray(ItemStack[]::new);
            return Ingredient.of((ItemStack[])items);
        }).toList());
        return result;
    }

    private static Codec<DataIngredient> codec(boolean allowEmpty) {
        Codec codec = Codec.list(Value.CODEC).comapFlatMap(list -> !allowEmpty && list.isEmpty() ? DataResult.error(() -> "Item array cannot be empty, at least one item must be defined") : DataResult.success((Object)list.toArray(new Value[0])), List::of);
        return Codec.either((Codec)codec, Value.CODEC).flatComapMap(either -> (DataIngredient)either.map(DataIngredient::new, value -> new DataIngredient(new Value[]{value})), ingredient -> {
            if (ingredient.values.length == 1) {
                return DataResult.success((Object)Either.right((Object)ingredient.values[0]));
            }
            return ingredient.values.length == 0 && !allowEmpty ? DataResult.error(() -> "Item array cannot be empty, at least one item must be defined") : DataResult.success((Object)Either.left((Object)ingredient.values));
        });
    }

    static {
        CONTENTS_STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, DataIngredient>(){

            @NotNull
            public DataIngredient decode(RegistryFriendlyByteBuf buf) {
                return DataIngredient.of((int)((Integer)ByteBufCodecs.INT.decode((Object)buf)), ((List)ItemStack.LIST_STREAM_CODEC.decode((Object)buf)).stream());
            }

            public void encode(RegistryFriendlyByteBuf buf, DataIngredient ingredient) {
                ByteBufCodecs.INT.encode((Object)buf, (Object)ingredient.getAmount());
                ItemStack.LIST_STREAM_CODEC.encode((Object)buf, Arrays.stream(ingredient.getItems()).toList());
            }
        };
        CODEC = DataIngredient.codec(true);
        CODEC_NONEMPTY = DataIngredient.codec(false);
    }

    static interface Value {
        public static final Codec<Value> CODEC = Codec.xor(ItemValue.CODEC, TagValue.CODEC).xmap(either -> (Value)either.map(itemValue -> itemValue, tagValue -> tagValue), value -> {
            if (value instanceof ItemValue) {
                ItemValue itemValue = (ItemValue)value;
                return Either.left((Object)itemValue);
            }
            if (value instanceof TagValue) {
                TagValue tagValue = (TagValue)value;
                return Either.right((Object)tagValue);
            }
            throw new UnsupportedOperationException("This is neither an item value nor a tag value.");
        });

        public Collection<ItemStack> getItems();

        public int getAmount();
    }

    private record TagValue(TagKey<Item> tag, int amount) implements Value
    {
        static final Codec<TagValue> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)TagKey.codec((ResourceKey)Registries.ITEM).fieldOf("tag").forGetter(TagValue::tag), (App)Codec.INT.optionalFieldOf("increment_amount", (Object)0).forGetter(TagValue::getAmount)).apply((Applicative)instance, TagValue::new));

        @Override
        public boolean equals(Object object) {
            if (object instanceof TagValue) {
                TagValue tagValue = (TagValue)object;
                return tagValue.tag.location().equals((Object)this.tag.location());
            }
            return false;
        }

        @Override
        public Collection<ItemStack> getItems() {
            ArrayList list = Lists.newArrayList();
            for (Holder holder : BuiltInRegistries.ITEM.getTagOrEmpty(this.tag)) {
                list.add(new ItemStack(holder));
            }
            return list;
        }

        @Override
        public int getAmount() {
            return this.amount;
        }
    }

    private record ItemValue(ItemStack stack, int amount) implements Value
    {
        static final Codec<ItemValue> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.SIMPLE_ITEM_CODEC.fieldOf("item").forGetter(ItemValue::stack), (App)Codec.INT.optionalFieldOf("increment_amount", (Object)0).forGetter(ItemValue::getAmount)).apply((Applicative)instance, ItemValue::new));

        @Override
        public Collection<ItemStack> getItems() {
            return Collections.singleton(this.stack);
        }

        @Override
        public int getAmount() {
            return this.amount;
        }
    }
}

