/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.common.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.ixdarklord.ultimine_addition.common.item.MiningSkillCardItem;
import net.ixdarklord.ultimine_addition.common.recipe.ingredient.MCIngredient;
import net.ixdarklord.ultimine_addition.core.Registration;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class MCRecipe
extends ShapelessRecipe {
    final String group;
    final CraftingBookCategory category;
    final ItemStack result;
    final NonNullList<MCIngredient> ingredients;

    public MCRecipe(String group, CraftingBookCategory category, ItemStack result, NonNullList<MCIngredient> ingredients) {
        super(group, category, result, MCIngredient.toNormal(ingredients));
        this.group = group;
        this.category = category;
        this.result = result;
        this.ingredients = ingredients;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)Registration.MC_RECIPE_SERIALIZER.get();
    }

    @NotNull
    public String getGroup() {
        return this.group;
    }

    @NotNull
    public CraftingBookCategory category() {
        return this.category;
    }

    @NotNull
    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.result;
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        return MCIngredient.toNormal(this.ingredients);
    }

    @NotNull
    public NonNullList<MCIngredient> getMCIngredients() {
        return this.ingredients;
    }

    public boolean matches(CraftingInput input, Level level) {
        if (input.ingredientCount() != this.ingredients.size()) {
            return false;
        }
        return input.size() == 1 && this.ingredients.size() == 1 ? ((MCIngredient)this.ingredients.getFirst()).test(input.getItem(0)) : input.stackedContents().canCraft((Recipe)this, null);
    }

    @NotNull
    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        ItemStack stack = this.result.copy();
        Item item = stack.getItem();
        if (item instanceof MiningSkillCardItem) {
            MiningSkillCardItem item2 = (MiningSkillCardItem)item;
            NonNullList inputs = NonNullList.create();
            for (ItemStack itemStack : input.items()) {
                if (itemStack.isEmpty() || itemStack.getItem() instanceof MiningSkillCardItem) continue;
                inputs.add((Object)itemStack.copy());
            }
            if (!inputs.isEmpty()) {
                item2.getData(stack).setDisplayItem((ItemStack)inputs.getFirst());
            }
            item2.getData(stack).initChallenges().saveData(stack);
        }
        return stack;
    }

    public static class Serializer
    implements RecipeSerializer<MCRecipe> {
        public static final MapCodec<MCRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(MCRecipe::getGroup), (App)CraftingBookCategory.CODEC.optionalFieldOf("category", (Object)CraftingBookCategory.MISC).forGetter(MCRecipe::category), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(mcRecipe -> mcRecipe.result), (App)MCIngredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(list -> {
            Object[] ingredients = (MCIngredient[])list.stream().filter(ingredient -> !ingredient.isEmpty()).toArray(MCIngredient[]::new);
            if (ingredients.length == 0) {
                return DataResult.error(() -> "No ingredients for MCRecipe");
            }
            return ingredients.length > 9 ? DataResult.error(() -> "Too many ingredients for MCRecipe") : DataResult.success((Object)NonNullList.of((Object)MCIngredient.EMPTY, (Object[])ingredients));
        }, DataResult::success).forGetter(MCRecipe::getMCIngredients)).apply((Applicative)instance, MCRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, MCRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        @NotNull
        public MapCodec<MCRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, MCRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        @NotNull
        private static MCRecipe fromNetwork(RegistryFriendlyByteBuf buf) {
            String group = buf.readUtf();
            CraftingBookCategory craftingBookCategory = (CraftingBookCategory)buf.readEnum(CraftingBookCategory.class);
            NonNullList nonnulllist = (NonNullList)MCIngredient.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.collection(NonNullList::createWithCapacity)).decode((Object)buf);
            ItemStack stack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf);
            return new MCRecipe(group, craftingBookCategory, stack, (NonNullList<MCIngredient>)nonnulllist);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buf, MCRecipe recipe) {
            buf.writeUtf(recipe.group);
            buf.writeEnum((Enum)recipe.category);
            buf.writeVarInt(recipe.ingredients.size());
            MCIngredient.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.collection(NonNullList::createWithCapacity)).encode((Object)buf, recipe.getMCIngredients());
            ItemStack.STREAM_CODEC.encode((Object)buf, (Object)recipe.result);
        }
    }
}

