/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.common.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import net.ixdarklord.ultimine_addition.common.data.item.ItemStorageData;
import net.ixdarklord.ultimine_addition.common.item.StorageDataAbstractItem;
import net.ixdarklord.ultimine_addition.common.recipe.ingredient.DataIngredient;
import net.ixdarklord.ultimine_addition.core.Registration;
import net.ixdarklord.ultimine_addition.util.ItemUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ItemStorageDataRecipe
extends CustomRecipe {
    final String group;
    final CraftingBookCategory category;
    final ItemStack result;
    final String storageName;
    final NonNullList<DataIngredient> ingredients;

    public ItemStorageDataRecipe(String group, CraftingBookCategory category, ItemStack result, String storageName, NonNullList<DataIngredient> ingredients) {
        super(category);
        this.group = group;
        this.category = category;
        this.result = result;
        this.storageName = storageName;
        this.ingredients = ingredients;
    }

    @NotNull
    public NonNullList<ItemStack> getRemainingItems(CraftingInput input) {
        int i;
        NonNullList items = NonNullList.withSize((int)input.items().size(), (Object)ItemStack.EMPTY);
        ArrayList<ItemUtils.ItemSorter> sorterList = new ArrayList<ItemUtils.ItemSorter>();
        int sameItems = 0;
        for (i = 0; i < items.size(); ++i) {
            Item item = input.getItem(i).getItem();
            if (!(item instanceof StorageDataAbstractItem)) continue;
            StorageDataAbstractItem item2 = (StorageDataAbstractItem)item;
            ItemStorageData data = ItemStorageData.loadData(this.storageName, item2.getMaxCapacity(), input.getItem(i));
            sorterList.add(new ItemUtils.ItemSorter(input.getItem(i), i, data.getCapacity()));
            ++sameItems;
        }
        if (sameItems <= 1) {
            return items;
        }
        sorterList.sort((o1, o2) -> Integer.compare(o2.order(), o1.order()));
        for (i = 1; i < sorterList.size(); ++i) {
            ItemStack stack = ((ItemUtils.ItemSorter)sorterList.get(i)).item().copy();
            StorageDataAbstractItem item = (StorageDataAbstractItem)stack.getItem();
            ItemStorageData.loadData(this.storageName, item.getMaxCapacity(), stack).setCapacity(0).saveData(stack);
            items.set(((ItemUtils.ItemSorter)sorterList.get(i)).slotId(), (Object)stack);
        }
        return items;
    }

    public boolean matches(CraftingInput input, @NotNull Level level) {
        ItemStorageData data;
        int capacity = 0;
        int matchedValue = 0;
        ArrayList<ItemUtils.ItemSorter> sorterList = new ArrayList<ItemUtils.ItemSorter>();
        for (ItemStack itemStack : input.items()) {
            ItemStack stack2 = itemStack.copy();
            Item item = stack2.getItem();
            if (item instanceof StorageDataAbstractItem) {
                StorageDataAbstractItem item2 = (StorageDataAbstractItem)item;
                ItemStorageData data2 = ItemStorageData.loadData(this.storageName, item2.getMaxCapacity(), stack2);
                sorterList.add(new ItemUtils.ItemSorter(stack2, 0, data2.getCapacity()));
                capacity += data2.getCapacity();
                ++matchedValue;
                continue;
            }
            for (DataIngredient ingredient : this.ingredients) {
                if (!ingredient.test(stack2)) continue;
                capacity += ingredient.getAmount();
                ++matchedValue;
            }
        }
        if (sorterList.isEmpty()) {
            return false;
        }
        sorterList.sort((o1, o2) -> Integer.compare(o2.order(), o1.order()));
        if (sorterList.size() > 1) {
            for (int i = 1; i < sorterList.size(); ++i) {
                data = ItemStorageData.loadData(this.storageName, 0, ((ItemUtils.ItemSorter)sorterList.get(i)).item());
                if (data.getCapacity() != 0) continue;
                return false;
            }
        }
        int size = input.items().stream().filter(stack -> !stack.isEmpty()).toList().size();
        data = ItemStorageData.loadData(this.storageName, 0, ((ItemUtils.ItemSorter)sorterList.getFirst()).item());
        boolean isValid = matchedValue >= 2 && size == matchedValue;
        boolean isOverflow = capacity > data.getMaxCapacity();
        return isValid && !isOverflow;
    }

    @NotNull
    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        int amount = 0;
        for (ItemStack stack : input.items()) {
            if (stack.isEmpty()) continue;
            if (stack.is(this.result.getItem())) {
                amount += ItemStorageData.loadData(this.storageName, 0, stack).getCapacity();
                continue;
            }
            for (DataIngredient ingredient : this.ingredients) {
                if (!ingredient.test(stack)) continue;
                amount += ingredient.getAmount();
            }
        }
        ItemStack stack = this.result.copy();
        ItemStorageData.loadData(this.storageName, ((StorageDataAbstractItem)stack.getItem()).getMaxCapacity(), stack).setCapacity(amount).saveData(stack);
        return stack;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= this.ingredients.size();
    }

    public CraftingBookCategory getCategory() {
        return this.category;
    }

    public ItemStack getResultItem() {
        return this.result;
    }

    @NotNull
    public NonNullList<DataIngredient> getDataIngredients() {
        return this.ingredients;
    }

    public String getStorageName() {
        return this.storageName;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)Registration.ITEM_DATA_STORAGE_RECIPE_SERIALIZER.get();
    }

    public static class Serializer
    implements RecipeSerializer<ItemStorageDataRecipe> {
        public static final MapCodec<ItemStorageDataRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(Recipe::getGroup), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(CustomRecipe::category), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(dataRecipe -> dataRecipe.result), (App)Codec.STRING.fieldOf("storage_name").forGetter(ItemStorageDataRecipe::getStorageName), (App)DataIngredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(list -> {
            Object[] ingredients = (DataIngredient[])list.stream().filter(ingredient -> !ingredient.isEmpty()).toArray(DataIngredient[]::new);
            if (ingredients.length == 0) {
                return DataResult.error(() -> "No ingredients for ItemStorageDataRecipe");
            }
            return ingredients.length > 9 ? DataResult.error(() -> "Too many ingredients for ItemStorageDataRecipe") : DataResult.success((Object)NonNullList.of((Object)DataIngredient.EMPTY, (Object[])ingredients));
        }, DataResult::success).forGetter(ItemStorageDataRecipe::getDataIngredients)).apply((Applicative)instance, ItemStorageDataRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ItemStorageDataRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        @NotNull
        public MapCodec<ItemStorageDataRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, ItemStorageDataRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        @NotNull
        private static ItemStorageDataRecipe fromNetwork(RegistryFriendlyByteBuf buf) {
            String group = buf.readUtf();
            CraftingBookCategory category = (CraftingBookCategory)buf.readEnum(CraftingBookCategory.class);
            int i = buf.readVarInt();
            NonNullList nonnulllist = NonNullList.withSize((int)i, (Object)DataIngredient.EMPTY);
            nonnulllist.replaceAll(ignored -> (DataIngredient)DataIngredient.CONTENTS_STREAM_CODEC.decode((Object)buf));
            ItemStack stack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf);
            String storageName = buf.readUtf();
            return new ItemStorageDataRecipe(group, category, stack, storageName, (NonNullList<DataIngredient>)nonnulllist);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buf, ItemStorageDataRecipe recipe) {
            buf.writeUtf(recipe.group);
            buf.writeEnum((Enum)recipe.category);
            buf.writeVarInt(recipe.ingredients.size());
            for (DataIngredient ingredient : recipe.ingredients) {
                DataIngredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)ingredient);
            }
            ItemStack.STREAM_CODEC.encode((Object)buf, (Object)recipe.result);
            buf.writeUtf(recipe.getStorageName());
        }
    }
}

