/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.common.menu;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import net.ixdarklord.ultimine_addition.common.data.item.SkillsRecordData;
import net.ixdarklord.ultimine_addition.common.item.PenItem;
import net.ixdarklord.ultimine_addition.common.item.SkillsRecordItem;
import net.ixdarklord.ultimine_addition.common.menu.DataAbstractContainerMenu;
import net.ixdarklord.ultimine_addition.common.menu.slot.CustomSlot;
import net.ixdarklord.ultimine_addition.common.menu.slot.MiningSkillCardSlot;
import net.ixdarklord.ultimine_addition.common.menu.slot.PaperSlot;
import net.ixdarklord.ultimine_addition.common.menu.slot.PenSlot;
import net.ixdarklord.ultimine_addition.core.FTBUltimineAddition;
import net.ixdarklord.ultimine_addition.core.Registration;
import net.ixdarklord.ultimine_addition.core.ServicePlatform;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SkillsRecordMenu
extends DataAbstractContainerMenu<SkillsRecordData> {
    public static final int CONTAINER_SIZE = 6;
    public static final int[] CARD_SLOTS = new int[]{0, 1, 2, 3};
    private final ItemStack stack;
    private final Player player;
    private final Inventory playerInventory;
    private final SimpleContainer container;
    @Nullable
    public final InteractionHand interactionHand;

    public SkillsRecordMenu(int id, Inventory inventory, RegistryFriendlyByteBuf buf) {
        this(id, inventory, inventory.player, (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf), buf.readBoolean() ? (InteractionHand)buf.readEnum(InteractionHand.class) : null);
    }

    public SkillsRecordMenu(int id, Inventory playerInventory, Player player, ItemStack stack, @Nullable InteractionHand interactionHand) {
        super((MenuType)Registration.SKILLS_RECORD_CONTAINER.get(), id);
        if (!(stack.getItem() instanceof SkillsRecordItem)) {
            throw new IllegalArgumentException("Invalid item! This container only accepts Skills Record.");
        }
        this.stack = stack;
        this.player = player;
        this.playerInventory = playerInventory;
        this.container = this.createData().getContainer();
        this.container.addListener(this::slotsChanged);
        this.interactionHand = interactionHand;
        this.addSlotBox((Container)this.container, 0, 8, 107, 4, 22, 1, 0);
        this.addSlot(new PenSlot((Container)this.container, 4, 129, 107));
        this.addSlot(new PaperSlot((Container)this.container, 5, 151, 107));
        this.layoutPlayerInventorySlots(16, 140);
    }

    public void slotsChanged(Container container) {
        super.slotsChanged(container);
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer sPlayer = (ServerPlayer)player;
            this.getData().sendToClient(sPlayer, this.interactionHand).saveData(this.stack);
        }
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        Slot sourceSlot = (Slot)this.slots.get(index);
        if (!sourceSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceStack = sourceSlot.getItem();
        ItemStack copyOfSourceStack = sourceStack.copy();
        if (index >= this.container.getContainerSize() && index < this.container.getContainerSize() + 36) {
            if (!this.moveItemStackTo(sourceStack, 0, this.container.getContainerSize(), false)) {
                return ItemStack.EMPTY;
            }
        } else if (index > -1) {
            if (!this.moveItemStackTo(sourceStack, this.container.getContainerSize(), this.container.getContainerSize() + 36, true)) {
                return ItemStack.EMPTY;
            }
        } else {
            FTBUltimineAddition.LOGGER.error("Invalid slotIndex:{}", (Object)index);
            return ItemStack.EMPTY;
        }
        if (sourceStack.getCount() == 0) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        sourceSlot.onTake(player, sourceStack);
        return copyOfSourceStack;
    }

    public boolean stillValid(@NotNull Player player) {
        return ItemStack.isSameItem((ItemStack)this.getInteractionHand().map(arg_0 -> ((Player)player).getItemInHand(arg_0)).orElseGet(() -> ServicePlatform.get().slotAPI().getSkillsRecordItem(player)), (ItemStack)this.stack);
    }

    public Player getPlayer() {
        return this.player;
    }

    private int addSlotRange(Container container, int index, int x, int y, int amount, int dx) {
        for (int i = 0; i < amount; ++i) {
            if (container.getContainerSize() == this.container.getContainerSize()) {
                this.addSlot(new MiningSkillCardSlot(container, index, x, y));
            } else {
                this.addSlot(new Slot(container, index, x, y));
            }
            x += dx;
            ++index;
        }
        return index;
    }

    private void addSlotBox(Container container, int index, int x, int y, int horAmount, int dx, int verAmount, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            index = this.addSlotRange(container, index, x, y, horAmount, dx);
            y += dy;
        }
    }

    private void layoutPlayerInventorySlots(int leftCol, int topRow) {
        this.addSlotBox((Container)this.playerInventory, 9, leftCol, topRow, 9, 18, 3, 18);
        this.addSlotRange((Container)this.playerInventory, 0, leftCol, topRow += 58, 9, 18);
    }

    public NonNullList<Slot> getAllSlots() {
        NonNullList SLOTS = NonNullList.create();
        for (int i = 0; i < this.container.getContainerSize(); ++i) {
            if (!(this.slots.get(i) instanceof CustomSlot)) continue;
            SLOTS.add(i, (Object)((Slot)this.slots.get(i)));
        }
        return SLOTS;
    }

    public NonNullList<Slot> getCardSlots() {
        NonNullList SLOTS = NonNullList.create();
        for (int i = 0; i < this.container.getContainerSize(); ++i) {
            if (!(this.slots.get(i) instanceof MiningSkillCardSlot)) continue;
            SLOTS.add(i, (Object)((Slot)this.slots.get(i)));
        }
        return SLOTS;
    }

    public boolean isCardSlotsEmpty() {
        AtomicBoolean value = new AtomicBoolean(true);
        this.getCardSlots().forEach(slot -> {
            if (!slot.getItem().isEmpty()) {
                value.set(false);
            }
        });
        return value.get();
    }

    public int getInkAmount() {
        ItemStack stack = ((Slot)this.getAllSlots().get(4)).getItem();
        Item item = stack.getItem();
        if (item instanceof PenItem) {
            PenItem item2 = (PenItem)item;
            return item2.getData(stack).getCapacity();
        }
        return 0;
    }

    public SkillsRecordData getData() {
        return this.createData().insertContainer((Container)this.container);
    }

    public Optional<InteractionHand> getInteractionHand() {
        return Optional.ofNullable(this.interactionHand);
    }

    @Override
    public SkillsRecordData createData() {
        return SkillsRecordData.loadData(this.stack);
    }
}

