/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.common.item;

import net.ixdarklord.coolcatlib.api.item.ComponentItem;
import net.ixdarklord.ultimine_addition.common.data.item.ItemStorageData;
import net.ixdarklord.ultimine_addition.common.item.DataAbstractItem;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public abstract class StorageDataAbstractItem
extends DataAbstractItem<ItemStorageData> {
    protected final String storageName;
    protected final int maxCapacity;

    public StorageDataAbstractItem(Item.Properties properties, ItemStorageData storageData, ComponentItem.ComponentType componentType) {
        super(properties, componentType);
        this.storageName = storageData.getStorageName();
        this.maxCapacity = storageData.getMaxCapacity();
    }

    public int getMaxCapacity() {
        return this.maxCapacity;
    }

    public boolean isBarVisible(ItemStack itemStack) {
        return !this.getData(itemStack).isFull();
    }

    public int getBarWidth(ItemStack itemStack) {
        ItemStorageData data = this.getData(itemStack);
        return Math.round((float)data.getCapacity() / (float)data.getMaxCapacity() * 13.0f);
    }

    public int getBarColor(ItemStack itemStack) {
        return Mth.hsvToRgb((float)(Math.max(0.0f, (float)this.getBarWidth(itemStack) / 13.0f) / 3.0f), (float)1.0f, (float)1.0f);
    }

    @Override
    public ItemStorageData getData(ItemStack stack) {
        return ItemStorageData.loadData(this.storageName, this.maxCapacity, stack);
    }
}

