/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.common.item;

import dev.architectury.registry.menu.MenuRegistry;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import net.ixdarklord.coolcatlib.api.item.ComponentItem;
import net.ixdarklord.coolcatlib.api.util.ComponentHelper;
import net.ixdarklord.ultimine_addition.client.gui.tooltip.SkillsRecordTooltip;
import net.ixdarklord.ultimine_addition.common.data.challenge.ChallengesData;
import net.ixdarklord.ultimine_addition.common.data.challenge.ChallengesManager;
import net.ixdarklord.ultimine_addition.common.data.item.MiningSkillCardData;
import net.ixdarklord.ultimine_addition.common.data.item.SkillsRecordData;
import net.ixdarklord.ultimine_addition.common.item.DataAbstractItem;
import net.ixdarklord.ultimine_addition.common.item.PenItem;
import net.ixdarklord.ultimine_addition.common.menu.SkillsRecordMenu;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class SkillsRecordItem
extends DataAbstractItem<SkillsRecordData> {
    public static final Component TITLE = Component.translatable((String)"item.ultimine_addition.skills_record");

    public SkillsRecordItem(Item.Properties properties) {
        super(properties, ComponentItem.ComponentType.TOOLS);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, @NotNull InteractionHand usedHand) {
        ItemStack stack = player.getItemInHand(usedHand);
        if (level.isClientSide()) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }
        if (player.isShiftKeyDown()) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }
        if (this.isLegacyMode()) {
            player.displayClientMessage((Component)Component.translatable((String)"info.ultimine_addition.legacy_mode").withStyle(ChatFormatting.RED), false);
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }
        if (stack.has(SkillsRecordData.DATA_COMPONENT)) {
            MenuRegistry.openExtendedMenu((ServerPlayer)((ServerPlayer)player), (MenuProvider)new SimpleMenuProvider((id, inv, p) -> new SkillsRecordMenu(id, inv, p, stack, usedHand), TITLE), buf -> {
                ItemStack.STREAM_CODEC.encode((Object)new RegistryFriendlyByteBuf((ByteBuf)buf, ((ServerPlayer)player).serverLevel().registryAccess()), (Object)stack);
                buf.writeBoolean(true);
                buf.writeEnum((Enum)usedHand);
            });
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slotID, boolean isSelected) {
        if (this.isLegacyMode() || level.isClientSide()) {
            return;
        }
        if (entity instanceof ServerPlayer) {
            if (!stack.has(SkillsRecordData.DATA_COMPONENT)) {
                this.getData(stack).saveData(stack);
            }
            if (this.getData(stack).getCardSlots().stream().filter(s -> !s.isEmpty()).toList().isEmpty() && this.getData(stack).isConsumeMode()) {
                this.getData(stack).toggleConsumeMode().saveData(stack);
            }
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        super.appendHoverText(stack, context, tooltipComponents, isAdvanced);
        if (this.isShiftButtonNotPressed(tooltipComponents)) {
            return;
        }
        if (!stack.has(SkillsRecordData.DATA_COMPONENT)) {
            MutableComponent component = Component.translatable((String)"tooltip.ultimine_addition.skills_record.info").withStyle(ChatFormatting.GRAY);
            List components = ComponentHelper.splitComponent((Component)component, (int)this.getSplitterLength());
            tooltipComponents.addAll(components);
            return;
        }
        if (this.isConsumeChallengeExists(stack)) {
            MutableComponent state = this.getData(stack).isConsumeMode() ? Component.translatable((String)"options.on").withStyle(ChatFormatting.GREEN) : Component.translatable((String)"options.off").withStyle(ChatFormatting.RED);
            tooltipComponents.add((Component)Component.literal((String)"\u00a78\u2022 ").withStyle(ChatFormatting.DARK_GRAY).append((Component)Component.translatable((String)"gui.ultimine_addition.skills_record.consume", (Object[])new Object[]{state}).withStyle(ChatFormatting.GRAY)));
        }
        if (!this.getData(stack).getPenSlot().isEmpty()) {
            Integer n;
            MutableComponent mutableComponent = Component.literal((String)"\u00a78\u2022 ").withStyle(ChatFormatting.DARK_GRAY);
            Object[] objectArray = new Object[1];
            Item item = this.getData(stack).getPenSlot().getItem();
            if (item instanceof PenItem) {
                PenItem item2 = (PenItem)item;
                n = item2.getData(this.getData(stack).getPenSlot()).getCapacity();
            } else {
                n = 0;
            }
            objectArray[0] = n;
            tooltipComponents.add((Component)mutableComponent.append((Component)Component.translatable((String)"tooltip.ultimine_addition.pen.ink_chamber", (Object[])objectArray).withStyle(ChatFormatting.GRAY)));
        }
        tooltipComponents.add((Component)Component.literal((String)"\u00a78\u2022 ").withStyle(ChatFormatting.DARK_GRAY).append((Component)Component.translatable((String)"tooltip.ultimine_addition.skills_record.contents").withStyle(ChatFormatting.GRAY)));
        tooltipComponents.add((Component)Component.literal((String)"ultimine_addition.tooltip_image"));
    }

    @NotNull
    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        NonNullList nonNullList = NonNullList.create();
        Stream itemStackStream = this.getData(stack).getAllSlots().stream();
        Objects.requireNonNull(nonNullList);
        itemStackStream.forEach(arg_0 -> nonNullList.add(arg_0));
        if (stack.has(SkillsRecordData.DATA_COMPONENT) && !this.isShiftButtonNotPressed(null)) {
            return Optional.of(new SkillsRecordTooltip((NonNullList<ItemStack>)nonNullList));
        }
        return Optional.empty();
    }

    public boolean isConsumeChallengeExists(ItemStack stack) {
        AtomicBoolean result = new AtomicBoolean();
        this.getData(stack).getCardSlots().forEach(itemStack -> {
            MiningSkillCardData cardData = MiningSkillCardData.loadData(itemStack);
            if (!cardData.getChallenges().stream().filter(challengeData -> {
                ChallengesData data = ChallengesManager.INSTANCE.getAllChallenges().get(challengeData.getId());
                if (data != null) {
                    return data.getChallengeType().isConsuming();
                }
                return false;
            }).toList().isEmpty()) {
                result.set(true);
            }
        });
        return result.get();
    }

    @Override
    public SkillsRecordData getData(ItemStack stack) {
        return SkillsRecordData.loadData(stack);
    }
}

