/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.common.item;

import dev.architectury.registry.menu.MenuRegistry;
import java.util.List;
import net.ixdarklord.coolcatlib.api.item.ComponentItem;
import net.ixdarklord.coolcatlib.api.util.ComponentHelper;
import net.ixdarklord.ultimine_addition.common.menu.ShapeSelectorMenu;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ShapeSelectorItem
extends ComponentItem {
    public static final Component TITLE = Component.translatable((String)"item.ultimine_addition.shape_selector");

    public ShapeSelectorItem(Item.Properties properties) {
        super(properties, ComponentItem.ComponentType.TOOLS);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        if (this.isShiftButtonNotPressed(tooltipComponents)) {
            return;
        }
        MutableComponent component = Component.translatable((String)"tooltip.ultimine_addition.shape_selector.info").withStyle(ChatFormatting.GRAY);
        List components = ComponentHelper.splitComponent((Component)component, (int)this.getSplitterLength());
        tooltipComponents.addAll(components);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        if (!(player instanceof ServerPlayer)) {
            return super.use(level, player, usedHand);
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        MenuRegistry.openMenu((ServerPlayer)serverPlayer, (MenuProvider)new SimpleMenuProvider(ShapeSelectorMenu::new, TITLE));
        return super.use(level, player, usedHand);
    }

    public boolean appendToName() {
        return true;
    }
}

