/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.common.item;

import java.util.List;
import net.ixdarklord.coolcatlib.api.item.ComponentItem;
import net.ixdarklord.coolcatlib.api.util.ComponentHelper;
import net.ixdarklord.ultimine_addition.client.gui.screens.SkillsRecordScreen;
import net.ixdarklord.ultimine_addition.common.data.item.ItemStorageData;
import net.ixdarklord.ultimine_addition.common.item.StorageDataAbstractItem;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class PenItem
extends StorageDataAbstractItem {
    public PenItem(Item.Properties properties) {
        super(properties, ItemStorageData.create("ink_chamber", 2000), ComponentItem.ComponentType.TOOLS);
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slotId, boolean isSelected) {
        if (this.isLegacyMode() || level.isClientSide()) {
            return;
        }
        if (!stack.has(ItemStorageData.DATA_COMPONENT) && entity instanceof ServerPlayer) {
            this.getData(stack).saveData(stack);
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        super.appendHoverText(stack, context, tooltipComponents, isAdvanced);
        if (!(Minecraft.getInstance().screen instanceof SkillsRecordScreen) && !stack.has(ItemStorageData.DATA_COMPONENT) && this.isShiftButtonNotPressed(tooltipComponents)) {
            return;
        }
        if (!stack.has(ItemStorageData.DATA_COMPONENT)) {
            MutableComponent component = Component.translatable((String)"tooltip.ultimine_addition.pen.info").withStyle(ChatFormatting.GRAY);
            List components = ComponentHelper.splitComponent((Component)component, (int)this.getSplitterLength());
            tooltipComponents.addAll(components);
            return;
        }
        tooltipComponents.add((Component)Component.literal((String)"\u00a78\u2022 ").append((Component)Component.translatable((String)"tooltip.ultimine_addition.pen.ink_chamber", (Object[])new Object[]{this.getData(stack).getCapacity()}).withStyle(ChatFormatting.GRAY)));
    }
}

