/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.common.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.handler.codec.CodecException;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.ixdarklord.coolcatlib.api.item.ComponentItem;
import net.ixdarklord.coolcatlib.api.util.ChatFormattingUtils;
import net.ixdarklord.coolcatlib.api.util.CodecUtils;
import net.ixdarklord.coolcatlib.api.util.ComponentHelper;
import net.ixdarklord.ultimine_addition.api.CustomMSCApi;
import net.ixdarklord.ultimine_addition.client.gui.screens.SkillsRecordScreen;
import net.ixdarklord.ultimine_addition.client.handler.ItemRendererHandler;
import net.ixdarklord.ultimine_addition.client.renderer.item.IItemRenderer;
import net.ixdarklord.ultimine_addition.client.renderer.item.UAItemRenderer;
import net.ixdarklord.ultimine_addition.common.data.item.MiningSkillCardData;
import net.ixdarklord.ultimine_addition.common.item.DataAbstractItem;
import net.ixdarklord.ultimine_addition.common.menu.SkillsRecordMenu;
import net.ixdarklord.ultimine_addition.core.FTBUltimineAddition;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class MiningSkillCardItem
extends DataAbstractItem<MiningSkillCardData>
implements IItemRenderer {
    private final Type type;

    public MiningSkillCardItem(Type type, Item.Properties properties) {
        super(properties, ComponentItem.ComponentType.CRAFTING);
        this.type = type;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, Player player, @NotNull InteractionHand usedHand) {
        ItemStack stack = player.getItemInHand(usedHand);
        return InteractionResultHolder.pass((Object)stack);
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slotID, boolean isSelected) {
        if (this.isLegacyMode() || level.isClientSide() || this.type == Type.EMPTY) {
            return;
        }
        if (entity instanceof ServerPlayer && !stack.has(MiningSkillCardData.DATA_COMPONENT) && this.getData(stack).getChallenges().isEmpty()) {
            this.getData(stack).initChallenges().saveData(stack);
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        SkillsRecordScreen screen;
        Screen screen2;
        super.appendHoverText(stack, context, tooltipComponents, isAdvanced);
        if (!(Minecraft.getInstance().screen instanceof SkillsRecordScreen) && this.isShiftButtonNotPressed(tooltipComponents)) {
            return;
        }
        if (this.getType() == Type.EMPTY) {
            MutableComponent component = Component.translatable((String)"tooltip.ultimine_addition.skill_card.info.empty").withStyle(ChatFormatting.GRAY);
            List components = ComponentHelper.splitComponent((Component)component, (int)this.getSplitterLength());
            tooltipComponents.addAll(components);
            return;
        }
        MutableComponent component = Component.translatable((String)"tooltip.ultimine_addition.skill_card.tier", (Object[])new Object[]{!stack.has(MiningSkillCardData.DATA_COMPONENT) ? Component.literal((String)"\u00a7kNawaf") : this.getData(stack).getTier().getDisplayName()});
        tooltipComponents.add((Component)Component.literal((String)"\u2022 ").withStyle(ChatFormatting.DARK_GRAY).append((Component)component.withStyle(ChatFormatting.GRAY)));
        MiningSkillCardData data = (MiningSkillCardData)stack.get(MiningSkillCardData.DATA_COMPONENT);
        if (this.type != Type.EMPTY && data != null && !data.isCreativeItem() && data.getTier() != Tier.Unlearned && data.getTier() != Tier.Mastered) {
            ChatFormatting[] formatting = ChatFormattingUtils.get3LevelChatFormatting((int)data.getPotionPoints(), (int)data.getMaxPotionPoints());
            component = Component.translatable((String)"tooltip.ultimine_addition.skill_card.potion_point", (Object[])new Object[]{Component.literal((String)String.valueOf(data.getPotionPoints())).withStyle(formatting)});
            tooltipComponents.add((Component)Component.literal((String)"\u2022 ").withStyle(ChatFormatting.DARK_GRAY).append((Component)component.withStyle(ChatFormatting.GRAY)));
        }
        if ((screen2 = Minecraft.getInstance().screen) instanceof SkillsRecordScreen && ((SkillsRecordMenu)(screen = (SkillsRecordScreen)screen2).getMenu()).getCardSlots().stream().anyMatch(slot -> slot.getItem().equals(stack))) {
            return;
        }
        if (data == null || data.getTier() != Tier.Mastered) {
            component = Component.translatable((String)"tooltip.ultimine_addition.skill_card.info").withStyle(ChatFormatting.WHITE);
            List components = ComponentHelper.splitComponent((Component)component, (int)this.getSplitterLength());
            tooltipComponents.addAll(components);
        }
    }

    public boolean isBarVisible(ItemStack itemStack) {
        MiningSkillCardData data = this.getData(itemStack);
        if (!itemStack.has(MiningSkillCardData.DATA_COMPONENT) || this.type == Type.EMPTY || data.isCreativeItem() || data.getTier() == Tier.Unlearned || data.getTier() == Tier.Mastered) {
            return false;
        }
        return !data.isPotionPointsFull();
    }

    public int getBarWidth(ItemStack itemStack) {
        MiningSkillCardData data = this.getData(itemStack);
        return Math.round((float)data.getPotionPoints() / (float)data.getMaxPotionPoints() * 13.0f);
    }

    public int getBarColor(ItemStack itemStack) {
        return Mth.hsvToRgb((float)(Math.max(0.0f, (float)this.getBarWidth(itemStack) / 13.0f) / 3.0f), (float)1.0f, (float)1.0f);
    }

    @Override
    public UAItemRenderer createItemRenderer() {
        return ItemRendererHandler.MiningSkillCardRenderer();
    }

    @Override
    public MiningSkillCardData getData(ItemStack stack) {
        return MiningSkillCardData.loadData(stack);
    }

    public Type getType() {
        return this.type;
    }

    public static boolean isTierEqual(ItemStack stack, Tier tier) {
        return MiningSkillCardData.loadData(stack).getTier() == tier;
    }

    public static class Type {
        public static final Type EMPTY = new Type(true, "empty", List.of(), Items.BARRIER);
        public static final Type PICKAXE = new Type(true, "pickaxe", List.of(), Items.NETHERITE_PICKAXE);
        public static final Type AXE = new Type(true, "axe", List.of(), Items.NETHERITE_AXE);
        public static final Type SHOVEL = new Type(true, "shovel", List.of(), Items.NETHERITE_SHOVEL);
        public static final Type HOE = new Type(true, "hoe", List.of(), Items.NETHERITE_HOE);
        public static List<Type> TYPES = new ArrayList<Type>();
        private final boolean active;
        private final String id;
        private final List<String> requiredTools;
        private final Item defaultDisplayItem;
        private final Color potionColor;
        public static final Codec<Type> CODEC = Codec.STRING.comapFlatMap(s -> {
            try {
                return DataResult.success((Object)Type.fromString(s));
            }
            catch (CodecException e) {
                return DataResult.error(() -> s + " is not present.");
            }
        }, Type::getId);
        public static final Codec<Type> CARD_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("active").forGetter(Type::isActive), (App)Codec.STRING.fieldOf("card_id").forGetter(Type::getId), (App)Codec.STRING.listOf().fieldOf("required_tools").forGetter(Type::getRequiredTools), (App)CodecUtils.COLOR_CODEC.optionalFieldOf("potion_color", (Object)Color.WHITE).forGetter(Type::getPotionColor), (App)CodecUtils.ITEM_CODEC.optionalFieldOf("default_display_item", (Object)Items.BARRIER).forGetter(Type::getDefaultDisplayItem)).apply((Applicative)instance, Type::new));

        public Type(boolean active, String id, List<String> requiredTools) {
            this(active, id, requiredTools, Color.WHITE, Items.BARRIER);
        }

        public Type(boolean active, String id, List<String> requiredTools, Item defaultDisplayItem) {
            this(active, id, requiredTools, Color.WHITE, defaultDisplayItem);
        }

        public Type(boolean active, String id, List<String> requiredTools, Color potionColor, Item defaultDisplayItem) {
            this.active = active;
            this.id = this.validateId(id);
            this.requiredTools = requiredTools;
            this.potionColor = potionColor;
            this.defaultDisplayItem = defaultDisplayItem;
        }

        private String validateId(String input) {
            String pattern = "^[a-z0-9_.-]+$";
            if (!input.matches(pattern)) {
                throw new IllegalArgumentException("Invalid Custom Card Id format! Non [a-z0-9_.-] character exists. (\"%s\")".formatted(input));
            }
            return input;
        }

        public static void refreshTypes() {
            TYPES = new ArrayList<Type>(List.of(EMPTY, PICKAXE, AXE, SHOVEL, HOE));
            TYPES.addAll(CustomMSCApi.CUSTOM_TYPES);
        }

        public boolean isActive() {
            return this.active;
        }

        public String getId() {
            return this.id;
        }

        public ResourceLocation getRegistryId() {
            return FTBUltimineAddition.rl("mining_skill_card_%s".formatted(this.id));
        }

        public List<String> getRequiredTools() {
            return this.requiredTools;
        }

        public Color getPotionColor() {
            return this.potionColor;
        }

        public Item getDefaultDisplayItem() {
            return this.defaultDisplayItem;
        }

        public static Type fromString(String input) {
            for (Type type : TYPES) {
                if (!type.getId().equalsIgnoreCase(input) || input.equalsIgnoreCase(EMPTY.getId())) continue;
                return type;
            }
            throw new IllegalArgumentException("No type with the specified name");
        }

        public boolean isCustomType() {
            return TYPES.stream().filter(t -> !t.equals(EMPTY) && !t.equals(PICKAXE) && !t.equals(AXE) && !t.equals(SHOVEL) && !t.equals(HOE)).toList().contains(this);
        }

        public List<Item> utilizeRequiredTools() {
            ArrayList<Item> list = new ArrayList<Item>();
            if (this.requiredTools == null) {
                return list;
            }
            for (String value : this.requiredTools) {
                if (value.startsWith("#")) {
                    ArrayList items = new ArrayList();
                    BuiltInRegistries.ITEM.getTag(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)value.replaceAll("#", "")))).ifPresent(holders -> items.addAll(holders.stream().map(Holder::value).toList()));
                    if (items.isEmpty()) continue;
                    list.addAll(items);
                    continue;
                }
                Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)value));
                if (item == Items.AIR) continue;
                list.add(item);
            }
            return list;
        }
    }

    public static enum Tier {
        Unlearned(0),
        Novice(1),
        Apprentice(2),
        Adept(3),
        Mastered(4);

        private final int tier;
        public static final Codec<Tier> CODEC;
        public static StreamCodec<FriendlyByteBuf, Tier> STREAM_CODEC;

        private Tier(int tier) {
            this.tier = tier;
        }

        public boolean isEligible(Tier tier) {
            return tier.getValue() >= this.tier;
        }

        public int getValue() {
            return this.tier;
        }

        public MutableComponent getDisplayName() {
            return switch (this.tier) {
                case 1 -> Component.translatable((String)this.descriptionId()).withStyle(ChatFormatting.GREEN);
                case 2 -> Component.translatable((String)this.descriptionId()).withStyle(ChatFormatting.AQUA);
                case 3 -> Component.translatable((String)this.descriptionId()).withStyle(ChatFormatting.LIGHT_PURPLE);
                case 4 -> Component.translatable((String)this.descriptionId()).withStyle(ChatFormatting.GOLD);
                default -> Component.translatable((String)this.descriptionId());
            };
        }

        private String descriptionId() {
            return String.format("tooltip.ultimine_addition.skill_card.tier.%s", this.name().toLowerCase());
        }

        public Tier next() {
            int nextIndex = (this.ordinal() + 1) % Tier.values().length;
            return Tier.values()[nextIndex];
        }

        public Tier previous() {
            int prevIndex = (this.ordinal() - 1 + Tier.values().length) % Tier.values().length;
            return Tier.values()[prevIndex];
        }

        public static String[] getNames() {
            String[] enumNames = new String[Tier.values().length];
            for (int i = 0; i < enumNames.length; ++i) {
                enumNames[i] = Tier.values()[i].name().toLowerCase();
            }
            return enumNames;
        }

        public static Tier fromString(String input) {
            for (Tier enumValue : Tier.values()) {
                if (!enumValue.name().equalsIgnoreCase(input)) continue;
                return enumValue;
            }
            return null;
        }

        public static Tier fromInt(int input) {
            for (Tier enumValue : Tier.values()) {
                if (enumValue.getValue() != input) continue;
                return enumValue;
            }
            throw new IllegalArgumentException("There is no tier enum with value: " + input);
        }

        static {
            CODEC = Codec.INT.comapFlatMap(i -> {
                try {
                    return DataResult.success((Object)((Object)Tier.fromInt(i)));
                }
                catch (EnumConstantNotPresentException e) {
                    return DataResult.success((Object)((Object)Unlearned));
                }
            }, Tier::getValue);
            STREAM_CODEC = new StreamCodec<FriendlyByteBuf, Tier>(){

                @NotNull
                public Tier decode(FriendlyByteBuf buf) {
                    return (Tier)buf.readEnum(Tier.class);
                }

                public void encode(FriendlyByteBuf buf, Tier tier) {
                    buf.writeEnum((Enum)tier);
                }
            };
        }
    }
}

