/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.common.item;

import java.util.List;
import java.util.Optional;
import net.ixdarklord.coolcatlib.api.item.ComponentItem;
import net.ixdarklord.coolcatlib.api.util.ComponentHelper;
import net.ixdarklord.ultimine_addition.common.advancement.UltimineObtainTrigger;
import net.ixdarklord.ultimine_addition.common.data.item.MinerCertificateData;
import net.ixdarklord.ultimine_addition.common.item.DataAbstractItem;
import net.ixdarklord.ultimine_addition.core.Registration;
import net.ixdarklord.ultimine_addition.core.ServicePlatform;
import net.ixdarklord.ultimine_addition.util.ItemUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class MinerCertificateItem
extends DataAbstractItem<MinerCertificateData> {
    public MinerCertificateItem(Item.Properties properties) {
        super(properties, ComponentItem.ComponentType.ABILITY);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, Player player, @NotNull InteractionHand usedHand) {
        ItemStack stack = player.getItemInHand(usedHand);
        if (level.isClientSide()) {
            if (ServicePlatform.get().players().isPlayerUltimineCapable(player) && MinerCertificateItem.isAccomplished(stack)) {
                level.playLocalSound((Entity)player, (SoundEvent)SoundEvents.NOTE_BLOCK_BASS.value(), SoundSource.PLAYERS, 1.0f, 0.5f);
                this.getData(stack).sendClientMessage(player);
            }
            return InteractionResultHolder.pass((Object)stack);
        }
        if (!ServicePlatform.get().players().isPlayerUltimineCapable(player) && MinerCertificateItem.isAccomplished(stack)) {
            this.playParticleAndSound((Entity)player);
            ((UltimineObtainTrigger)((Object)Registration.ULTIMINE_OBTAIN_TRIGGER.get())).trigger((ServerPlayer)player);
            this.getData(stack).playCelebration(true).sendClientMessage(player).sendToClient(ItemUtils.getSlotIndex(usedHand), (ServerPlayer)player).saveData(stack);
            ServicePlatform.get().players().setPlayerUltimineCapability(player, true);
            if (!player.isCreative()) {
                stack.shrink(1);
            }
            return InteractionResultHolder.success((Object)stack);
        }
        return InteractionResultHolder.fail((Object)stack);
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slotIndex, boolean isSelected) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            this.getData(stack).tick(slotIndex, player);
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        Optional<MinerCertificateData.Legacy> legacy = this.getData(stack).getLegacy();
        legacy.ifPresent(value -> value.createInfoComponent(tooltipComponents, false));
        if (this.isShiftButtonNotPressed(tooltipComponents)) {
            return;
        }
        if (legacy.isPresent()) {
            legacy.get().createInfoComponent(tooltipComponents, true);
            return;
        }
        MutableComponent component = Component.translatable((String)"tooltip.ultimine_addition.certificate.info").withStyle(ChatFormatting.GRAY);
        List components = ComponentHelper.splitComponent((Component)component, (int)this.getSplitterLength());
        tooltipComponents.addAll(components);
    }

    public boolean isFoil(@NotNull ItemStack stack) {
        return MinerCertificateItem.isAccomplished(stack);
    }

    public static boolean isAccomplished(ItemStack stack) {
        MinerCertificateItem item;
        Item item2 = stack.getItem();
        return item2 instanceof MinerCertificateItem && (item = (MinerCertificateItem)item2).getData(stack).isAccomplished();
    }

    public void playParticleAndSound(Entity entity) {
        int PARTICLE_COUNT = 80;
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            serverPlayer.serverLevel().sendParticles((ParticleOptions)((SimpleParticleType)Registration.CELEBRATE_PARTICLE.get()), serverPlayer.getX(), serverPlayer.getY() + 0.15, serverPlayer.getZ(), 80, 1.0, 1.0, 1.0, 0.02);
            serverPlayer.serverLevel().sendParticles((ParticleOptions)ParticleTypes.TOTEM_OF_UNDYING, serverPlayer.getX(), serverPlayer.getY() + 0.15, serverPlayer.getZ(), 80, 1.0, 1.0, 1.0, 0.02);
            serverPlayer.serverLevel().playSound(null, serverPlayer.getX(), serverPlayer.getY(), serverPlayer.getZ(), SoundEvents.TOTEM_USE, serverPlayer.getSoundSource(), 0.25f, 2.5f);
            serverPlayer.serverLevel().playSound(null, serverPlayer.getX(), serverPlayer.getY(), serverPlayer.getZ(), (SoundEvent)SoundEvents.NOTE_BLOCK_CHIME.value(), serverPlayer.getSoundSource(), 1.0f, 1.0f);
        }
    }

    @Override
    public MinerCertificateData getData(ItemStack stack) {
        return MinerCertificateData.loadData(stack);
    }
}

