/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.common.data.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.utils.Env;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.ixdarklord.ultimine_addition.client.handler.ClientHandler;
import net.ixdarklord.ultimine_addition.common.data.DataHandler;
import net.ixdarklord.ultimine_addition.common.data.challenge.ChallengesData;
import net.ixdarklord.ultimine_addition.common.data.challenge.ChallengesManager;
import net.ixdarklord.ultimine_addition.common.data.challenge.IneligibleBlocksSavedData;
import net.ixdarklord.ultimine_addition.common.data.item.MiningSkillCardData;
import net.ixdarklord.ultimine_addition.common.item.PenItem;
import net.ixdarklord.ultimine_addition.common.item.SkillsRecordItem;
import net.ixdarklord.ultimine_addition.common.menu.SkillsRecordMenu;
import net.ixdarklord.ultimine_addition.common.tag.ModBlockTags;
import net.ixdarklord.ultimine_addition.config.ConfigHandler;
import net.ixdarklord.ultimine_addition.core.FTBUltimineAddition;
import net.ixdarklord.ultimine_addition.network.PayloadHandler;
import net.ixdarklord.ultimine_addition.network.payloads.SkillsRecordPayload;
import net.ixdarklord.ultimine_addition.util.ContainerUtils;
import net.ixdarklord.ultimine_addition.util.ItemUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SkillsRecordData
extends DataHandler<SkillsRecordData, ItemStack> {
    public static final Codec<SkillsRecordData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)UUIDUtil.CODEC.optionalFieldOf("UUID", (Object)UUID.randomUUID()).forGetter(SkillsRecordData::getUUID), (App)ItemStack.OPTIONAL_CODEC.listOf().xmap(itemStacks -> new SimpleContainer((ItemStack[])itemStacks.toArray(ItemStack[]::new)), SimpleContainer::getItems).fieldOf("Contents").forGetter(SkillsRecordData::getContainer), (App)Codec.INT.optionalFieldOf("SelectedCard", (Object)-1).forGetter(SkillsRecordData::getSelectedCard), (App)Codec.BOOL.optionalFieldOf("ConsumeMode", (Object)false).forGetter(SkillsRecordData::isConsumeMode)).apply((Applicative)instance, SkillsRecordData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, SkillsRecordData> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, SkillsRecordData>(){

        @NotNull
        public SkillsRecordData decode(RegistryFriendlyByteBuf buf) {
            return new SkillsRecordData(buf.readUUID(), new SimpleContainer((ItemStack[])((List)ItemStack.OPTIONAL_LIST_STREAM_CODEC.decode((Object)buf)).toArray(ItemStack[]::new)), buf.readInt(), buf.readBoolean()).decodePinnedChallenges(buf);
        }

        public void encode(RegistryFriendlyByteBuf buf, SkillsRecordData data) {
            buf.writeUUID(data.uuid);
            ItemStack.OPTIONAL_LIST_STREAM_CODEC.encode((Object)buf, (Object)data.getContainer().getItems());
            buf.writeInt(data.selectedCard);
            buf.writeBoolean(data.consumeMode);
            data.encodePinnedChallenges(buf);
        }
    };
    public static final DataComponentType<SkillsRecordData> DATA_COMPONENT = DataComponentType.builder().persistent(CODEC).networkSynchronized(STREAM_CODEC).build();
    private final UUID uuid;
    private SimpleContainer container;
    private int selectedCard;
    private boolean consumeMode;
    private final Map<Integer, List<ResourceLocation>> pinnedChallenges = new TreeMap<Integer, List<ResourceLocation>>();

    private SkillsRecordData() {
        this(UUID.randomUUID(), new SimpleContainer(6), -1, false);
    }

    private SkillsRecordData(UUID uuid, SimpleContainer container, int selectedCard, boolean consumeMode) {
        this.uuid = uuid;
        this.container = container;
        this.selectedCard = selectedCard;
        this.consumeMode = consumeMode;
    }

    public static SkillsRecordData create() {
        return new SkillsRecordData();
    }

    public static SkillsRecordData loadData(ItemStack stack) {
        return (SkillsRecordData)((SkillsRecordData)stack.getOrDefault(DATA_COMPONENT, (Object)SkillsRecordData.create())).setDataHolder(stack);
    }

    @Override
    public void saveData(ItemStack stack) {
        stack.set(DATA_COMPONENT, (Object)this);
        super.saveData(stack);
    }

    public Pair<Boolean, Boolean> initTaskValidator(BlockState state, BlockPos pos, ServerPlayer player, ChallengesData.Type challengeType) {
        boolean b1 = false;
        boolean b2 = false;
        for (int i = 0; i < this.getCardSlots().size(); ++i) {
            ItemStack stack = (ItemStack)this.getCardSlots().get(i);
            if (stack == ItemStack.EMPTY) continue;
            Pair<Boolean, Boolean> pair = this.validateTask(stack, state, pos, player, challengeType);
            if (((Boolean)pair.getFirst()).booleanValue()) {
                b1 = true;
            }
            if (!((Boolean)pair.getSecond()).booleanValue()) continue;
            b2 = true;
        }
        return Pair.of((Object)b1, (Object)b2);
    }

    private Pair<Boolean, Boolean> validateTask(ItemStack stack, BlockState state, BlockPos pos, ServerPlayer player, ChallengesData.Type challengeType) {
        AtomicReference<Pair> isConsumed = new AtomicReference<Pair>(Pair.of((Object)false, (Object)false));
        try {
            AtomicInteger i = new AtomicInteger();
            MiningSkillCardData cardData = MiningSkillCardData.loadData(stack);
            cardData.getChallenges().forEach(identifier -> {
                if (i.get() == 0) {
                    boolean isBlockPlacedByEntity;
                    IneligibleBlocksSavedData savedData = IneligibleBlocksSavedData.getOrCreate((ServerLevel)player.level());
                    ChallengesData challengeData = ChallengesManager.INSTANCE.getAllChallenges().get(identifier.getId());
                    List<Block> blocks = ChallengesManager.INSTANCE.utilizeTargetedBlocks(challengeData);
                    int inkChamber = this.getPenSlot().getItem() instanceof PenItem ? ((PenItem)((ItemStack)this.getAllSlots().get(4)).getItem()).getData((ItemStack)this.getAllSlots().get(4)).getCapacity() : 0;
                    boolean hasCorrectGamemode = !player.isCreative() && !player.isSpectator();
                    boolean isMissingRequiredItems = hasCorrectGamemode && (((ItemStack)this.getAllSlots().get(4)).isEmpty() || ((ItemStack)this.getAllSlots().get(5)).isEmpty());
                    boolean notEnoughInk = hasCorrectGamemode && inkChamber == 0;
                    boolean isChallengeAccomplished = cardData.isChallengeAccomplished(identifier.getId());
                    boolean isCorrectAction = challengeData.getChallengeType().equals((Object)challengeType) || challengeData.getChallengeType().equals((Object)challengeType.getConsumeVersion());
                    boolean isValidBlock = blocks.contains(state.getBlock());
                    boolean isCorrectTool = !hasCorrectGamemode || ChallengesManager.INSTANCE.isCorrectTool((Player)player, challengeData);
                    boolean bl = isBlockPlacedByEntity = (Boolean)ConfigHandler.SERVER.IS_PLACED_BY_ENTITY_CONDITION.get() != false && hasCorrectGamemode && !state.is(ModBlockTags.DENY_IS_PLACED_BY_ENTITY) && savedData.isBlockPlacedByEntity(pos);
                    if (((Boolean)ConfigHandler.SERVER.CHALLENGE_ACTIONS_LOGGER.get()).booleanValue()) {
                        FTBUltimineAddition.LOGGER.debug("/----------[Challenge Tracker]----------/");
                        FTBUltimineAddition.LOGGER.debug("Challenge Id: {}", (Object)identifier.getId());
                        FTBUltimineAddition.LOGGER.debug("hasCorrectGamemode: {}", (Object)hasCorrectGamemode);
                        FTBUltimineAddition.LOGGER.debug("isMissingRequiredItems: {}", (Object)isMissingRequiredItems);
                        FTBUltimineAddition.LOGGER.debug("notEnoughInk: {}", (Object)notEnoughInk);
                        FTBUltimineAddition.LOGGER.debug("isChallengeAccomplished: {}", (Object)isChallengeAccomplished);
                        FTBUltimineAddition.LOGGER.debug("isCorrectAction: {}", (Object)isCorrectAction);
                        FTBUltimineAddition.LOGGER.debug("isValidBlock: {}", (Object)isValidBlock);
                        FTBUltimineAddition.LOGGER.debug("isCorrectTool: {}", (Object)isCorrectTool);
                        FTBUltimineAddition.LOGGER.debug("isBlockPlacedByEntity: {}", (Object)isBlockPlacedByEntity);
                        FTBUltimineAddition.LOGGER.debug("/----------------------------------------/");
                    }
                    if (!isMissingRequiredItems && !notEnoughInk && !isChallengeAccomplished && isCorrectAction && isValidBlock && isCorrectTool && isBlockPlacedByEntity) {
                        savedData.getChunkEntries().forEach((chunkPos, chunkEntries) -> {
                            List<IneligibleBlocksSavedData.BlockEntry> list = chunkEntries.stream().filter(blockEntry -> !blockEntry.placedBlocks().stream().filter(blockInfo -> blockInfo.pos().equals((Object)pos)).toList().isEmpty()).toList();
                            if (!list.isEmpty()) {
                                IneligibleBlocksSavedData.BlockEntry blockEntry2 = list.getFirst();
                                MutableComponent component = Component.literal((String)"[").append((Component)SkillsRecordItem.TITLE.copy().withStyle(ChatFormatting.YELLOW)).append("] ").withStyle(ChatFormatting.GRAY);
                                MutableComponent info = Component.translatable((String)"info.ultimine_addition.placed_by_entity", (Object[])new Object[]{Component.translatable((String)"entity.%s.%s".formatted(blockEntry2.placerData().entityId().getNamespace(), blockEntry2.placerData().entityId().getPath()))}).withStyle(ChatFormatting.RED);
                                player.displayClientMessage((Component)component.append((Component)info), true);
                            }
                        });
                    }
                    if (!isMissingRequiredItems && !notEnoughInk && !isChallengeAccomplished && isCorrectAction && isValidBlock && isCorrectTool && !isBlockPlacedByEntity) {
                        if (challengeData.getChallengeType().isConsuming()) {
                            if (this.consumeMode) {
                                cardData.addAmount(identifier.getId(), 1).saveData(stack);
                                if (hasCorrectGamemode) {
                                    this.consumeContents();
                                }
                                isConsumed.set(Pair.of((Object)true, (Object)true));
                                player.level().removeBlock(pos, false);
                            }
                        } else {
                            cardData.addAmount(identifier.getId(), 1).saveData(stack);
                            if (hasCorrectGamemode) {
                                this.consumeContents();
                            }
                            isConsumed.set(Pair.of((Object)true, (Object)false));
                        }
                        i.getAndIncrement();
                    }
                }
            });
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        return isConsumed.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public SkillsRecordData togglePinned(int slot, ResourceLocation challengeId, SkillsRecordMenu menu) {
        ItemStack itemStack;
        MiningSkillCardData data;
        Optional<MiningSkillCardData.ChallengeHolder> challengeData;
        if (this.pinnedChallenges.containsKey(slot)) {
            if (!this.pinnedChallenges.get(slot).contains(challengeId)) {
                this.pinnedChallenges.get(slot).add(challengeId);
            }
        } else {
            this.pinnedChallenges.put(slot, new ArrayList<ResourceLocation>(List.of(challengeId)));
        }
        if ((challengeData = (data = MiningSkillCardData.loadData(itemStack = (ItemStack)this.getCardSlots().get(slot))).getChallenge(challengeId)).isPresent()) {
            challengeData.get().togglePinned();
            data.saveData(itemStack);
        }
        return this.sendToServer(menu.interactionHand);
    }

    private void consumeContents() {
        ItemStack pen = this.getPenSlot();
        ItemStack paper = this.getPaperSlot();
        Item item = pen.getItem();
        if (item instanceof PenItem) {
            PenItem item2 = (PenItem)item;
            item2.getData(pen).removeAmount(1).saveData(pen);
        }
        if (paper.getItem() == Items.PAPER) {
            boolean chance = ThreadLocalRandom.current().nextDouble() < (Double)ConfigHandler.SERVER.PAPER_CONSUMPTION_RATE.get();
            paper.shrink(chance ? 1 : 0);
        }
    }

    public NonNullList<ItemStack> getCardSlots() {
        NonNullList items = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
        for (int i = 0; i < items.size(); ++i) {
            items.set(i, (Object)this.container.getItem(i));
        }
        return items;
    }

    public NonNullList<ItemStack> getAllSlots() {
        return this.container.getItems();
    }

    public ItemStack getPenSlot() {
        return (ItemStack)this.getAllSlots().get(4);
    }

    private ItemStack getPaperSlot() {
        return (ItemStack)this.getAllSlots().get(5);
    }

    public boolean isConsumeMode() {
        return this.consumeMode;
    }

    public int getSelectedCard() {
        return this.selectedCard;
    }

    public SimpleContainer getContainer() {
        return this.container;
    }

    @Nullable
    public UUID getUUID() {
        return this.uuid;
    }

    public SkillsRecordData insertContainer(Container container) {
        if (container.getContainerSize() != 6) {
            throw new IllegalArgumentException("You have inserted a container of size other than %s! (Inserted Container Size: %s)".formatted(6, container.getContainerSize()));
        }
        NonNullList stacks = NonNullList.withSize((int)6, (Object)ItemStack.EMPTY);
        for (int i = 0; i < container.getContainerSize(); ++i) {
            stacks.set(i, (Object)container.getItem(i));
        }
        this.container = new SimpleContainer((ItemStack[])stacks.toArray(ItemStack[]::new));
        return this;
    }

    public SkillsRecordData setSelectedCard(int selectedSlot) {
        this.selectedCard = selectedSlot;
        return this;
    }

    public SkillsRecordData toggleConsumeMode() {
        this.consumeMode ^= true;
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void updateOffhand(InteractionHand interactionHand) {
        if (interactionHand == InteractionHand.OFF_HAND) {
            ItemStack itemStack1 = ((ItemStack)this.get()).copy();
            this.saveData(itemStack1);
            ClientHandler.getPlayer().getInventory().offhand.set(0, (Object)itemStack1);
        }
    }

    public SkillsRecordData sendToClient(ServerPlayer player, @Nullable InteractionHand hand) {
        return this.sendToClient(player, ItemUtils.getSlotIndex(hand));
    }

    public SkillsRecordData sendToClient(ServerPlayer player, int slotIndex) {
        PayloadHandler.sendToPlayer(new SkillsRecordPayload.SyncData(Env.CLIENT, slotIndex, this), player);
        return this;
    }

    public SkillsRecordData sendToServer(@Nullable InteractionHand hand) {
        this.updateOffhand(hand);
        return this.sendToServer(ItemUtils.getSlotIndex(hand));
    }

    public SkillsRecordData sendToServer(int slotIndex) {
        PayloadHandler.sendToServer(new SkillsRecordPayload.SyncData(Env.SERVER, slotIndex, this));
        return this;
    }

    public SkillsRecordData syncData(ServerPlayer player) {
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof SkillsRecordMenu) {
            SkillsRecordMenu skillsRecordMenu = (SkillsRecordMenu)abstractContainerMenu;
            this.pinnedChallenges.forEach((slot, challengeList) -> {
                ItemStack cardStack = ((Slot)skillsRecordMenu.getCardSlots().get(slot.intValue())).getItem();
                MiningSkillCardData cardData = MiningSkillCardData.loadData(cardStack);
                challengeList.forEach(location -> {
                    Optional<MiningSkillCardData.ChallengeHolder> challengeData = cardData.getChallenge((ResourceLocation)location);
                    if (challengeData.isPresent()) {
                        challengeData.get().togglePinned();
                        cardData.saveData(cardStack);
                    }
                });
            });
        }
        return this;
    }

    private void encodePinnedChallenges(RegistryFriendlyByteBuf buf) {
        buf.writeMap(this.pinnedChallenges, FriendlyByteBuf::writeInt, (buffer, locationList) -> buf.writeCollection((Collection)locationList, FriendlyByteBuf::writeResourceLocation));
    }

    private SkillsRecordData decodePinnedChallenges(RegistryFriendlyByteBuf buf) {
        this.pinnedChallenges.putAll(buf.readMap(FriendlyByteBuf::readInt, buffer -> buf.readList(FriendlyByteBuf::readResourceLocation)));
        return this;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SkillsRecordData)) {
            return false;
        }
        SkillsRecordData that = (SkillsRecordData)o;
        return Objects.equals(this.uuid, that.uuid) && ContainerUtils.equals((Container)this.container, (Container)that.container) && this.selectedCard == that.selectedCard && this.consumeMode == that.consumeMode && Objects.equals(this.pinnedChallenges, that.pinnedChallenges);
    }

    public int hashCode() {
        return Objects.hash(this.uuid, this.selectedCard, this.consumeMode, this.pinnedChallenges) + ContainerUtils.hashCode((Container)this.container);
    }
}

