/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.common.data.item;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.platform.Platform;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.ixdarklord.ultimine_addition.client.gui.toasts.ChallengesToast;
import net.ixdarklord.ultimine_addition.common.data.DataHandler;
import net.ixdarklord.ultimine_addition.common.data.challenge.ChallengesManager;
import net.ixdarklord.ultimine_addition.common.item.MiningSkillCardItem;
import net.ixdarklord.ultimine_addition.config.ConfigHandler;
import net.ixdarklord.ultimine_addition.core.FTBUltimineAddition;
import net.ixdarklord.ultimine_addition.network.PayloadHandler;
import net.ixdarklord.ultimine_addition.network.payloads.MiningSkillCardPayload;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class MiningSkillCardData
extends DataHandler<MiningSkillCardData, ItemStack> {
    public static final Codec<MiningSkillCardData> CODEC = RecordCodecBuilder.create((T instance) -> instance.group((App)UUIDUtil.CODEC.optionalFieldOf("UUID", (Object)UUID.randomUUID()).forGetter(MiningSkillCardData::getUUID), (App)MiningSkillCardItem.Tier.CODEC.fieldOf("Tier").forGetter(MiningSkillCardData::getTier), (App)ItemStack.SIMPLE_ITEM_CODEC.fieldOf("DisplayItem").forGetter(MiningSkillCardData::getDisplayItem), (App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("PotionPoints", (Object)0).forGetter(MiningSkillCardData::getPotionPoints), (App)ChallengeHolder.CODEC.listOf().optionalFieldOf("Challenges", (Object)Lists.newArrayList()).forGetter(MiningSkillCardData::getChallenges)).apply((Applicative)instance, MiningSkillCardData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, MiningSkillCardData> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, MiningSkillCardData::getUUID, MiningSkillCardItem.Tier.STREAM_CODEC, MiningSkillCardData::getTier, (StreamCodec)ItemStack.STREAM_CODEC, MiningSkillCardData::getDisplayItem, (StreamCodec)ByteBufCodecs.INT, MiningSkillCardData::getPotionPoints, (StreamCodec)ChallengeHolder.STREAM_CODEC.apply(ByteBufCodecs.list()), MiningSkillCardData::getChallenges, (StreamCodec)ChallengeHolder.STREAM_CODEC.apply(ByteBufCodecs.list()), data -> data.finishedChallenges, MiningSkillCardData::new);
    public static final DataComponentType<MiningSkillCardData> DATA_COMPONENT = DataComponentType.builder().persistent(CODEC).networkSynchronized(STREAM_CODEC).build();
    @NotNull
    private final UUID uuid;
    private MiningSkillCardItem.Tier tier;
    private ItemStack displayItem;
    private int potionPoints;
    private final List<ChallengeHolder> challenges;
    private final List<ChallengeHolder> finishedChallenges;

    private MiningSkillCardData(@NotNull UUID uuid, MiningSkillCardItem.Tier tier, ItemStack displayItem, int potionPoints, List<ChallengeHolder> challenges) {
        this(uuid, tier, displayItem, potionPoints, challenges, Lists.newArrayList());
    }

    private MiningSkillCardData(@NotNull UUID uuid, MiningSkillCardItem.Tier tier, ItemStack displayItem, int potionPoints, List<ChallengeHolder> challenges, List<ChallengeHolder> finishedChallenges) {
        this.uuid = uuid;
        this.tier = tier;
        this.displayItem = displayItem;
        this.potionPoints = potionPoints;
        this.challenges = Lists.newArrayList(challenges);
        this.finishedChallenges = Lists.newArrayList(finishedChallenges);
    }

    public static MiningSkillCardData create(MiningSkillCardItem.Type type) {
        return new MiningSkillCardData(UUID.randomUUID(), MiningSkillCardItem.Tier.Unlearned, type.getDefaultDisplayItem().getDefaultInstance(), 0, Lists.newArrayList());
    }

    public static MiningSkillCardData loadData(ItemStack stack) {
        MiningSkillCardItem.Type type = stack.getItem() instanceof MiningSkillCardItem ? ((MiningSkillCardItem)stack.getItem()).getType() : MiningSkillCardItem.Type.EMPTY;
        return (MiningSkillCardData)((MiningSkillCardData)stack.getOrDefault(DATA_COMPONENT, (Object)MiningSkillCardData.create(type))).setDataHolder(stack);
    }

    @ApiStatus.Internal
    public static ItemStack createForCreativeTab(MiningSkillCardItem cardItem, MiningSkillCardItem.Tier tier) {
        ItemStack card = cardItem.getDefaultInstance();
        MiningSkillCardData data = new MiningSkillCardData(UUID.fromString("00000000-0000-0000-0000-000000000000"), tier, cardItem.getType().getDefaultDisplayItem().getDefaultInstance(), 0, Lists.newArrayList());
        data.saveData(card);
        return card;
    }

    @Override
    public void saveData(ItemStack stack) {
        stack.set(DATA_COMPONENT, (Object)this);
        super.saveData(stack);
    }

    public MiningSkillCardData sendToClient(ServerPlayer player, int slotIndex) {
        PayloadHandler.sendToPlayer(new MiningSkillCardPayload(slotIndex, this), player);
        this.finishedChallenges.clear();
        return this;
    }

    @Override
    public MiningSkillCardData clientUpdate() {
        for (ChallengeHolder finishedChallenge : this.finishedChallenges) {
            ChallengesToast.run(finishedChallenge, (ItemStack)this.dataHolder);
        }
        return this;
    }

    @NotNull
    public UUID getUUID() {
        return this.uuid;
    }

    public MiningSkillCardData initChallenges() {
        if (!(((ItemStack)this.dataHolder).getItem() instanceof MiningSkillCardItem)) {
            FTBUltimineAddition.LOGGER.error("You've tried to initiate challenges on item can't accept it: {}", (Object)((ItemStack)this.dataHolder).getDescriptionId());
            return this;
        }
        if (this.tier == MiningSkillCardItem.Tier.Mastered) {
            this.challenges.clear();
            return this;
        }
        AtomicInteger slotId = new AtomicInteger(1);
        AtomicInteger quantity = new AtomicInteger();
        MiningSkillCardItem.Type type = ((MiningSkillCardItem)((ItemStack)this.dataHolder).getItem()).getType();
        quantity.set(ConfigHandler.SERVER.CARD_CHALLENGES_AMOUNT.getValue(this.tier));
        if (this.tier != MiningSkillCardItem.Tier.Unlearned && this.tier != MiningSkillCardItem.Tier.Mastered) {
            this.resetPotionPoints();
        }
        this.challenges.clear();
        ChallengesManager.INSTANCE.getRandomChallenges(quantity.get(), type, this.tier).forEach((location, data) -> {
            this.challenges.add(new ChallengeHolder((ResourceLocation)location, slotId.get(), data.getRequiredAmount()));
            slotId.getAndIncrement();
        });
        return this;
    }

    public boolean validateChallenges() {
        if (this.tier == MiningSkillCardItem.Tier.Mastered) {
            return false;
        }
        MiningSkillCardItem.Type type = ((MiningSkillCardItem)((ItemStack)this.dataHolder).getItem()).getType();
        if (!this.challenges.isEmpty()) {
            TreeSet removedChallenges = new TreeSet();
            this.challenges.forEach(challengeData -> {
                if (!ChallengesManager.INSTANCE.getAllChallenges().containsKey(challengeData.id)) {
                    removedChallenges.add(challengeData);
                }
            });
            removedChallenges.forEach(challengeData -> {
                AtomicBoolean isDone = new AtomicBoolean(true);
                this.challenges.remove(challengeData);
                do {
                    ChallengesManager.INSTANCE.getRandomChallenges(1, type, this.tier).forEach((location, data) -> {
                        if (this.challenges.stream().filter(challengeData1 -> challengeData1.id.equals(location)).toList().isEmpty()) {
                            this.challenges.add(new ChallengeHolder((ResourceLocation)location, challengeData.order, data.getRequiredAmount()));
                            if (((Boolean)ConfigHandler.SERVER.CHALLENGE_MANAGER_LOGGER.get()).booleanValue() || Platform.isDevelopmentEnvironment()) {
                                FTBUltimineAddition.LOGGER.debug("Changing the invalid challenge! id:\"{}\" to: id:\"{}\"", (Object)challengeData.id, location);
                            }
                            isDone.set(false);
                        }
                    });
                } while (isDone.get());
            });
            return !removedChallenges.isEmpty();
        }
        this.initChallenges();
        return true;
    }

    public void setDisplayItem(ItemStack stack) {
        this.displayItem = stack;
    }

    public MiningSkillCardData addAmount(ResourceLocation challengeId, int value) {
        Optional<ChallengeHolder> challengeData = this.getChallenge(challengeId);
        if (challengeData.isEmpty()) {
            return this;
        }
        int currentAmount = challengeData.get().currentPoints;
        int requiredAmount = challengeData.get().requiredPoints;
        if (currentAmount >= requiredAmount) {
            return this;
        }
        return this.setAmount(challengeId, currentAmount + value);
    }

    public void accomplishChallenge(ResourceLocation challengeId) {
        Optional<ChallengeHolder> challengeData = this.getChallenge(challengeId);
        if (challengeData.isEmpty()) {
            return;
        }
        this.setAmount(challengeId, challengeData.get().requiredPoints);
    }

    public MiningSkillCardData setAmount(ResourceLocation challengeId, int value) {
        Optional<ChallengeHolder> challengeData = this.getChallenge(challengeId);
        if (challengeData.isEmpty()) {
            return this;
        }
        int requiredAmount = challengeData.get().requiredPoints;
        challengeData.get().setCurrentPoints(Math.min(value, requiredAmount));
        if (this.isAllChallengesCompleted()) {
            this.tier = this.tier.next();
            this.initChallenges();
            this.finishedChallenges.add(new ChallengeHolder());
        } else {
            this.checkChallengeAccomplishment(challengeData.get());
        }
        return this;
    }

    private void checkChallengeAccomplishment(ChallengeHolder challengeHolder) {
        if (challengeHolder.currentPoints >= challengeHolder.requiredPoints && !this.finishedChallenges.contains(challengeHolder)) {
            this.finishedChallenges.add(challengeHolder);
        }
    }

    public void setPotionPoints(int value) {
        this.potionPoints = value;
    }

    public MiningSkillCardData consumePotionPoint(int value) {
        this.potionPoints = Math.max(0, this.potionPoints - value);
        return this;
    }

    public void resetPotionPoints() {
        this.setPotionPoints(this.getMaxPotionPoints());
    }

    public MiningSkillCardData setTier(MiningSkillCardItem.Tier tier) {
        this.tier = tier;
        return this;
    }

    public ItemStack getDisplayItem() {
        return this.displayItem;
    }

    public Optional<ChallengeHolder> getChallenge(ResourceLocation challengeId) {
        for (ChallengeHolder challenge : this.challenges) {
            if (!challenge.id.equals((Object)challengeId)) continue;
            return Optional.of(challenge);
        }
        return Optional.empty();
    }

    public boolean isChallengeAccomplished(ResourceLocation challengeId) {
        Optional<ChallengeHolder> challengeData = this.getChallenge(challengeId);
        return challengeData.filter(data -> data.currentPoints >= data.requiredPoints).isPresent();
    }

    private boolean isAllChallengesCompleted() {
        int allCurrentValues = 0;
        int allRequiredValues = 0;
        for (ChallengeHolder challenge : this.challenges) {
            allCurrentValues += challenge.currentPoints;
            allRequiredValues += challenge.requiredPoints;
        }
        return allCurrentValues >= allRequiredValues;
    }

    public List<ChallengeHolder> getChallenges() {
        return this.challenges;
    }

    public MiningSkillCardItem.Tier getTier() {
        return this.tier;
    }

    public boolean isPotionPointsFull() {
        return this.potionPoints >= this.getMaxPotionPoints();
    }

    public int getPotionPoints() {
        return this.potionPoints;
    }

    public int getMaxPotionPoints() {
        return ConfigHandler.SERVER.CARD_POTION_POINTS.getMapValue().get((Object)this.tier);
    }

    public boolean isCreativeItem() {
        return this.uuid.equals(UUID.fromString("00000000-0000-0000-0000-000000000000"));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MiningSkillCardData)) {
            return false;
        }
        MiningSkillCardData that = (MiningSkillCardData)o;
        return this.uuid.equals(that.uuid) && this.tier == that.tier && ItemStack.isSameItemSameComponents((ItemStack)this.displayItem, (ItemStack)that.displayItem) && this.potionPoints == that.potionPoints && this.challenges.equals(that.challenges) && this.finishedChallenges.equals(that.finishedChallenges);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.uuid, this.tier, this.potionPoints, this.challenges, this.finishedChallenges}) + ItemStack.hashItemAndComponents((ItemStack)this.displayItem);
    }

    public String toString() {
        return "MiningSkillCardData{uuid=" + String.valueOf(this.uuid) + ", tier=" + String.valueOf((Object)this.tier) + ", displayItem=" + String.valueOf(this.displayItem) + ", potionPoints=" + this.potionPoints + ", challenges=" + String.valueOf(this.challenges) + "}";
    }

    public static class ChallengeHolder
    implements Comparable<ChallengeHolder> {
        public static final Codec<ChallengeHolder> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("Id").forGetter(ChallengeHolder::getId), (App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("Order", (Object)0).forGetter(ChallengeHolder::getOrder), (App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("CurrentPoints", (Object)0).forGetter(ChallengeHolder::getCurrentPoints), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("RequiredPoints").forGetter(ChallengeHolder::getRequiredPoints), (App)Codec.BOOL.optionalFieldOf("IsPinned", (Object)false).forGetter(ChallengeHolder::isPinned)).apply((Applicative)instance, ChallengeHolder::new));
        public static final StreamCodec<FriendlyByteBuf, ChallengeHolder> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, ChallengeHolder::getId, (StreamCodec)ByteBufCodecs.INT, ChallengeHolder::getOrder, (StreamCodec)ByteBufCodecs.INT, ChallengeHolder::getCurrentPoints, (StreamCodec)ByteBufCodecs.INT, ChallengeHolder::getRequiredPoints, (StreamCodec)ByteBufCodecs.BOOL, ChallengeHolder::isPinned, ChallengeHolder::new);
        private final ResourceLocation id;
        private final int order;
        private int currentPoints;
        private final int requiredPoints;
        private boolean isPinned;

        private ChallengeHolder() {
            this(ResourceLocation.parse((String)"completed"), 0, 1);
        }

        private ChallengeHolder(ResourceLocation id, int order, int requiredPoints) {
            this(id, order, 0, requiredPoints);
        }

        private ChallengeHolder(ResourceLocation id, int order, int currentPoints, int requiredPoints) {
            this(id, order, currentPoints, requiredPoints, false);
        }

        private ChallengeHolder(ResourceLocation id, int order, int currentPoints, int requiredPoints, boolean isPinned) {
            this.id = id;
            this.order = order;
            this.currentPoints = currentPoints;
            this.requiredPoints = requiredPoints;
            this.isPinned = isPinned;
        }

        @Override
        public int compareTo(@NotNull ChallengeHolder other) {
            return Integer.compare(this.order, other.order);
        }

        public ResourceLocation getId() {
            return this.id;
        }

        public int getOrder() {
            return this.order;
        }

        public void togglePinned() {
            this.isPinned ^= true;
        }

        public void setCurrentPoints(int currentPoints) {
            this.currentPoints = currentPoints;
        }

        public boolean isPinned() {
            return this.isPinned;
        }

        public int getCurrentPoints() {
            return this.currentPoints;
        }

        public int getRequiredPoints() {
            return this.requiredPoints;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ChallengeHolder)) {
                return false;
            }
            ChallengeHolder that = (ChallengeHolder)o;
            return this.id.equals((Object)that.id) && this.order == that.order && this.currentPoints == that.currentPoints && this.requiredPoints == that.requiredPoints && this.isPinned == that.isPinned;
        }

        public int hashCode() {
            return Objects.hash(this.id, this.order, this.currentPoints, this.requiredPoints, this.isPinned);
        }

        public String toString() {
            return "ChallengeHolder{id=" + String.valueOf(this.id) + ", order=" + this.order + ", currentPoints=" + this.currentPoints + ", requiredPoints=" + this.requiredPoints + ", isPinned=" + this.isPinned + "}";
        }
    }
}

