/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.common.data.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.ixdarklord.coolcatlib.api.util.ChatFormattingUtils;
import net.ixdarklord.ultimine_addition.client.handler.ClientMinerCertificateHandler;
import net.ixdarklord.ultimine_addition.common.data.DataHandler;
import net.ixdarklord.ultimine_addition.common.item.MinerCertificateItem;
import net.ixdarklord.ultimine_addition.config.ConfigHandler;
import net.ixdarklord.ultimine_addition.config.PlaystyleMode;
import net.ixdarklord.ultimine_addition.core.ServicePlatform;
import net.ixdarklord.ultimine_addition.network.PayloadHandler;
import net.ixdarklord.ultimine_addition.network.payloads.MinerCertificatePayload;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class MinerCertificateData
extends DataHandler<MinerCertificateData, ItemStack> {
    public static final Codec<MinerCertificateData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Legacy.CODEC.optionalFieldOf("Legacy").forGetter(MinerCertificateData::getLegacy), (App)Codec.BOOL.optionalFieldOf("IsAccomplished", (Object)false).forGetter(MinerCertificateData::isAccomplished)).apply((Applicative)instance, MinerCertificateData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, MinerCertificateData> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, MinerCertificateData>(){

        @NotNull
        public MinerCertificateData decode(RegistryFriendlyByteBuf buf) {
            return new MinerCertificateData(buf.readOptional(Legacy.STREAM_CODEC), buf.readBoolean()).completeSound(buf.readBoolean()).playCelebration(buf.readBoolean());
        }

        public void encode(RegistryFriendlyByteBuf buf, MinerCertificateData data) {
            buf.writeOptional(data.legacy, Legacy.STREAM_CODEC);
            buf.writeBoolean(data.isAccomplished);
            buf.writeBoolean(data.completeSound);
            buf.writeBoolean(data.isCelebration);
        }
    };
    public static final DataComponentType<MinerCertificateData> DATA_COMPONENT = DataComponentType.builder().persistent(CODEC).networkSynchronized(STREAM_CODEC).build();
    private Optional<Legacy> legacy;
    private boolean isAccomplished;
    private boolean isCelebration;
    private boolean completeSound;

    private MinerCertificateData() {
        this(Optional.empty(), false);
    }

    private MinerCertificateData(Optional<Legacy> legacy, boolean isAccomplished) {
        this.legacy = legacy;
        this.legacy.ifPresent(l -> {
            l.data = this;
        });
        this.isAccomplished = isAccomplished;
    }

    public static MinerCertificateData create() {
        return new MinerCertificateData();
    }

    public static MinerCertificateData loadData(ItemStack stack) {
        return (MinerCertificateData)((MinerCertificateData)stack.getOrDefault(DATA_COMPONENT, (Object)MinerCertificateData.create())).setDataHolder(stack);
    }

    @Override
    public void saveData(ItemStack stack) {
        stack.set(DATA_COMPONENT, (Object)this);
        super.saveData(stack);
    }

    public MinerCertificateData sendToClient(int slotIndex, ServerPlayer player) {
        PayloadHandler.sendToPlayer(new MinerCertificatePayload(slotIndex, this), player);
        return this;
    }

    public void tick(int slotIndex, ServerPlayer player) {
        if (ConfigHandler.COMMON.PLAYSTYLE_MODE.get() == PlaystyleMode.LEGACY && this.legacy.isEmpty()) {
            int min = ConfigHandler.SERVER.LEGACY_REQUIRED_AMOUNT.getMin();
            int max = ConfigHandler.SERVER.LEGACY_REQUIRED_AMOUNT.getMax();
            this.legacy = Optional.of(new Legacy(RandomSource.create().nextIntBetweenInclusive(min, max)));
            this.saveData((ItemStack)this.get());
        }
        if (this.legacy.isPresent()) {
            if (!this.isAccomplished && this.legacy.get().getMinedBlocks() == this.legacy.get().getRequiredAmount()) {
                this.completeSound(true).setAccomplished(true).sendToClient(slotIndex, player).saveData((ItemStack)this.get());
            }
        } else if (!this.isAccomplished) {
            this.completeSound(true).setAccomplished(true).sendToClient(slotIndex, player).saveData((ItemStack)this.get());
        }
    }

    public Optional<Legacy> getLegacy() {
        return this.legacy;
    }

    public boolean isAccomplished() {
        return this.isAccomplished;
    }

    public MinerCertificateData setAccomplished(boolean state) {
        this.isAccomplished = state;
        return this;
    }

    public MinerCertificateData playCelebration(boolean state) {
        this.isCelebration = state;
        return this;
    }

    public MinerCertificateData completeSound(boolean state) {
        this.completeSound = state;
        return this;
    }

    @Override
    public MinerCertificateData clientUpdate() {
        if (Objects.requireNonNull((ItemStack)this.get()).getItem() instanceof MinerCertificateItem && this.completeSound) {
            ClientMinerCertificateHandler.playClientSound();
        }
        if (Objects.requireNonNull((ItemStack)this.get()).getItem() instanceof MinerCertificateItem && this.isCelebration) {
            ClientMinerCertificateHandler.playAnimation((ItemStack)this.get());
        }
        return this;
    }

    public MinerCertificateData sendClientMessage(Player player) {
        if (!ServicePlatform.get().players().isPlayerUltimineCapable(player)) {
            player.displayClientMessage((Component)Component.translatable((String)"info.ultimine_addition.obtain").withStyle(ChatFormatting.GOLD), true);
        } else {
            player.displayClientMessage((Component)Component.translatable((String)"info.ultimine_addition.obtained_already").withStyle(ChatFormatting.RED), true);
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MinerCertificateData)) {
            return false;
        }
        MinerCertificateData data = (MinerCertificateData)o;
        return this.isAccomplished == data.isAccomplished && this.isCelebration == data.isCelebration && this.completeSound == data.completeSound && Objects.equals(this.legacy, data.legacy);
    }

    public int hashCode() {
        return Objects.hash(this.legacy, this.isAccomplished, this.isCelebration, this.completeSound);
    }

    public static class Legacy {
        public static final Codec<Legacy> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("mined_blocks", (Object)0).forGetter(Legacy::getMinedBlocks), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("required_amount").forGetter(Legacy::getRequiredAmount)).apply((Applicative)instance, Legacy::new));
        public static final StreamCodec<? super FriendlyByteBuf, Legacy> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, Legacy::getMinedBlocks, (StreamCodec)ByteBufCodecs.INT, Legacy::getRequiredAmount, Legacy::new);
        private MinerCertificateData data;
        private int minedBlocks;
        private final int requiredAmount;

        public Legacy(int requiredAmount) {
            this(0, requiredAmount);
        }

        private Legacy(int minedBlocks, int requiredAmount) {
            this.minedBlocks = minedBlocks;
            this.requiredAmount = requiredAmount;
        }

        public int getRequiredAmount() {
            return this.requiredAmount;
        }

        public int getMinedBlocks() {
            return this.minedBlocks;
        }

        public void addPoint(int sum) {
            this.minedBlocks = Math.min(this.minedBlocks + sum, this.requiredAmount);
        }

        public void createInfoComponent(List<Component> tooltipComponents, boolean isShiftPressed) {
            if (!((ItemStack)this.data.get()).has(DATA_COMPONENT)) {
                if (isShiftPressed) {
                    tooltipComponents.add((Component)Component.translatable((String)"tooltip.ultimine_addition.certificate.legacy.info"));
                }
                return;
            }
            if (!isShiftPressed) {
                if (!this.data.isAccomplished) {
                    tooltipComponents.add(1, this.createBrackets((Component)Component.translatable((String)"tooltip.ultimine_addition.certificate.legacy.sealed").withStyle(ChatFormatting.GRAY)));
                } else {
                    tooltipComponents.add(1, this.createBrackets((Component)Component.translatable((String)"tooltip.ultimine_addition.certificate.legacy.opened").withStyle(ChatFormatting.GOLD)));
                }
            } else if (!this.data.isAccomplished) {
                ChatFormatting[] formatting = ChatFormattingUtils.get3LevelChatFormatting((int)this.minedBlocks, (int)this.requiredAmount);
                MutableComponent component = Component.literal((String)String.valueOf(this.minedBlocks)).withStyle(formatting);
                tooltipComponents.add((Component)Component.translatable((String)"tooltip.ultimine_addition.certificate.legacy.quest.info", (Object[])new Object[]{this.requiredAmount}).withStyle(ChatFormatting.DARK_AQUA));
                tooltipComponents.add((Component)Component.literal((String)"\u27a4 ").withStyle(ChatFormatting.DARK_GRAY).append((Component)Component.translatable((String)"tooltip.ultimine_addition.certificate.legacy.quest", (Object[])new Object[]{component}).withStyle(ChatFormatting.GRAY)));
            } else {
                tooltipComponents.add((Component)Component.translatable((String)"tooltip.ultimine_addition.certificate.legacy.quest.congrats", (Object[])new Object[]{this.minedBlocks}).withStyle(ChatFormatting.GREEN));
            }
        }

        private Component createBrackets(Component component) {
            return Component.literal((String)"\u300e").withStyle(ChatFormatting.DARK_GRAY).append(component).append((Component)Component.literal((String)"\u300f").withStyle(ChatFormatting.DARK_GRAY));
        }
    }
}

