/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.common.data.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.ixdarklord.ultimine_addition.common.data.DataHandler;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public class ItemStorageData
extends DataHandler<ItemStorageData, ItemStack> {
    public static final Codec<ItemStorageData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("StorageName").forGetter(ItemStorageData::getStorageName), (App)Codec.INT.fieldOf("Capacity").forGetter(ItemStorageData::getCapacity), (App)Codec.INT.fieldOf("MaxCapacity").forGetter(ItemStorageData::getMaxCapacity)).apply((Applicative)instance, ItemStorageData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemStorageData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, ItemStorageData::getStorageName, (StreamCodec)ByteBufCodecs.INT, ItemStorageData::getCapacity, (StreamCodec)ByteBufCodecs.INT, ItemStorageData::getMaxCapacity, ItemStorageData::new);
    public static final DataComponentType<ItemStorageData> DATA_COMPONENT = DataComponentType.builder().persistent(CODEC).networkSynchronized(STREAM_CODEC).build();
    private final String storageName;
    private int capacity;
    private final int maxCapacity;

    private ItemStorageData(String storageName, int maxCapacity) {
        this(storageName, 0, maxCapacity);
    }

    private ItemStorageData(String storageName, int capacity, int maxCapacity) {
        this.storageName = storageName;
        this.capacity = capacity;
        this.maxCapacity = maxCapacity;
    }

    public static ItemStorageData create(String storageName, int maxCapacity) {
        return new ItemStorageData(storageName, maxCapacity);
    }

    public static ItemStorageData loadData(String storageName, int maxCapacity, ItemStack stack) {
        return (ItemStorageData)((ItemStorageData)stack.getOrDefault(DATA_COMPONENT, (Object)ItemStorageData.create(storageName, maxCapacity))).setDataHolder(stack);
    }

    @Override
    public void saveData(ItemStack stack) {
        stack.set(DATA_COMPONENT, (Object)this);
        super.saveData(stack);
    }

    public String getStorageName() {
        return this.storageName;
    }

    public int getMaxCapacity() {
        return this.maxCapacity;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public ItemStorageData setToFullCapacity() {
        this.capacity = this.maxCapacity;
        return this;
    }

    public ItemStorageData setCapacity(int amount) {
        this.capacity = Math.min(amount, this.maxCapacity);
        return this;
    }

    public ItemStorageData removeAmount(int amount) {
        this.capacity -= Math.max(0, amount);
        return this;
    }

    public boolean isFull() {
        return this.capacity >= this.maxCapacity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ItemStorageData)) {
            return false;
        }
        ItemStorageData data = (ItemStorageData)o;
        return this.capacity == data.capacity && this.maxCapacity == data.maxCapacity && Objects.equals(this.storageName, data.storageName);
    }

    public int hashCode() {
        return Objects.hash(this.storageName, this.capacity, this.maxCapacity);
    }
}

