/*
 * Decompiled with CFR 0.152.
 */
package net.ixdarklord.ultimine_addition.common.data.challenge;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.ixdarklord.ultimine_addition.config.ConfigHandler;
import net.ixdarklord.ultimine_addition.core.FTBUltimineAddition;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;

public class IneligibleBlocksSavedData
extends SavedData {
    public static final String DATA_KEY = "ultimine_addition.ineligible_blocks";
    private final ServerLevel level;
    private final Map<ChunkPos, List<BlockEntry>> chunkEntries;

    public IneligibleBlocksSavedData(ServerLevel level, Map<ChunkPos, List<BlockEntry>> chunkEntries) {
        this.level = level;
        this.chunkEntries = chunkEntries;
    }

    public void add(Entity entity, BlockInfo blockInfo) {
        ResourceLocation entityId = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType());
        UUID entityUUID = entity.getUUID();
        ChunkPos chunkPos = this.level.getChunk(blockInfo.pos).getPos();
        List blockEntryList = this.chunkEntries.computeIfAbsent(chunkPos, k -> new ArrayList());
        Optional<BlockEntry> existingEntry = blockEntryList.stream().filter(entry -> entry.placerData.entityId.equals((Object)entityId) && entry.placerData.entityUUID.equals(entityUUID)).findFirst();
        if (existingEntry.isPresent()) {
            blockEntry = existingEntry.get();
            if (!blockEntry.placedBlocks.contains(blockInfo)) {
                blockEntry.placedBlocks.add(blockInfo);
                this.setDirty();
            }
        } else {
            blockEntry = new BlockEntry(new PlacerData(entityId, entityUUID), new ArrayList<BlockInfo>(Collections.singletonList(blockInfo)));
            blockEntryList.add(blockEntry);
            this.setDirty();
        }
        if (((Boolean)ConfigHandler.SERVER.INELIGIBLE_BLOCKS_LOGGER.get()).booleanValue()) {
            ResourceLocation blockId = BuiltInRegistries.BLOCK.getKey((Object)blockInfo.blockState.getBlock());
            FTBUltimineAddition.LOGGER.debug("[Ineligible Blocks] Block added at: {} with ID: {} by {}", (Object)blockInfo.pos, (Object)blockId, (Object)entityId);
        }
    }

    public void remove(BlockPos pos) {
        ChunkPos chunkPos = this.level.getChunk(pos).getPos();
        List<BlockEntry> blockEntryList = this.chunkEntries.get(chunkPos);
        if (blockEntryList == null) {
            return;
        }
        boolean isDirty = false;
        BlockState removedBlockState = null;
        Iterator<BlockEntry> blockEntryIterator = blockEntryList.iterator();
        while (blockEntryIterator.hasNext()) {
            BlockEntry blockEntry = blockEntryIterator.next();
            Iterator<BlockInfo> blockInfoIterator = blockEntry.placedBlocks.iterator();
            while (blockInfoIterator.hasNext()) {
                BlockInfo blockInfo = blockInfoIterator.next();
                if (!blockInfo.pos.equals((Object)pos)) continue;
                removedBlockState = blockInfo.blockState;
                blockInfoIterator.remove();
                isDirty = true;
            }
            if (!blockEntry.placedBlocks.isEmpty()) continue;
            blockEntryIterator.remove();
            isDirty = true;
        }
        if (blockEntryList.isEmpty()) {
            this.chunkEntries.remove(chunkPos);
            isDirty = true;
        }
        if (isDirty) {
            this.setDirty();
            if (((Boolean)ConfigHandler.SERVER.INELIGIBLE_BLOCKS_LOGGER.get()).booleanValue() && removedBlockState != null) {
                ResourceLocation blockId = BuiltInRegistries.BLOCK.getKey((Object)removedBlockState.getBlock());
                FTBUltimineAddition.LOGGER.debug("[Ineligible Blocks] Block removed at: {} with ID: {}", (Object)pos, (Object)blockId);
            }
        }
    }

    public boolean isBlockPlacedByEntity(BlockPos pos) {
        return this.chunkEntries.values().stream().flatMap(Collection::stream).flatMap(blockEntry -> blockEntry.placedBlocks.stream()).anyMatch(blockInfo -> blockInfo.pos.equals((Object)pos));
    }

    public Map<ChunkPos, List<BlockEntry>> getChunkEntries() {
        return this.chunkEntries;
    }

    public static IneligibleBlocksSavedData getOrCreate(ServerLevel level) {
        return (IneligibleBlocksSavedData)level.getDataStorage().computeIfAbsent(IneligibleBlocksSavedData.getFactory(level), DATA_KEY);
    }

    public static SavedData.Factory<IneligibleBlocksSavedData> getFactory(ServerLevel level) {
        return new SavedData.Factory(() -> IneligibleBlocksSavedData.create(level), (NBT, provider) -> IneligibleBlocksSavedData.load(level, NBT), DataFixTypes.LEVEL);
    }

    private static IneligibleBlocksSavedData create(ServerLevel level) {
        return new IneligibleBlocksSavedData(level, new HashMap<ChunkPos, List<BlockEntry>>());
    }

    private static IneligibleBlocksSavedData load(ServerLevel level, CompoundTag NBT) {
        return new IneligibleBlocksSavedData(level, IneligibleBlocksSavedData.deserializeChunkEntries(NBT));
    }

    @NotNull
    public CompoundTag save(CompoundTag NBT, HolderLookup.Provider registries) {
        NBT.merge(this.serializeChunkEntries());
        return NBT;
    }

    private CompoundTag serializeChunkEntries() {
        ListTag entriesTagList = new ListTag();
        for (Map.Entry<ChunkPos, List<BlockEntry>> entry : this.chunkEntries.entrySet()) {
            ChunkPos chunkPos = entry.getKey();
            List<BlockEntry> blockEntryList = entry.getValue();
            CompoundTag entryTag = new CompoundTag();
            entryTag.put("ChunkPos", (Tag)IneligibleBlocksSavedData.writeChunkPos(chunkPos));
            entryTag.put("BlockEntries", (Tag)blockEntryList.stream().map(BlockEntry::serialize).collect(ListTag::new, AbstractList::add, AbstractCollection::addAll));
            entriesTagList.add((Object)entryTag);
        }
        CompoundTag finalTag = new CompoundTag();
        finalTag.put("ChunkEntries", (Tag)entriesTagList);
        return finalTag;
    }

    private static Map<ChunkPos, List<BlockEntry>> deserializeChunkEntries(CompoundTag tag) {
        HashMap<ChunkPos, List<BlockEntry>> chunkEntries = new HashMap<ChunkPos, List<BlockEntry>>();
        ListTag entriesListTag = tag.getList("ChunkEntries", 10);
        for (int i = 0; i < entriesListTag.size(); ++i) {
            CompoundTag entryTag = entriesListTag.getCompound(i);
            ChunkPos chunkPos = IneligibleBlocksSavedData.readChunkPos(entryTag.getCompound("ChunkPos"));
            List<BlockEntry> blockEntryList = entryTag.getList("BlockEntries", 10).stream().map(blockEntryTag -> BlockEntry.deserialize((CompoundTag)blockEntryTag)).toList();
            chunkEntries.put(chunkPos, new ArrayList<BlockEntry>(blockEntryList));
        }
        return chunkEntries;
    }

    private static CompoundTag writeChunkPos(ChunkPos chunkPos) {
        CompoundTag NBT = new CompoundTag();
        NBT.putInt("X", chunkPos.x);
        NBT.putInt("Z", chunkPos.z);
        return NBT;
    }

    private static ChunkPos readChunkPos(CompoundTag tag) {
        return new ChunkPos(tag.getInt("X"), tag.getInt("Z"));
    }

    public void validateBlocks(ServerLevel level) {
        boolean isDirty = false;
        Iterator<Map.Entry<ChunkPos, List<BlockEntry>>> chunkIterator = this.chunkEntries.entrySet().iterator();
        while (chunkIterator.hasNext()) {
            Map.Entry<ChunkPos, List<BlockEntry>> entry = chunkIterator.next();
            List<BlockEntry> blockEntryList = entry.getValue();
            Iterator<BlockEntry> blockEntryIterator = blockEntryList.iterator();
            while (blockEntryIterator.hasNext()) {
                BlockEntry blockEntry = blockEntryIterator.next();
                Iterator<BlockInfo> blockInfoIterator = blockEntry.placedBlocks.iterator();
                while (blockInfoIterator.hasNext()) {
                    BlockInfo blockInfo = blockInfoIterator.next();
                    if (level.getBlockState(blockInfo.pos).is(blockInfo.blockState.getBlock())) continue;
                    blockInfoIterator.remove();
                    isDirty = true;
                }
                if (!blockEntry.placedBlocks.isEmpty()) continue;
                blockEntryIterator.remove();
                isDirty = true;
            }
            if (!blockEntryList.isEmpty()) continue;
            chunkIterator.remove();
            isDirty = true;
        }
        if (isDirty) {
            this.setDirty();
        }
    }

    public record BlockInfo(BlockPos pos, BlockState blockState) {
        @Override
        public String toString() {
            return "{\"State\": \"%s\", \"Pos\": \"%s\"}".formatted(NbtUtils.writeBlockState((BlockState)this.blockState), NbtUtils.writeBlockPos((BlockPos)this.pos));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object o) {
            BlockPos pos1;
            BlockPos blockPos;
            if (!(o instanceof BlockInfo)) return false;
            BlockInfo blockInfo = (BlockInfo)o;
            try {
                pos1 = blockPos = blockInfo.pos();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            BlockPos state = blockPos = blockInfo.blockState();
            if (!Objects.equals(this.blockState, state)) return false;
            if (!Objects.equals(this.pos, pos1)) return false;
            return true;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.blockState, this.pos);
        }
    }

    public record BlockEntry(PlacerData placerData, List<BlockInfo> placedBlocks) {
        public CompoundTag serialize() {
            CompoundTag tag = new CompoundTag();
            ListTag blocksList = new ListTag();
            for (BlockInfo info : this.placedBlocks) {
                CompoundTag blockTag = new CompoundTag();
                blockTag.put("State", (Tag)NbtUtils.writeBlockState((BlockState)info.blockState));
                blockTag.put("Pos", NbtUtils.writeBlockPos((BlockPos)info.pos));
                blocksList.add((Object)blockTag);
            }
            CompoundTag placer = new CompoundTag();
            placer.putString("Id", this.placerData.entityId.toString());
            placer.putUUID("UUID", this.placerData.entityUUID);
            tag.put("Placer", (Tag)placer);
            tag.put("Blocks", (Tag)blocksList);
            return tag;
        }

        public static BlockEntry deserialize(CompoundTag tag) {
            CompoundTag placer = tag.getCompound("Placer");
            ResourceLocation id = ResourceLocation.parse((String)placer.getString("Id"));
            UUID uuid = placer.getUUID("UUID");
            ArrayList<BlockInfo> blockInfoList = new ArrayList<BlockInfo>();
            ListTag blocksListTag = tag.getList("Blocks", 10);
            for (int i = 0; i < blocksListTag.size(); ++i) {
                CompoundTag tag2 = blocksListTag.getCompound(i);
                CompoundTag stateTag = tag2.getCompound("State");
                BlockState blockState = NbtUtils.readBlockState((HolderGetter)BuiltInRegistries.BLOCK.asLookup(), (CompoundTag)stateTag);
                Optional blockPos = NbtUtils.readBlockPos((CompoundTag)tag2, (String)"Pos");
                blockPos.ifPresent(pos -> blockInfoList.add(new BlockInfo((BlockPos)pos, blockState)));
            }
            return new BlockEntry(new PlacerData(id, uuid), blockInfoList);
        }
    }

    public record PlacerData(ResourceLocation entityId, UUID entityUUID) {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object o) {
            ResourceLocation id;
            Object object;
            if (!(o instanceof PlacerData)) return false;
            PlacerData placerData = (PlacerData)o;
            try {
                id = object = placerData.entityId();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            Object uuid = object = placerData.entityUUID();
            if (!Objects.equals(this.entityUUID, uuid)) return false;
            if (!Objects.equals(this.entityId, id)) return false;
            return true;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.entityId, this.entityUUID);
        }
    }
}

